<?php
return array(
	'slideshows' => array(
		'key' => 'slideshowid',
		'fields' => array(
			'slideshowid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'delay' => DB::FIELD_TYPE_INT,
		),
	),
	'slides' => array(
		'key' => 'slideid',
		'fields' => array(
			'slideid' => DB::FIELD_TYPE_INT,
			'slideshowid' => DB::FIELD_TYPE_INT,
			'screenid' => DB::FIELD_TYPE_INT,
			'step' => DB::FIELD_TYPE_INT,
			'delay' => DB::FIELD_TYPE_INT,
		),
	),
	'drules' => array(
		'key' => 'druleid',
		'fields' => array(
			'druleid' => DB::FIELD_TYPE_INT,
			'proxy_hostid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'iprange' => DB::FIELD_TYPE_STR,
			'delay' => DB::FIELD_TYPE_INT,
			'nextcheck' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'unique_dcheckid' => DB::FIELD_TYPE_INT,
		),
	),
	'dchecks' => array(
		'key' => 'dcheckid',
		'fields' => array(
			'dcheckid' => DB::FIELD_TYPE_INT,
			'druleid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'key_' => DB::FIELD_TYPE_STR,
			'snmp_community' => DB::FIELD_TYPE_STR,
			'ports' => DB::FIELD_TYPE_STR,
		),
	),
	'dhosts' => array(
		'key' => 'dhostid',
		'fields' => array(
			'dhostid' => DB::FIELD_TYPE_INT,
			'druleid' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'lastup' => DB::FIELD_TYPE_INT,
			'lastdown' => DB::FIELD_TYPE_INT,
		),
	),
	'dservices' => array(
		'key' => 'dserviceid',
		'fields' => array(
			'dserviceid' => DB::FIELD_TYPE_INT,
			'dhostid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'key_' => DB::FIELD_TYPE_STR,
			'value' => DB::FIELD_TYPE_STR,
			'port' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'lastup' => DB::FIELD_TYPE_INT,
			'lastdown' => DB::FIELD_TYPE_INT,
			'dcheckid' => DB::FIELD_TYPE_INT,
			'ip' => DB::FIELD_TYPE_STR,
			'nodeid' => DB::FIELD_TYPE_INT,
			'table_name' => DB::FIELD_TYPE_STR,
			'field_name' => DB::FIELD_TYPE_STR,
			'nextid' => DB::FIELD_TYPE_INT,
		),
	),
	'httptest' => array(
		'key' => 'httptestid',
		'fields' => array(
			'httptestid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'applicationid' => DB::FIELD_TYPE_INT,
			'lastcheck' => DB::FIELD_TYPE_INT,
			'nextcheck' => DB::FIELD_TYPE_INT,
			'curstate' => DB::FIELD_TYPE_INT,
			'curstep' => DB::FIELD_TYPE_INT,
			'lastfailedstep' => DB::FIELD_TYPE_INT,
			'delay' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'macros' => DB::FIELD_TYPE_STR,
			'agent' => DB::FIELD_TYPE_STR,
			'time' => DB::FIELD_TYPE_INT,
			'error' => DB::FIELD_TYPE_STR,
			'authentication' => DB::FIELD_TYPE_INT,
			'http_user' => DB::FIELD_TYPE_STR,
			'http_password' => DB::FIELD_TYPE_STR,
		),
	),
	'httpstep' => array(
		'key' => 'httpstepid',
		'fields' => array(
			'httpstepid' => DB::FIELD_TYPE_INT,
			'httptestid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'no' => DB::FIELD_TYPE_INT,
			'url' => DB::FIELD_TYPE_STR,
			'timeout' => DB::FIELD_TYPE_INT,
			'posts' => DB::FIELD_TYPE_STR,
			'required' => DB::FIELD_TYPE_STR,
			'status_codes' => DB::FIELD_TYPE_STR,
		),
	),
	'httpstepitem' => array(
		'key' => 'httpstepitemid',
		'fields' => array(
			'httpstepitemid' => DB::FIELD_TYPE_INT,
			'httpstepid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
		),
	),
	'httptestitem' => array(
		'key' => 'httptestitemid',
		'fields' => array(
			'httptestitemid' => DB::FIELD_TYPE_INT,
			'httptestid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
		),
	),
	'nodes' => array(
		'key' => 'nodeid',
		'fields' => array(
			'nodeid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'timezone' => DB::FIELD_TYPE_INT,
			'ip' => DB::FIELD_TYPE_STR,
			'port' => DB::FIELD_TYPE_INT,
			'slave_history' => DB::FIELD_TYPE_INT,
			'slave_trends' => DB::FIELD_TYPE_INT,
			'nodetype' => DB::FIELD_TYPE_INT,
			'masterid' => DB::FIELD_TYPE_INT,
			'tablename' => DB::FIELD_TYPE_STR,
			'recordid' => DB::FIELD_TYPE_INT,
			'cksumtype' => DB::FIELD_TYPE_INT,
			'cksum' => DB::FIELD_TYPE_STR,
			'sync' => DB::FIELD_TYPE_STR,
		),
	),
	'services_times' => array(
		'key' => 'timeid',
		'fields' => array(
			'timeid' => DB::FIELD_TYPE_INT,
			'serviceid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'ts_from' => DB::FIELD_TYPE_INT,
			'ts_to' => DB::FIELD_TYPE_INT,
			'note' => DB::FIELD_TYPE_STR,
		),
	),
	'alerts' => array(
		'key' => 'alertid',
		'fields' => array(
			'alertid' => DB::FIELD_TYPE_INT,
			'actionid' => DB::FIELD_TYPE_INT,
			'eventid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'mediatypeid' => DB::FIELD_TYPE_INT,
			'sendto' => DB::FIELD_TYPE_STR,
			'subject' => DB::FIELD_TYPE_STR,
			'message' => DB::FIELD_TYPE_STR,
			'status' => DB::FIELD_TYPE_INT,
			'retries' => DB::FIELD_TYPE_INT,
			'error' => DB::FIELD_TYPE_STR,
			'nextcheck' => DB::FIELD_TYPE_INT,
			'esc_step' => DB::FIELD_TYPE_INT,
			'alerttype' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_INT,
		),
	),
	'history_sync' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'nodeid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_INT,
		),
	),
	'history_uint_sync' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'nodeid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'history_str_sync' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'nodeid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'history_log' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'timestamp' => DB::FIELD_TYPE_INT,
			'source' => DB::FIELD_TYPE_STR,
			'severity' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
			'logeventid' => DB::FIELD_TYPE_INT,
		),
	),
	'history_text' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'proxy_history' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'timestamp' => DB::FIELD_TYPE_INT,
			'source' => DB::FIELD_TYPE_STR,
			'severity' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
			'logeventid' => DB::FIELD_TYPE_INT,
		),
	),
	'proxy_dhistory' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'druleid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'ip' => DB::FIELD_TYPE_STR,
			'port' => DB::FIELD_TYPE_INT,
			'key_' => DB::FIELD_TYPE_STR,
			'value' => DB::FIELD_TYPE_STR,
			'status' => DB::FIELD_TYPE_INT,
			'dcheckid' => DB::FIELD_TYPE_INT,
		),
	),
	'events' => array(
		'key' => 'eventid',
		'fields' => array(
			'eventid' => DB::FIELD_TYPE_INT,
			'source' => DB::FIELD_TYPE_INT,
			'object' => DB::FIELD_TYPE_INT,
			'objectid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_INT,
			'acknowledged' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'num' => DB::FIELD_TYPE_INT,
			'value_min' => DB::FIELD_TYPE_INT,
			'value_avg' => DB::FIELD_TYPE_INT,
			'value_max' => DB::FIELD_TYPE_INT,
		),
	),
	'acknowledges' => array(
		'key' => 'acknowledgeid',
		'fields' => array(
			'acknowledgeid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
			'eventid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'message' => DB::FIELD_TYPE_STR,
		),
	),
	'auditlog' => array(
		'key' => 'auditid',
		'fields' => array(
			'auditid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'action' => DB::FIELD_TYPE_INT,
			'resourcetype' => DB::FIELD_TYPE_INT,
			'details' => DB::FIELD_TYPE_STR,
			'ip' => DB::FIELD_TYPE_STR,
			'resourceid' => DB::FIELD_TYPE_INT,
			'resourcename' => DB::FIELD_TYPE_STR,
		),
	),
	'auditlog_details' => array(
		'key' => 'auditdetailid',
		'fields' => array(
			'auditdetailid' => DB::FIELD_TYPE_INT,
			'auditid' => DB::FIELD_TYPE_INT,
			'table_name' => DB::FIELD_TYPE_STR,
			'field_name' => DB::FIELD_TYPE_STR,
			'oldvalue' => DB::FIELD_TYPE_STR,
			'newvalue' => DB::FIELD_TYPE_STR,
		),
	),
	'service_alarms' => array(
		'key' => 'servicealarmid',
		'fields' => array(
			'servicealarmid' => DB::FIELD_TYPE_INT,
			'serviceid' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_INT,
		),
	),
	'actions' => array(
		'key' => 'actionid',
		'fields' => array(
			'actionid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'eventsource' => DB::FIELD_TYPE_INT,
			'evaltype' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'esc_period' => DB::FIELD_TYPE_INT,
			'def_shortdata' => DB::FIELD_TYPE_STR,
			'def_longdata' => DB::FIELD_TYPE_STR,
			'recovery_msg' => DB::FIELD_TYPE_INT,
			'r_shortdata' => DB::FIELD_TYPE_STR,
			'r_longdata' => DB::FIELD_TYPE_STR,
		),
	),
	'operations' => array(
		'key' => 'operationid',
		'fields' => array(
			'operationid' => DB::FIELD_TYPE_INT,
			'actionid' => DB::FIELD_TYPE_INT,
			'operationtype' => DB::FIELD_TYPE_INT,
			'object' => DB::FIELD_TYPE_INT,
			'objectid' => DB::FIELD_TYPE_INT,
			'shortdata' => DB::FIELD_TYPE_STR,
			'longdata' => DB::FIELD_TYPE_STR,
			'esc_period' => DB::FIELD_TYPE_INT,
			'esc_step_from' => DB::FIELD_TYPE_INT,
			'esc_step_to' => DB::FIELD_TYPE_INT,
			'default_msg' => DB::FIELD_TYPE_INT,
			'evaltype' => DB::FIELD_TYPE_INT,
		),
	),
	'opconditions' => array(
		'key' => 'opconditionid',
		'fields' => array(
			'opconditionid' => DB::FIELD_TYPE_INT,
			'operationid' => DB::FIELD_TYPE_INT,
			'conditiontype' => DB::FIELD_TYPE_INT,
			'operator' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'opmediatypes' => array(
		'key' => 'opmediatypeid',
		'fields' => array(
			'opmediatypeid' => DB::FIELD_TYPE_INT,
			'operationid' => DB::FIELD_TYPE_INT,
			'mediatypeid' => DB::FIELD_TYPE_INT,
		),
	),
	'escalations' => array(
		'key' => 'escalationid',
		'fields' => array(
			'escalationid' => DB::FIELD_TYPE_INT,
			'actionid' => DB::FIELD_TYPE_INT,
			'triggerid' => DB::FIELD_TYPE_INT,
			'eventid' => DB::FIELD_TYPE_INT,
			'r_eventid' => DB::FIELD_TYPE_INT,
			'nextcheck' => DB::FIELD_TYPE_INT,
			'esc_step' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
		),
	),
	'applications' => array(
		'key' => 'applicationid',
		'fields' => array(
			'applicationid' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'templateid' => DB::FIELD_TYPE_INT,
		),
	),
	'conditions' => array(
		'key' => 'conditionid',
		'fields' => array(
			'conditionid' => DB::FIELD_TYPE_INT,
			'actionid' => DB::FIELD_TYPE_INT,
			'conditiontype' => DB::FIELD_TYPE_INT,
			'operator' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'config' => array(
		'key' => 'configid',
		'fields' => array(
			'configid' => DB::FIELD_TYPE_INT,
			'alert_history' => DB::FIELD_TYPE_INT,
			'event_history' => DB::FIELD_TYPE_INT,
			'refresh_unsupported' => DB::FIELD_TYPE_INT,
			'work_period' => DB::FIELD_TYPE_STR,
			'alert_usrgrpid' => DB::FIELD_TYPE_INT,
			'event_ack_enable' => DB::FIELD_TYPE_INT,
			'event_expire' => DB::FIELD_TYPE_INT,
			'event_show_max' => DB::FIELD_TYPE_INT,
			'default_theme' => DB::FIELD_TYPE_STR,
			'authentication_type' => DB::FIELD_TYPE_INT,
			'ldap_host' => DB::FIELD_TYPE_STR,
			'ldap_port' => DB::FIELD_TYPE_INT,
			'ldap_base_dn' => DB::FIELD_TYPE_STR,
			'ldap_bind_dn' => DB::FIELD_TYPE_STR,
			'ldap_bind_password' => DB::FIELD_TYPE_STR,
			'ldap_search_attribute' => DB::FIELD_TYPE_STR,
			'dropdown_first_entry' => DB::FIELD_TYPE_INT,
			'dropdown_first_remember' => DB::FIELD_TYPE_INT,
			'discovery_groupid' => DB::FIELD_TYPE_INT,
			'max_in_table' => DB::FIELD_TYPE_INT,
			'search_limit' => DB::FIELD_TYPE_INT,
		),
	),
	'functions' => array(
		'key' => 'functionid',
		'fields' => array(
			'functionid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'triggerid' => DB::FIELD_TYPE_INT,
			'lastvalue' => DB::FIELD_TYPE_STR,
			'function' => DB::FIELD_TYPE_STR,
			'parameter' => DB::FIELD_TYPE_STR,
		),
	),
	'graphs' => array(
		'key' => 'graphid',
		'fields' => array(
			'graphid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'width' => DB::FIELD_TYPE_INT,
			'height' => DB::FIELD_TYPE_INT,
			'yaxismin' => DB::FIELD_TYPE_INT,
			'yaxismax' => DB::FIELD_TYPE_INT,
			'templateid' => DB::FIELD_TYPE_INT,
			'show_work_period' => DB::FIELD_TYPE_INT,
			'show_triggers' => DB::FIELD_TYPE_INT,
			'graphtype' => DB::FIELD_TYPE_INT,
			'show_legend' => DB::FIELD_TYPE_INT,
			'percent_left' => DB::FIELD_TYPE_INT,
			'percent_right' => DB::FIELD_TYPE_INT,
			'ymin_type' => DB::FIELD_TYPE_INT,
			'ymax_type' => DB::FIELD_TYPE_INT,
			'ymin_itemid' => DB::FIELD_TYPE_INT,
			'ymax_itemid' => DB::FIELD_TYPE_INT,
		),
	),
	'graphs_items' => array(
		'key' => 'gitemid',
		'fields' => array(
			'gitemid' => DB::FIELD_TYPE_INT,
			'graphid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
			'drawtype' => DB::FIELD_TYPE_INT,
			'sortorder' => DB::FIELD_TYPE_INT,
			'color' => DB::FIELD_TYPE_STR,
			'yaxisside' => DB::FIELD_TYPE_INT,
			'calc_fnc' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'periods_cnt' => DB::FIELD_TYPE_INT,
		),
	),
	'graph_theme' => array(
		'key' => 'graphthemeid',
		'fields' => array(
			'graphthemeid' => DB::FIELD_TYPE_INT,
			'description' => DB::FIELD_TYPE_STR,
			'theme' => DB::FIELD_TYPE_STR,
			'backgroundcolor' => DB::FIELD_TYPE_STR,
			'graphcolor' => DB::FIELD_TYPE_STR,
			'graphbordercolor' => DB::FIELD_TYPE_STR,
			'gridcolor' => DB::FIELD_TYPE_STR,
			'maingridcolor' => DB::FIELD_TYPE_STR,
			'gridbordercolor' => DB::FIELD_TYPE_STR,
			'textcolor' => DB::FIELD_TYPE_STR,
			'highlightcolor' => DB::FIELD_TYPE_STR,
			'leftpercentilecolor' => DB::FIELD_TYPE_STR,
			'rightpercentilecolor' => DB::FIELD_TYPE_STR,
			'noneworktimecolor' => DB::FIELD_TYPE_STR,
			'gridview' => DB::FIELD_TYPE_INT,
			'legendview' => DB::FIELD_TYPE_INT,
		),
	),
	'groups' => array(
		'key' => 'groupid',
		'fields' => array(
			'groupid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'internal' => DB::FIELD_TYPE_INT,
			'itemtype' => DB::FIELD_TYPE_INT,
			'key_' => DB::FIELD_TYPE_STR,
			'description' => DB::FIELD_TYPE_STR,
		),
	),
	'hosts' => array(
		'key' => 'hostid',
		'fields' => array(
			'hostid' => DB::FIELD_TYPE_INT,
			'proxy_hostid' => DB::FIELD_TYPE_INT,
			'host' => DB::FIELD_TYPE_STR,
			'dns' => DB::FIELD_TYPE_STR,
			'useip' => DB::FIELD_TYPE_INT,
			'ip' => DB::FIELD_TYPE_STR,
			'port' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
			'disable_until' => DB::FIELD_TYPE_INT,
			'error' => DB::FIELD_TYPE_STR,
			'available' => DB::FIELD_TYPE_INT,
			'errors_from' => DB::FIELD_TYPE_INT,
			'lastaccess' => DB::FIELD_TYPE_INT,
			'inbytes' => DB::FIELD_TYPE_INT,
			'outbytes' => DB::FIELD_TYPE_INT,
			'useipmi' => DB::FIELD_TYPE_INT,
			'ipmi_port' => DB::FIELD_TYPE_INT,
			'ipmi_authtype' => DB::FIELD_TYPE_INT,
			'ipmi_privilege' => DB::FIELD_TYPE_INT,
			'ipmi_username' => DB::FIELD_TYPE_STR,
			'ipmi_password' => DB::FIELD_TYPE_STR,
			'ipmi_disable_until' => DB::FIELD_TYPE_INT,
			'ipmi_available' => DB::FIELD_TYPE_INT,
			'snmp_disable_until' => DB::FIELD_TYPE_INT,
			'snmp_available' => DB::FIELD_TYPE_INT,
			'maintenanceid' => DB::FIELD_TYPE_INT,
			'maintenance_status' => DB::FIELD_TYPE_INT,
			'maintenance_type' => DB::FIELD_TYPE_INT,
			'maintenance_from' => DB::FIELD_TYPE_INT,
			'ipmi_ip' => DB::FIELD_TYPE_STR,
			'ipmi_errors_from' => DB::FIELD_TYPE_INT,
			'snmp_errors_from' => DB::FIELD_TYPE_INT,
			'ipmi_error' => DB::FIELD_TYPE_STR,
			'snmp_error' => DB::FIELD_TYPE_STR,
		),
	),
	'globalmacro' => array(
		'key' => 'globalmacroid',
		'fields' => array(
			'globalmacroid' => DB::FIELD_TYPE_INT,
			'macro' => DB::FIELD_TYPE_STR,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'hostmacro' => array(
		'key' => 'hostmacroid',
		'fields' => array(
			'hostmacroid' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
			'macro' => DB::FIELD_TYPE_STR,
			'value' => DB::FIELD_TYPE_STR,
		),
	),
	'hosts_groups' => array(
		'key' => 'hostgroupid',
		'fields' => array(
			'hostgroupid' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
			'groupid' => DB::FIELD_TYPE_INT,
		),
	),
	'hosts_profiles' => array(
		'key' => 'hostid',
		'fields' => array(
			'hostid' => DB::FIELD_TYPE_INT,
			'devicetype' => DB::FIELD_TYPE_STR,
			'name' => DB::FIELD_TYPE_STR,
			'os' => DB::FIELD_TYPE_STR,
			'serialno' => DB::FIELD_TYPE_STR,
			'tag' => DB::FIELD_TYPE_STR,
			'macaddress' => DB::FIELD_TYPE_STR,
			'hardware' => DB::FIELD_TYPE_STR,
			'software' => DB::FIELD_TYPE_STR,
			'contact' => DB::FIELD_TYPE_STR,
			'location' => DB::FIELD_TYPE_STR,
			'notes' => DB::FIELD_TYPE_STR,
		),
	),
	'hosts_profiles_ext' => array(
		'key' => 'hostid',
		'fields' => array(
			'hostid' => DB::FIELD_TYPE_INT,
			'device_alias' => DB::FIELD_TYPE_STR,
			'device_type' => DB::FIELD_TYPE_STR,
			'device_chassis' => DB::FIELD_TYPE_STR,
			'device_os' => DB::FIELD_TYPE_STR,
			'device_os_short' => DB::FIELD_TYPE_STR,
			'device_hw_arch' => DB::FIELD_TYPE_STR,
			'device_serial' => DB::FIELD_TYPE_STR,
			'device_model' => DB::FIELD_TYPE_STR,
			'device_tag' => DB::FIELD_TYPE_STR,
			'device_vendor' => DB::FIELD_TYPE_STR,
			'device_contract' => DB::FIELD_TYPE_STR,
			'device_who' => DB::FIELD_TYPE_STR,
			'device_status' => DB::FIELD_TYPE_STR,
			'device_networks' => DB::FIELD_TYPE_STR,
			'device_notes' => DB::FIELD_TYPE_STR,
			'device_hardware' => DB::FIELD_TYPE_STR,
			'device_software' => DB::FIELD_TYPE_STR,
			'ip_subnet_mask' => DB::FIELD_TYPE_STR,
			'ip_router' => DB::FIELD_TYPE_STR,
			'ip_macaddress' => DB::FIELD_TYPE_STR,
			'oob_ip' => DB::FIELD_TYPE_STR,
			'oob_subnet_mask' => DB::FIELD_TYPE_STR,
			'oob_router' => DB::FIELD_TYPE_STR,
			'date_hw_buy' => DB::FIELD_TYPE_STR,
			'date_hw_install' => DB::FIELD_TYPE_STR,
			'date_hw_expiry' => DB::FIELD_TYPE_STR,
			'date_hw_decomm' => DB::FIELD_TYPE_STR,
			'site_city' => DB::FIELD_TYPE_STR,
			'site_state' => DB::FIELD_TYPE_STR,
			'site_country' => DB::FIELD_TYPE_STR,
			'site_zip' => DB::FIELD_TYPE_STR,
			'site_rack' => DB::FIELD_TYPE_STR,
			'site_notes' => DB::FIELD_TYPE_STR,
		),
	),
	'hosts_templates' => array(
		'key' => 'hosttemplateid',
		'fields' => array(
			'hosttemplateid' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
			'templateid' => DB::FIELD_TYPE_INT,
		),
	),
	'housekeeper' => array(
		'key' => 'housekeeperid',
		'fields' => array(
			'housekeeperid' => DB::FIELD_TYPE_INT,
			'tablename' => DB::FIELD_TYPE_STR,
			'field' => DB::FIELD_TYPE_STR,
			'value' => DB::FIELD_TYPE_INT,
		),
	),
	'images' => array(
		'key' => 'imageid',
		'fields' => array(
			'imageid' => DB::FIELD_TYPE_INT,
			'imagetype' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'image' => DB::FIELD_TYPE_STR,
		),
	),
	'items' => array(
		'key' => 'itemid',
		'fields' => array(
			'itemid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'snmp_community' => DB::FIELD_TYPE_STR,
			'snmp_oid' => DB::FIELD_TYPE_STR,
			'snmp_port' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
			'description' => DB::FIELD_TYPE_STR,
			'key_' => DB::FIELD_TYPE_STR,
			'delay' => DB::FIELD_TYPE_INT,
			'history' => DB::FIELD_TYPE_INT,
			'trends' => DB::FIELD_TYPE_INT,
			'lastvalue' => DB::FIELD_TYPE_STR,
			'lastclock' => DB::FIELD_TYPE_INT,
			'prevvalue' => DB::FIELD_TYPE_STR,
			'status' => DB::FIELD_TYPE_INT,
			'value_type' => DB::FIELD_TYPE_INT,
			'trapper_hosts' => DB::FIELD_TYPE_STR,
			'units' => DB::FIELD_TYPE_STR,
			'multiplier' => DB::FIELD_TYPE_INT,
			'delta' => DB::FIELD_TYPE_INT,
			'prevorgvalue' => DB::FIELD_TYPE_STR,
			'formula' => DB::FIELD_TYPE_STR,
			'error' => DB::FIELD_TYPE_STR,
			'lastlogsize' => DB::FIELD_TYPE_INT,
			'logtimefmt' => DB::FIELD_TYPE_STR,
			'templateid' => DB::FIELD_TYPE_INT,
			'valuemapid' => DB::FIELD_TYPE_INT,
			'delay_flex' => DB::FIELD_TYPE_STR,
			'params' => DB::FIELD_TYPE_STR,
			'ipmi_sensor' => DB::FIELD_TYPE_STR,
			'data_type' => DB::FIELD_TYPE_INT,
			'authtype' => DB::FIELD_TYPE_INT,
			'username' => DB::FIELD_TYPE_STR,
			'password' => DB::FIELD_TYPE_STR,
			'publickey' => DB::FIELD_TYPE_STR,
			'privatekey' => DB::FIELD_TYPE_STR,
			'mtime' => DB::FIELD_TYPE_INT,
		),
	),
	'items_applications' => array(
		'key' => 'itemappid',
		'fields' => array(
			'itemappid' => DB::FIELD_TYPE_INT,
			'applicationid' => DB::FIELD_TYPE_INT,
			'itemid' => DB::FIELD_TYPE_INT,
		),
	),
	'mappings' => array(
		'key' => 'mappingid',
		'fields' => array(
			'mappingid' => DB::FIELD_TYPE_INT,
			'valuemapid' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_STR,
			'newvalue' => DB::FIELD_TYPE_STR,
		),
	),
	'media' => array(
		'key' => 'mediaid',
		'fields' => array(
			'mediaid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
			'mediatypeid' => DB::FIELD_TYPE_INT,
			'sendto' => DB::FIELD_TYPE_STR,
			'active' => DB::FIELD_TYPE_INT,
			'severity' => DB::FIELD_TYPE_INT,
			'period' => DB::FIELD_TYPE_STR,
		),
	),
	'media_type' => array(
		'key' => 'mediatypeid',
		'fields' => array(
			'mediatypeid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'description' => DB::FIELD_TYPE_STR,
			'smtp_server' => DB::FIELD_TYPE_STR,
			'smtp_helo' => DB::FIELD_TYPE_STR,
			'smtp_email' => DB::FIELD_TYPE_STR,
			'exec_path' => DB::FIELD_TYPE_STR,
			'gsm_modem' => DB::FIELD_TYPE_STR,
			'username' => DB::FIELD_TYPE_STR,
			'passwd' => DB::FIELD_TYPE_STR,
		),
	),
	'profiles' => array(
		'key' => 'profileid',
		'fields' => array(
			'profileid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
			'idx' => DB::FIELD_TYPE_STR,
			'value_id' => DB::FIELD_TYPE_INT,
			'value_int' => DB::FIELD_TYPE_INT,
			'value_str' => DB::FIELD_TYPE_STR,
			'source' => DB::FIELD_TYPE_STR,
			'type' => DB::FIELD_TYPE_INT,
		),
	),
	'rights' => array(
		'key' => 'rightid',
		'fields' => array(
			'rightid' => DB::FIELD_TYPE_INT,
			'groupid' => DB::FIELD_TYPE_INT,
			'permission' => DB::FIELD_TYPE_INT,
			'id' => DB::FIELD_TYPE_INT,
		),
	),
	'scripts' => array(
		'key' => 'scriptid',
		'fields' => array(
			'scriptid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'command' => DB::FIELD_TYPE_STR,
			'host_access' => DB::FIELD_TYPE_INT,
			'usrgrpid' => DB::FIELD_TYPE_INT,
			'groupid' => DB::FIELD_TYPE_INT,
		),
	),
	'screens' => array(
		'key' => 'screenid',
		'fields' => array(
			'screenid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'hsize' => DB::FIELD_TYPE_INT,
			'vsize' => DB::FIELD_TYPE_INT,
		),
	),
	'screens_items' => array(
		'key' => 'screenitemid',
		'fields' => array(
			'screenitemid' => DB::FIELD_TYPE_INT,
			'screenid' => DB::FIELD_TYPE_INT,
			'resourcetype' => DB::FIELD_TYPE_INT,
			'resourceid' => DB::FIELD_TYPE_INT,
			'width' => DB::FIELD_TYPE_INT,
			'height' => DB::FIELD_TYPE_INT,
			'x' => DB::FIELD_TYPE_INT,
			'y' => DB::FIELD_TYPE_INT,
			'colspan' => DB::FIELD_TYPE_INT,
			'rowspan' => DB::FIELD_TYPE_INT,
			'elements' => DB::FIELD_TYPE_INT,
			'valign' => DB::FIELD_TYPE_INT,
			'halign' => DB::FIELD_TYPE_INT,
			'style' => DB::FIELD_TYPE_INT,
			'url' => DB::FIELD_TYPE_STR,
			'dynamic' => DB::FIELD_TYPE_INT,
		),
	),
	'services' => array(
		'key' => 'serviceid',
		'fields' => array(
			'serviceid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'status' => DB::FIELD_TYPE_INT,
			'algorithm' => DB::FIELD_TYPE_INT,
			'triggerid' => DB::FIELD_TYPE_INT,
			'showsla' => DB::FIELD_TYPE_INT,
			'goodsla' => DB::FIELD_TYPE_INT,
			'sortorder' => DB::FIELD_TYPE_INT,
		),
	),
	'services_links' => array(
		'key' => 'linkid',
		'fields' => array(
			'linkid' => DB::FIELD_TYPE_INT,
			'serviceupid' => DB::FIELD_TYPE_INT,
			'servicedownid' => DB::FIELD_TYPE_INT,
			'soft' => DB::FIELD_TYPE_INT,
		),
	),
	'sessions' => array(
		'key' => 'sessionid',
		'fields' => array(
			'sessionid' => DB::FIELD_TYPE_STR,
			'userid' => DB::FIELD_TYPE_INT,
			'lastaccess' => DB::FIELD_TYPE_INT,
			'status' => DB::FIELD_TYPE_INT,
		),
	),
	'sysmaps_links' => array(
		'key' => 'linkid',
		'fields' => array(
			'linkid' => DB::FIELD_TYPE_INT,
			'sysmapid' => DB::FIELD_TYPE_INT,
			'drawtype' => DB::FIELD_TYPE_INT,
			'color' => DB::FIELD_TYPE_STR,
			'label' => DB::FIELD_TYPE_STR,
		),
	),
	'sysmaps_link_triggers' => array(
		'key' => 'linktriggerid',
		'fields' => array(
			'linktriggerid' => DB::FIELD_TYPE_INT,
			'linkid' => DB::FIELD_TYPE_INT,
			'triggerid' => DB::FIELD_TYPE_INT,
			'drawtype' => DB::FIELD_TYPE_INT,
			'color' => DB::FIELD_TYPE_STR,
		),
	),
	'sysmaps_elements' => array(
		'key' => 'selementid',
		'fields' => array(
			'selementid' => DB::FIELD_TYPE_INT,
			'sysmapid' => DB::FIELD_TYPE_INT,
			'elementid' => DB::FIELD_TYPE_INT,
			'elementtype' => DB::FIELD_TYPE_INT,
			'iconid_off' => DB::FIELD_TYPE_INT,
			'iconid_on' => DB::FIELD_TYPE_INT,
			'iconid_unknown' => DB::FIELD_TYPE_INT,
			'label' => DB::FIELD_TYPE_STR,
			'label_location' => DB::FIELD_TYPE_INT,
			'x' => DB::FIELD_TYPE_INT,
			'y' => DB::FIELD_TYPE_INT,
			'url' => DB::FIELD_TYPE_STR,
			'iconid_disabled' => DB::FIELD_TYPE_INT,
			'iconid_maintenance' => DB::FIELD_TYPE_INT,
		),
	),
	'sysmaps' => array(
		'key' => 'sysmapid',
		'fields' => array(
			'sysmapid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'width' => DB::FIELD_TYPE_INT,
			'height' => DB::FIELD_TYPE_INT,
			'backgroundid' => DB::FIELD_TYPE_INT,
			'label_type' => DB::FIELD_TYPE_INT,
			'label_location' => DB::FIELD_TYPE_INT,
			'highlight' => DB::FIELD_TYPE_INT,
		),
	),
	'triggers' => array(
		'key' => 'triggerid',
		'fields' => array(
			'triggerid' => DB::FIELD_TYPE_INT,
			'expression' => DB::FIELD_TYPE_STR,
			'description' => DB::FIELD_TYPE_STR,
			'url' => DB::FIELD_TYPE_STR,
			'status' => DB::FIELD_TYPE_INT,
			'value' => DB::FIELD_TYPE_INT,
			'priority' => DB::FIELD_TYPE_INT,
			'lastchange' => DB::FIELD_TYPE_INT,
			'dep_level' => DB::FIELD_TYPE_INT,
			'comments' => DB::FIELD_TYPE_STR,
			'error' => DB::FIELD_TYPE_STR,
			'templateid' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
		),
	),
	'trigger_depends' => array(
		'key' => 'triggerdepid',
		'fields' => array(
			'triggerdepid' => DB::FIELD_TYPE_INT,
			'triggerid_down' => DB::FIELD_TYPE_INT,
			'triggerid_up' => DB::FIELD_TYPE_INT,
		),
	),
	'users' => array(
		'key' => 'userid',
		'fields' => array(
			'userid' => DB::FIELD_TYPE_INT,
			'alias' => DB::FIELD_TYPE_STR,
			'name' => DB::FIELD_TYPE_STR,
			'surname' => DB::FIELD_TYPE_STR,
			'passwd' => DB::FIELD_TYPE_STR,
			'url' => DB::FIELD_TYPE_STR,
			'autologin' => DB::FIELD_TYPE_INT,
			'autologout' => DB::FIELD_TYPE_INT,
			'lang' => DB::FIELD_TYPE_STR,
			'refresh' => DB::FIELD_TYPE_INT,
			'type' => DB::FIELD_TYPE_INT,
			'theme' => DB::FIELD_TYPE_STR,
			'attempt_failed' => DB::FIELD_TYPE_INT,
			'attempt_ip' => DB::FIELD_TYPE_STR,
			'attempt_clock' => DB::FIELD_TYPE_INT,
			'rows_per_page' => DB::FIELD_TYPE_INT,
		),
	),
	'usrgrp' => array(
		'key' => 'usrgrpid',
		'fields' => array(
			'usrgrpid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'gui_access' => DB::FIELD_TYPE_INT,
			'users_status' => DB::FIELD_TYPE_INT,
			'api_access' => DB::FIELD_TYPE_INT,
			'debug_mode' => DB::FIELD_TYPE_INT,
		),
	),
	'users_groups' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'usrgrpid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
		),
	),
	'valuemaps' => array(
		'key' => 'valuemapid',
		'fields' => array(
			'valuemapid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
		),
	),
	'maintenances' => array(
		'key' => 'maintenanceid',
		'fields' => array(
			'maintenanceid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'maintenance_type' => DB::FIELD_TYPE_INT,
			'description' => DB::FIELD_TYPE_STR,
			'active_since' => DB::FIELD_TYPE_INT,
			'active_till' => DB::FIELD_TYPE_INT,
		),
	),
	'maintenances_hosts' => array(
		'key' => 'maintenance_hostid',
		'fields' => array(
			'maintenance_hostid' => DB::FIELD_TYPE_INT,
			'maintenanceid' => DB::FIELD_TYPE_INT,
			'hostid' => DB::FIELD_TYPE_INT,
		),
	),
	'maintenances_groups' => array(
		'key' => 'maintenance_groupid',
		'fields' => array(
			'maintenance_groupid' => DB::FIELD_TYPE_INT,
			'maintenanceid' => DB::FIELD_TYPE_INT,
			'groupid' => DB::FIELD_TYPE_INT,
		),
	),
	'maintenances_windows' => array(
		'key' => 'maintenance_timeperiodid',
		'fields' => array(
			'maintenance_timeperiodid' => DB::FIELD_TYPE_INT,
			'maintenanceid' => DB::FIELD_TYPE_INT,
			'timeperiodid' => DB::FIELD_TYPE_INT,
		),
	),
	'timeperiods' => array(
		'key' => 'timeperiodid',
		'fields' => array(
			'timeperiodid' => DB::FIELD_TYPE_INT,
			'timeperiod_type' => DB::FIELD_TYPE_INT,
			'every' => DB::FIELD_TYPE_INT,
			'month' => DB::FIELD_TYPE_INT,
			'dayofweek' => DB::FIELD_TYPE_INT,
			'day' => DB::FIELD_TYPE_INT,
			'start_time' => DB::FIELD_TYPE_INT,
			'period' => DB::FIELD_TYPE_INT,
			'start_date' => DB::FIELD_TYPE_INT,
		),
	),
	'regexps' => array(
		'key' => 'regexpid',
		'fields' => array(
			'regexpid' => DB::FIELD_TYPE_INT,
			'name' => DB::FIELD_TYPE_STR,
			'test_string' => DB::FIELD_TYPE_STR,
		),
	),
	'user_history' => array(
		'key' => 'userhistoryid',
		'fields' => array(
			'userhistoryid' => DB::FIELD_TYPE_INT,
			'userid' => DB::FIELD_TYPE_INT,
		),
	),
	'expressions' => array(
		'key' => 'expressionid',
		'fields' => array(
			'expressionid' => DB::FIELD_TYPE_INT,
			'regexpid' => DB::FIELD_TYPE_INT,
			'expression' => DB::FIELD_TYPE_STR,
			'expression_type' => DB::FIELD_TYPE_INT,
			'exp_delimiter' => DB::FIELD_TYPE_STR,
			'case_sensitive' => DB::FIELD_TYPE_INT,
		),
	),
	'autoreg_host' => array(
		'key' => 'autoreg_hostid',
		'fields' => array(
			'autoreg_hostid' => DB::FIELD_TYPE_INT,
			'proxy_hostid' => DB::FIELD_TYPE_INT,
			'host' => DB::FIELD_TYPE_STR,
		),
	),
	'proxy_autoreg_host' => array(
		'key' => 'id',
		'fields' => array(
			'id' => DB::FIELD_TYPE_INT,
			'clock' => DB::FIELD_TYPE_INT,
			'host' => DB::FIELD_TYPE_STR,
		),
	),
);
?>