#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>

#include "default_preferences_callbacks.h"
#include "default_preferences.h"
#include "support.h"
#include "global.h"



void
on_cancel_default_preferences_window_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

	gtk_widget_destroy(default_preferences_window);
	gtk_widget_set_sensitive(default_preferences,TRUE);
}


void
on_save_default_preferences_window_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	//printf("Saving default preferences\n");

	gchar *default_frequency_,*default_comment_,*default_participate_,*default_read_from_rig_,*default_autoanswer_;
	
	GtkWidget * default_frequency = lookup_widget(GTK_WIDGET(button),"default_frequency");
	GtkWidget * default_comment = lookup_widget(GTK_WIDGET(button),"default_comment");
	GtkWidget * default_participate = lookup_widget(GTK_WIDGET(button),"default_participate");
	GtkWidget * default_read_from_rig = lookup_widget(GTK_WIDGET(button),"default_read_from_rig");
	GtkWidget * default_autoanswer = lookup_widget(GTK_WIDGET(button),"default_autoanswer");
	
	
	default_frequency_ = gtk_entry_get_text(GTK_ENTRY(default_frequency));
	default_comment_ =gtk_entry_get_text(GTK_ENTRY(default_comment));
	
	default_participate_ = gtk_combo_box_get_active_text(GTK_COMBO_BOX(default_participate));
	default_read_from_rig_ = gtk_combo_box_get_active_text(GTK_COMBO_BOX(default_read_from_rig));
	default_autoanswer_ = gtk_combo_box_get_active_text(GTK_COMBO_BOX(default_autoanswer));
	
	
	//printf("-> Participate : %s\nRig: %s\nAutoanswer: %s\n",default_participate_,default_read_from_rig_,default_autoanswer_);
	
	if(strcmp(default_participate_,"No") ==0) {
	xwota_settings.participate = g_strdup("0");
	gtk_combo_box_set_active(GTK_COMBO_BOX (participate_combo),0);
	}
	else {
	xwota_settings.participate = g_strdup("1");	
	gtk_combo_box_set_active(GTK_COMBO_BOX (participate_combo),1);
	}
	
	if(strcmp(default_read_from_rig_,"No") ==0) {
	xwota_settings.read_from_rig = g_strdup("0");
	gtk_combo_box_set_active(GTK_COMBO_BOX (read_rig_combo),0);
	}
	else {
	xwota_settings.read_from_rig = g_strdup("1");	
	gtk_combo_box_set_active(GTK_COMBO_BOX (read_rig_combo),1);
	}
	
	if(strcmp(default_autoanswer_,"No") ==0) {
	xwota_settings.autoanswer = g_strdup("0");
	gtk_combo_box_set_active(GTK_COMBO_BOX (autoanswer_combo),0);
	}
	else {
	xwota_settings.autoanswer = g_strdup("1");	
	gtk_combo_box_set_active(GTK_COMBO_BOX (autoanswer_combo),1);
	}
	
	xwota_settings.freq = g_strdup(default_frequency_);
	xwota_settings.comments = g_strdup(default_comment_);
	gtk_entry_set_text(GTK_ENTRY(frequency),xwota_settings.freq);
	gtk_entry_set_text(GTK_ENTRY(comment),xwota_settings.comments);

	save_preferences();
	
	gtk_widget_destroy(default_preferences_window);
	gtk_widget_set_sensitive(default_preferences,TRUE);
}


gboolean
on_default_preferences_window_delete_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(default_preferences,TRUE);
	gtk_widget_hide(default_preferences_window);
  return TRUE;
  
}
