/* msm.h
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MSM_H_
#define _MSM_H_

#include "xf86.h"
#include "damage.h"
#include "exa.h"

#if USEDRI
#define _XF86DRI_SERVER_
#include "dri.h"
#include "GL/glxint.h"
#endif

#include <linux/fb.h>
#include <linux/ioctl.h>
#include <linux/msm_mdp.h>

#define ARRAY_SIZE(a) (sizeof((a)) / (sizeof(*(a))))

typedef enum
{
   MSM_TYPE_7201,
   MSM_TYPE_7X25,
   MSM_TYPE_8X50,
} MSMChipType;

#if USEDRI

typedef struct msm_dri
{
   DRIInfoPtr pDRIInfo;
   int drmFD;

   int depthBits;
   int numVisualConfigs;
   __GLXvisualConfig *pVisualConfigs;

      Bool(*DRICloseScreen) (int, ScreenPtr);
} MSMDRIRec, *MSMDRIPtr;

typedef struct
{
   int dummy;
} MSMDRIContextRec, *MSMDRIContextPtr;

typedef struct
{
  int bpp;
} MSMDRIPrivRec, *MSMDRIPrivPtr;

#endif

typedef struct _MSMRec
{
   /* File descriptor for the framebuffer device */
   int fd;

   /* Fixed and var strutures from the framebuffer */
   struct fb_fix_screeninfo fixed_info;
   struct fb_var_screeninfo mode_info;

   /* Pointer to the mapped framebuffer memory */
   void *fbmem;

   /* Processor identifier */
   MSMChipType chipID;

   /* Default mode for X */
   DisplayModeRec default_mode;

   /* EXA driver structure */
   ExaDriverPtr pExa;

   /* Place holder for the standard close screen function */
   CloseScreenProcPtr CloseScreen;

   /* The blit list structure used by msm_fb */
   struct mdp_blit_req_list *blitList;

   /* The number of xv ports to support */

   int xvports;

   /* A flag that indicates if we should use EXA or not */
   Bool accel;
   Bool useSWBlit;
   Bool useDRI;
   Bool useDRI2;

#if USEDRI
   Bool DRIEnabled;
   MSMDRIPtr dri;
#endif

   Bool HWCursor;
   int HWCursorState;
   int defaultVsync;
   Bool NoSigBlock;
   Bool FastFill;
   Bool FastComposite;
   Bool FastCompositeRepeat;
   Bool FastVideoMemCopy;
   Bool FastAppFBMemCopy;
   int FBCache;

   int pfd;
   gid_t socketGID;

#if USEDRI2
   int drmFD;
  char drmDevName[64];
#endif

   int pixmapMemtype;

} MSMRec, *MSMPtr;

struct msm_pixmap_priv {
	struct msm_drm_bo *bo;
	int SavedPitch;
};

/* Macro to get the private record from the ScreenInfo structure */
#define MSMPTR(p) ((MSMPtr) ((p)->driverPrivate))

Bool MSMSetupExa(ScreenPtr);
Bool MSMDRIScreenInit(ScreenPtr pScreen);
Bool MSMDRIFinishScreenInit(ScreenPtr pScreen);
Bool MSMDRI2ScreenInit(ScreenPtr pScreen);
void MSMDRI2ScreenClose(ScreenPtr pScreen);
void MSMInitVideo(ScreenPtr pScreen);
void MSMSetCursorPosition(MSMPtr pMsm, int x, int y);
void MSMCursorEnable(MSMPtr pMsm, Bool enable);
void MSMCursorLoadARGB(MSMPtr pMsm, CARD32 * image);
Bool MSMCursorInit(ScreenPtr pScreen);
void MSMOutputSetup(ScrnInfoPtr pScrn);
void MSMCrtcSetup(ScrnInfoPtr pScrn);
void MSMBinderInit(MSMPtr pMsm);

#define MSM_OFFSCREEN_GEM 0x01
#define MSM_OFFSCREEN_EXA 0x02

struct msm_offscreen_area {
  void *priv;
  unsigned char *ptr;
  int type;
};

int msm_pixmap_offset(PixmapPtr);
int msm_pixmap_get_pitch(PixmapPtr pix);
Bool msm_pixmap_in_gem(PixmapPtr);
struct msm_drm_bo *msm_get_pixmap_bo(PixmapPtr);
struct msm_offscreen_area *msm_alloc_offscreen_memory(ScreenPtr pScreen, int size);
void msm_free_offscreen_memory(ScreenPtr pScreen, struct msm_offscreen_area *area);

#endif
