/* copyop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2006,2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "copyop.h"
#include "copyopwin.hh"
#include "nmspecialsourceext.hh"

const char *CopyOp::name="CopyOp";

CopyOp::CopyOp() : FunctionProto()
{
  follow_symlinks=false;
  move=false;
  do_rename=false;
  same_dir=false;
  request_dest=false;
  request_flags=false;
  overwrite=COPYOP_OVERWRITE_NORMAL;
  fastcopy=COPYOP_NORMALCOPY;
  preserve_attr=true;
  hasConfigure = true;
}

CopyOp::~CopyOp()
{
}

CopyOp*
CopyOp::duplicate() const
{
  CopyOp *ta=new CopyOp();
  ta->follow_symlinks=follow_symlinks;
  ta->move=move;
  ta->do_rename=do_rename;
  ta->same_dir=same_dir;
  ta->request_dest=request_dest;
  ta->request_flags=request_flags;
  ta->overwrite=overwrite;
  ta->fastcopy=fastcopy;
  ta->preserve_attr=preserve_attr;
  return ta;
}

bool
CopyOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
CopyOp::getName()
{
  return name;
}

int
CopyOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodecopy( msg );
    }
  } else {
    normalmodecopy( msg );
  }
  return 0;
}

bool
CopyOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  fh->configPutPairBool( "followsymlinks", follow_symlinks );
  fh->configPutPairBool( "move", move );
  fh->configPutPairBool( "rename", do_rename );
  fh->configPutPairBool( "samedir", same_dir );
  fh->configPutPairBool( "requestdest", request_dest );
  fh->configPutPairBool( "requestflags", request_flags );
  switch(overwrite) {
    case COPYOP_OVERWRITE_ALWAYS:
      fh->configPutPair( "overwrite", "always" );
      break;
    case COPYOP_OVERWRITE_NEVER:
      fh->configPutPair( "overwrite", "never" );
      break;
    default:
      fh->configPutPair( "overwrite", "normal" );
      break;
  }
  switch(fastcopy) {
    case COPYOP_FASTCOPY:
      fh->configPutPair( "copymode", "fast" );
      break;
    case COPYOP_FASTESTCOPY:
      fh->configPutPair( "copymode", "fastest" );
      break;
    default:
      fh->configPutPair( "copymode", "normal" );
      break;
  }
  fh->configPutPairBool( "preserveattr", preserve_attr );
  return true;
}

const char *
CopyOp::getDescription()
{
  return catalog.getLocaleCom(8);
}

int
CopyOp::normalmodecopy( ActionMessage *am )
{
  struct NM_copyorder copyorder;
  NormalMode *nm1=NULL,
             *nm2=NULL;
  ListerMode *lm1=NULL;
  NM_specialsourceExt *specialsource=NULL;
  bool do_request,cont=true;
  char *tstr2,*dest=NULL;
  
  if(am->mode==am->AM_MODE_DNDACTION) {
    lm1 = am->dndmsg->getSourceMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    lm1 = am->dndmsg->getDestMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm2=(NormalMode*)lm1;
  } else {
    if(startlister==NULL) return 1;
    lm1=startlister->getActiveMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    if(endlister!=NULL) {
      lm1=endlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          nm2=(NormalMode*)lm1;
    }
  }
  
  if(request_flags==true) {
    if(doconfigure(1)!=0) cont=false;
  } else {
    // set values in t* variables
    tfollow_symlinks=follow_symlinks;
    tmove=move;
    trename=do_rename;
    tsame_dir=same_dir;
    trequest_dest=request_dest;
    toverwrite=overwrite;
    tfastcopy=fastcopy;
    tpreserve_attr=preserve_attr;
  }
  
  if(cont==true) {
    memset( &copyorder, 0, sizeof( copyorder ) );
    copyorder.ignoreLosedAttr = false;
    // detect what to copy
    if(am->mode==am->AM_MODE_ONLYACTIVE)
      copyorder.source=copyorder.NM_ONLYACTIVE;
    else if(am->mode==am->AM_MODE_DNDACTION) {
      // insert DND-element into list
      copyorder.source=copyorder.NM_SPECIAL;
      copyorder.sources=new std::list<NM_specialsourceExt*>;
      specialsource = new NM_specialsourceExt( am->dndmsg->getFE() );
      copyorder.sources->push_back(specialsource);
    } else if(am->mode==am->AM_MODE_SPECIAL) {
      copyorder.source=copyorder.NM_SPECIAL;
      copyorder.sources=new std::list<NM_specialsourceExt*>;
      specialsource = new NM_specialsourceExt( am->getFE() );
      copyorder.sources->push_back(specialsource);
    } else
      copyorder.source=copyorder.NM_ALLENTRIES;

    /* now source defined
       next find destination
       
       Priority:
        1.Flag for requesting destination
        2.Flag for same dir
        3.When DNDAction destination of DND
        4.nonactive lister
       
       when no destination then also requesting
    */

    do_request=false;
    if(trequest_dest==true)
      do_request=true;
    else if(tsame_dir==true) {
      const char *tstr = nm1->getCurrentDir();
      if(tstr!=NULL)
        dest=dupstring(tstr);
    } else if(am->mode==am->AM_MODE_DNDACTION) {
      const char *ddstr = am->dndmsg->getDestDir();
      if(ddstr!=NULL) dest=dupstring(ddstr);
      else dest=NULL;
    } else {
      if(nm2!=NULL) {
        const char *tstr = nm2->getCurrentDir();
        if(tstr!=NULL)
          dest=dupstring(tstr);
        else
          do_request=true;
      } else
        do_request=true;
    }

    if(do_request==true) {
      const char *defdir;
      if(dest!=NULL) _freesafe(dest);
      
      if ( nm2 != NULL ) {
        defdir = nm2->getCurrentDir();
        if ( defdir != NULL ) {
          if ( strlen( defdir ) < 1 )
            defdir = nm1->getCurrentDir();
        } else {
          defdir = nm1->getCurrentDir();
        }
      } else {
        defdir = nm1->getCurrentDir();
      }
      
      if ( requestdest( defdir, &dest ) != 0 ) {
        _freesafe(dest);
        dest=NULL;
      }
    }
    /* if dest==null nothing to do
       otherwise: */
    if(dest!=NULL) {
      /* if dest starts with no slash then take it as local dir
         so add currentDir */
      if(dest[0]!='/') {
        char *tstr=catstring(nm1->getCurrentDir(),"/");
        tstr2=catstring(tstr,dest);
        _freesafe(tstr);
        _freesafe(dest);
        dest=tstr2;
      }
      /* now also destination determined
         next describing what to do */
      copyorder.move=tmove;
      copyorder.follow_symlinks=tfollow_symlinks;
      copyorder.preserve_attr=tpreserve_attr;
      copyorder.do_rename=trename;
      switch(toverwrite) {
        case COPYOP_OVERWRITE_ALWAYS:
          copyorder.overwrite=copyorder.NM_OVERWRITE_ALWAYS;
          break;
        case COPYOP_OVERWRITE_NEVER:
          copyorder.overwrite=copyorder.NM_OVERWRITE_NEVER;
          break;
        default:
          copyorder.overwrite=copyorder.NM_OVERWRITE_NORMAL;
      }
      switch(tfastcopy) {
        case COPYOP_FASTCOPY:
          copyorder.copymode=copyorder.NM_COPYMODE_NODATABASE;
          break;
        default:
          copyorder.copymode=copyorder.NM_COPYMODE_NORMAL;
          break;
      }
      copyorder.destdir=dest;
      // now start copy process
      copyorder.cowin=new CopyOpWin( am->getWorker()->getAGUIX(),
                                     copyorder.move );
      nm1->copy(&copyorder);
      delete copyorder.cowin;
    }
    if(dest!=NULL) _freesafe(dest);
    if(copyorder.source==copyorder.NM_SPECIAL) {
      if ( specialsource != NULL ) delete specialsource;
      delete copyorder.sources;
    }
  }
  return 0;
}

int
CopyOp::doconfigure(int mode)
{
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win;
  ChooseButton *fscb,*mcb,*rcb,*sdcb,*rfcb=NULL,*rdcb,*pacb;
//  CycleButton *ocyb,*fccyb;
  CycleButton *fccyb;
  AGMessage *msg;
  int endmode=-1;
  Requester *req;
  char *tstr;
  int i;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  req=new Requester(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(8))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(8));
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 10 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocaleCom( 8 ), 1 ), 0, 0, cincwnr );

  fscb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( follow_symlinks == true ) ? 1 : 0,
						    catalog.getLocale( 298 ), LABEL_RIGHT, 1, 0 ), 0, 1, cincwnr );

  mcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( move == true ) ? 1 : 0,
						   catalog.getLocale( 299 ), LABEL_RIGHT, 1, 0 ), 0, 2, cincwnr );

  rcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( do_rename == true ) ? 1 : 0,
						   catalog.getLocale( 300 ), LABEL_RIGHT, 1, 0 ), 0, 3, cincwnr );

  sdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( same_dir == true ) ? 1 : 0,
						    catalog.getLocale( 301 ), LABEL_RIGHT, 1, 0 ), 0, 4, cincwnr );

  rdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( request_dest == true ) ? 1 : 0,
						    catalog.getLocale( 302 ), LABEL_RIGHT, 1, 0 ), 0, 5, cincwnr );

  pacb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( preserve_attr == true ) ? 1 : 0,
						    catalog.getLocale( 150 ), LABEL_RIGHT, 1, 0 ), 0, 6, cincwnr );

/*  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(303),1));
  x+=ttext->getWidth()+5;
  ocyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  ocyb->addOption(catalog.getLocale(304));
  ocyb->addOption(catalog.getLocale(305));
  ocyb->addOption(catalog.getLocale(306));
  ocyb->resize(ocyb->getMaxSize(),ocyb->getHeight());
  switch(overwrite) {
    case COPYOP_OVERWRITE_ALWAYS:
      ocyb->setOption(1);
      break;
    case COPYOP_OVERWRITE_NEVER:
      ocyb->setOption(2);
      break;
    default:
      ocyb->setOption(0);
      break;
  }
  
  y+=ocyb->getHeight()+5;
  tw=x+ocyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;*/

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 7 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 307 ), 1 ), 0, 0, cfix );
  fccyb = (CycleButton*)ac1_1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 1, 0, cincw );
  fccyb->addOption(catalog.getLocale(308));
  fccyb->addOption(catalog.getLocale(309));
//  fccyb->addOption("schnellster Modus");
  fccyb->resize(fccyb->getMaxSize(),fccyb->getHeight());
  switch(fastcopy) {
    case COPYOP_FASTCOPY:
      fccyb->setOption(1);
      break;
/*    case COPYOP_FASTESTCOPY:
      fccyb->setOption(2);
      break;*/
    default:
      fccyb->setOption(0);
      break;
  }
  ac1_1->readLimits();
  
  if(mode==0) {
    rfcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( request_flags == true ) ? 1 : 0,
						      catalog.getLocale( 294 ), LABEL_RIGHT, 1, 0 ), 0, 8, cincwnr );
  }

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 9 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( -1 );
  ac1_2->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_2->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cb = (Button*)ac1_2->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, cfix );
  
  okb->takeFocus();
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            endmode = 0;
          } else if(msg->button.button==cb) endmode=1;
          break;
        case AG_KEYPRESSED:
          if(win->isParent(msg->key.window,false)==true) {
            switch(msg->key.key) {
              case XK_1:
                fscb->setState((fscb->getState() == true ) ? false : true);
                break;
              case XK_2:
                mcb->setState((mcb->getState() == true ) ? false : true);
                break;
              case XK_3:
                rcb->setState((rcb->getState() == true ) ? false : true);
                break;
              case XK_4:
                sdcb->setState((sdcb->getState() == true ) ? false : true);
                break;
              case XK_5:
                rdcb->setState((rdcb->getState() == true ) ? false : true);
                break;
              case XK_6:
/*                i=ocyb->getSelectedOption()+1;
                if(i>=3) i=0;
                ocyb->setOption(i);
                break;
              case XK_7:*/
                i=fccyb->getSelectedOption()+1;
                if(i>=2) i=0;
                fccyb->setOption(i);
                break;
              case XK_Return:
                if ( cb->getHasFocus() == false ) {
                  endmode = 0;
                }
                break;
              case XK_Escape:
                endmode=1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    if(mode==1) {
      // store in t-variables
      tfollow_symlinks = fscb->getState();
      tmove = mcb->getState();
      trename = rcb->getState();
      tsame_dir = sdcb->getState();
      trequest_dest = rdcb->getState();
      tpreserve_attr = pacb->getState();
      toverwrite=COPYOP_OVERWRITE_NORMAL;
/*      switch(ocyb->getSelectedOption()) {
        case 1:
          toverwrite=COPYOP_OVERWRITE_ALWAYS;
          break;
        case 2:
          toverwrite=COPYOP_OVERWRITE_NEVER;
          break;
        default:
          toverwrite=COPYOP_OVERWRITE_NORMAL;
          break;
      }*/
      switch(fccyb->getSelectedOption()) {
        case 1:
          tfastcopy=COPYOP_FASTCOPY;
          break;
/*        case 2:
          tfastcopy=COPYOP_FASTESTCOPY;
          break;*/
        default:
          tfastcopy=COPYOP_NORMALCOPY;
          break;
      }
    } else {
      // store in normal variables
      follow_symlinks = fscb->getState();
      move = mcb->getState();
      do_rename = rcb->getState();
      same_dir = sdcb->getState();
      request_dest = rdcb->getState();
      request_flags = rfcb->getState();
      preserve_attr = pacb->getState();
      overwrite=COPYOP_OVERWRITE_NORMAL;
/*      switch(ocyb->getSelectedOption()) {
        case 1:
          overwrite=COPYOP_OVERWRITE_ALWAYS;
          break;
        case 2:
          overwrite=COPYOP_OVERWRITE_NEVER;
          break;
        default:
          overwrite=COPYOP_OVERWRITE_NORMAL;
          break;
      }*/
      switch(fccyb->getSelectedOption()) {
        case 1:
          fastcopy=COPYOP_FASTCOPY;
          break;
/*        case 2:
          fastcopy=COPYOP_FASTESTCOPY;
          break;*/
        default:
          fastcopy=COPYOP_NORMALCOPY;
          break;
      }
    }
  }
  
  delete win;
  delete req;

  return endmode;
}

int
CopyOp::configure()
{
  return doconfigure(0);
}

int
CopyOp::requestdest( const char *defaultstr, char **dest )
{
  Requester *req=new Requester( Worker::getAGUIX());
  char *buttonstr;
  const char *textstr;
  int erg;
  
  textstr=catalog.getLocale(212);
  buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                              strlen(catalog.getLocale(8))+1);
  sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                            catalog.getLocale(8));
  erg = req->string_request( catalog.getLocale( 123 ),
                             textstr,
                             ( defaultstr != NULL ) ? defaultstr : "",
                             buttonstr,
                             dest,
                             Requester::REQUEST_SELECTALL );
  _freesafe(buttonstr);
  delete req;
  return erg;
}

void CopyOp::setFollowSymlinks(bool nv)
{
  follow_symlinks=nv;
}

void CopyOp::setMove(bool nv)
{
  move=nv;
}

void CopyOp::setRename(bool nv)
{
  do_rename=nv;
}

void CopyOp::setSameDir(bool nv)
{
  same_dir=nv;
}

void CopyOp::setRequestDest(bool nv)
{
  request_dest=nv;
}

void CopyOp::setRequestFlags(bool nv)
{
  request_flags=nv;
}

void CopyOp::setOverwrite(overwrite_t nv)
{
  overwrite=nv;
}

void CopyOp::setPreserveAttr(bool nv)
{
  preserve_attr=nv;
}

void CopyOp::setFastcopy( fastcopy_t nv )
{
  fastcopy = nv;
}
