/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import rene.dialogs.ColorEditor;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.util.FileName;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportDialog
extends HelpCloseDialog {
    ZirkelFrame ZF;
    Construction C;
    TextField PageTitle;
    TextField CFile;
    TextField Jar;
    TextField Width;
    TextField Height;
    TextField Solution;
    TextField StyleSheet;
    Checkbox BackgroundColor;
    Checkbox AppletColor;
    Checkbox Job;
    Checkbox Comment;
    Checkbox SaveSolution;
    Checkbox LinkSolution;
    Checkbox JumpSolution;
    Checkbox Digits;
    Checkbox Colors;
    Checkbox Background;
    Checkbox Popup;
    Checkbox Zoom;
    Checkbox RestrictedMove;
    Panel CP;
    Choice Style;
    boolean OK = false;
    IconBar IBa;
    IconBar IBb;
    boolean SaveDimensions = true;
    boolean Restrict;
    double Persp = 1.0;
    static String[] ISb = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "hidden", "macro0", "replay", "arrow", "obtuse", "solid", "grid", "thickness0", "type0", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "function"};
    static String[] ISb0 = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "hidden", "macro", "replay", "arrow", "obtuse", "solid", "grid", "thickness", "type", "partial", "plines", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "function"};
    static String[] ST = new String[]{"plain", "3D", "icons", "full", "nonvisual", "breaks"};
    static char[] A = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ExportDialog(ZirkelFrame zirkelFrame, Construction construction, boolean bl) {
        super(zirkelFrame, Zirkel.name("export.title"), true);
        Object object;
        int n;
        this.ZF = zirkelFrame;
        this.C = construction;
        this.Restrict = bl;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        myPanel.add(new MyLabel(Zirkel.name("export.pagetitle")));
        this.PageTitle = new TextFieldAction((DoActionListener)this, "export.pagetitle", 32);
        myPanel.add(this.PageTitle);
        this.PageTitle.setText(FileName.purefilename(zirkelFrame.Filename));
        myPanel.add(new MyLabel(Zirkel.name("export.stylesheet")));
        this.StyleSheet = new TextFieldAction((DoActionListener)this, "export.stylesheet", 32);
        myPanel.add(this.StyleSheet);
        this.StyleSheet.setText(Global.getParameter("export.stylesheet", ""));
        myPanel.add(new MyLabel(Zirkel.name("export.width")));
        this.Width = new TextFieldAction((DoActionListener)this, "export.width", 32);
        myPanel.add(this.Width);
        this.Width.setText("" + Global.getParameter("export.width", 600));
        this.Width.addActionListener(this);
        myPanel.add(new MyLabel(Zirkel.name("export.height")));
        this.Height = new TextFieldAction((DoActionListener)this, "export.height", 32);
        myPanel.add(this.Height);
        this.Height.setText("" + Global.getParameter("export.height", 600));
        this.Height.addActionListener(this);
        myPanel.add(new MyLabel(Zirkel.name("export.file")));
        this.CFile = new TextFieldAction((DoActionListener)this, "export.file", 32);
        myPanel.add(this.CFile);
        this.CFile.setText(FileName.filename(zirkelFrame.Filename));
        myPanel.add(new MyLabel(Zirkel.name("export.jar")));
        this.Jar = new TextFieldAction((DoActionListener)this, "export.jar", 32);
        myPanel.add(this.Jar);
        this.Jar.setText(Global.getParameter("export.jar", "zirkel.jar"));
        if (this.ZF.ZC.isJob()) {
            myPanel.add(new MyLabel(""));
            this.Job = new CheckboxAction(this, Zirkel.name("export.job"));
            myPanel.add(this.Job);
            this.Job.setState(this.ZF.ZC.isJob());
        }
        if (this.ZF.ZC.isJob()) {
            myPanel.add(new MyLabel(Zirkel.name("export.solution")));
            this.Solution = new TextFieldAction((DoActionListener)this, "export.solution", 32);
            myPanel.add(this.Solution);
            this.Solution.setText(FileName.purefilename(zirkelFrame.Filename) + "-sol.html");
            this.JumpSolution = new CheckboxAction(this, Zirkel.name("export.jumpsol"));
            myPanel.add(this.JumpSolution);
            this.JumpSolution.setState(Global.getParameter("export.jumpsol", false));
            this.SaveSolution = new CheckboxAction(this, Zirkel.name("export.savesol"));
            myPanel.add(this.SaveSolution);
            this.SaveSolution.setState(Global.getParameter("export.savesol", false));
            this.LinkSolution = new CheckboxAction(this, Zirkel.name("export.linksol"));
            myPanel.add(this.LinkSolution);
            this.LinkSolution.setState(Global.getParameter("export.linksol", false));
            myPanel.add(new MyLabel(""));
        }
        myPanel.add(new MyLabel(Zirkel.name("export.color")));
        this.CP = new MyPanel();
        myPanel.add(this.CP);
        this.CP.setBackground(Global.getParameter("export.color", this.ZF.ZC.getBackground()));
        this.BackgroundColor = new CheckboxAction(this, Zirkel.name("export.backgroundcolor"));
        myPanel.add(this.BackgroundColor);
        this.BackgroundColor.setState(Global.getParameter("export.backgroundcolor", true));
        this.AppletColor = new CheckboxAction(this, Zirkel.name("export.appletcolor"));
        myPanel.add(this.AppletColor);
        this.AppletColor.setState(Global.getParameter("export.appletcolor", true));
        this.Style = new MyChoice();
        for (n = 0; n < ST.length; ++n) {
            this.Style.add(Global.name("export." + ST[n]));
        }
        n = Global.getParameter("export.style", 0);
        if (n <= 1 && this.ZF.ZC.isJob()) {
            n = 3;
        }
        this.Style.select(n);
        myPanel.add(new MyLabel(Zirkel.name("export.style")));
        myPanel.add(this.Style);
        this.Digits = new CheckboxAction(this, Zirkel.name("export.digits"));
        myPanel.add(this.Digits);
        this.Digits.setState(Global.getParameter("export.digits", true));
        this.Comment = new CheckboxAction(this, Zirkel.name("export.comment"));
        myPanel.add(this.Comment);
        this.Comment.setState(Global.getParameter("export.comment", true));
        this.Colors = new CheckboxAction(this, Zirkel.name("export.colors"));
        myPanel.add(this.Colors);
        this.Colors.setState(Global.getParameter("export.colors", true));
        this.Background = new CheckboxAction(this, Zirkel.name("export.background"));
        myPanel.add(this.Background);
        this.Background.setState(Global.getParameter("export.background", false));
        this.Popup = new CheckboxAction(this, Zirkel.name("export.popup"));
        myPanel.add(this.Popup);
        this.Popup.setState(Global.getParameter("export.popup", true));
        this.Zoom = new CheckboxAction(this, Zirkel.name("export.zoom"));
        myPanel.add(this.Zoom);
        this.Zoom.setState(Global.getParameter("export.zoom", false));
        this.RestrictedMove = new CheckboxAction(this, Zirkel.name("export.restrictedmove"));
        myPanel.add(this.RestrictedMove);
        this.RestrictedMove.setState(Global.getParameter("export.restrictedmove", false));
        myPanel.add(new MyLabel(""));
        this.add("North", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new GridLayout(0, 1));
        this.IBa = new IconBar(this.ZF);
        String string = bl ? Global.getParameter("restrictedicons", " point line segment ray circle circle3 fixedcircle fixedangle intersection ") : Global.getParameter("export.icons", " point line segment ray circle circle3 fixedcircle fixedangle intersection ");
        for (int i = 0; i < 26; ++i) {
            String string2 = ZirkelFrame.ObjectStrings[i];
            this.IBa.addToggleLeft(string2);
            if (!string.equals("full") && string.indexOf(" " + string2 + " ") < 0) continue;
            this.IBa.setState(string2, true);
        }
        myPanel2.add(new Panel3D(this.IBa));
        this.IBb = new IconBar(this.ZF);
        String string3 = bl ? Global.getParameter("restrictedicons", "back hidden color indicate twolines ") : Global.getParameter("export.tools", "back hidden color indicate twolines ");
        for (int i = 0; i < ISb.length; ++i) {
            object = ISb[i];
            if (((String)object).equals("qintersection")) {
                this.IBb.addSeparatorLeft();
            }
            if (((String)object).equals("twolines")) {
                this.IBb.addSeparatorLeft();
            }
            if (((String)object).equals("draw")) {
                this.IBb.addSeparatorLeft();
            }
            this.IBb.addToggleLeft((String)object);
            if (!string3.equals("full") && string3.indexOf(ISb0[i]) < 0) continue;
            this.IBb.setState((String)object, true);
        }
        myPanel2.add(new Panel3D(this.IBb));
        this.IBb.setState("qchoice", Global.getParameter("options.choice", false));
        this.IBb.setState("qintersection", Global.getParameter("options.intersection", false));
        this.IBb.setState("qpointon", Global.getParameter("options.pointon", false));
        this.IBb.setState("indicate", !Global.getParameter("options.indicate.simple", false));
        this.add("Center", myPanel2);
        MyPanel myPanel3 = new MyPanel();
        myPanel3.add(new ButtonAction(this, Zirkel.name("export.setsize"), "setsize"));
        myPanel3.add(new ButtonAction(this, Zirkel.name("export.setcolor"), "setcolor"));
        myPanel3.add(new MyLabel(" "));
        myPanel3.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        myPanel3.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(myPanel3, "htmlexport");
        this.add("South", myPanel3);
        this.pack();
        if (this.getSize().width > 750) {
            this.setSize(750, this.getSize().height);
        }
        object = this.ZF.ZC.getSize();
        if (((Dimension)object).width > 0) {
            this.Persp = (double)((Dimension)object).height / (double)((Dimension)object).width;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.Width) {
            int n = this.getWidth();
            this.Width.setText("" + n);
            this.Height.setText("" + (int)((double)n * this.Persp));
        } else if (actionEvent.getSource() == this.Height && this.Persp > 0.0) {
            int n = this.getHeight();
            this.Height.setText("" + n);
            this.Width.setText("" + (int)((double)n / this.Persp));
        }
    }

    public void doAction(String string) {
        this.OK = false;
        if (string.equals("OK")) {
            this.OK = true;
            Global.setParameter("export.stylesheet", this.StyleSheet.getText());
            Global.setParameter("export.jar", this.Jar.getText());
            if (this.SaveDimensions) {
                try {
                    Global.setParameter("export.height", Integer.parseInt(this.Height.getText()));
                    Global.setParameter("export.width", Integer.parseInt(this.Width.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Global.setParameter("export.color", this.CP.getBackground());
            Global.setParameter("export.backgroundcolor", this.BackgroundColor.getState());
            Global.setParameter("export.appletcolor", this.AppletColor.getState());
            if (this.JumpSolution != null) {
                Global.setParameter("export.jumpsol", this.JumpSolution.getState());
            }
            if (this.SaveSolution != null) {
                Global.setParameter("export.savesol", this.SaveSolution.getState());
            }
            if (this.LinkSolution != null) {
                Global.setParameter("export.linksol", this.LinkSolution.getState());
            }
            Global.setParameter("export.comment", this.Comment.getState());
            Global.setParameter("export.colors", this.Colors.getState());
            Global.setParameter("export.background", this.Background.getState());
            Global.setParameter("export.zoom", this.Zoom.getState());
            Global.setParameter("export.restrictedmove", this.RestrictedMove.getState());
            Global.setParameter("export.popup", this.Popup.getState());
            int n = this.Style.getSelectedIndex();
            if (n >= 0) {
                Global.setParameter("export.style", n);
            }
            Global.setParameter("export.digits", this.Digits.getState());
            this.getIcons();
            this.getTools();
            this.doclose();
        } else if (string.equals("setcolor")) {
            ColorEditor colorEditor = new ColorEditor((Frame)this.ZF, "export.color", this.CP.getBackground());
            colorEditor.center(this.ZF);
            colorEditor.setVisible(true);
            this.CP.setBackground(Global.getParameter("export.color", this.CP.getBackground()));
        } else if (string.equals("setsize")) {
            Dimension dimension = this.ZF.ZC.getSize();
            this.Height.setText("" + dimension.height);
            this.Width.setText("" + dimension.width);
        } else {
            super.doAction(string);
        }
    }

    public boolean isAborted() {
        return !this.OK;
    }

    public String getPageTitle() {
        return this.PageTitle.getText();
    }

    public String getStyleSheet() {
        return this.StyleSheet.getText();
    }

    public String getFile() {
        return this.CFile.getText();
    }

    public String getDezimalColor() {
        Color color = this.CP.getBackground();
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public String getHexColor() {
        Color color = this.CP.getBackground();
        return "#" + this.hex(color.getRed()) + this.hex(color.getGreen()) + this.hex(color.getBlue());
    }

    String hex(int n) {
        return "" + A[n / 16] + A[n % 16];
    }

    public boolean useForBackground() {
        return this.BackgroundColor.getState();
    }

    public boolean useForApplet() {
        return this.AppletColor.getState();
    }

    public boolean isJob() {
        if (this.Job == null) {
            return false;
        }
        return this.Job.getState();
    }

    public String getIcons() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        for (int i = 0; i < 26; ++i) {
            String string = ZirkelFrame.ObjectStrings[i];
            if (!this.IBa.getState(string)) continue;
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        if (!this.Restrict) {
            Global.setParameter("export.icons", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getTools() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        for (int i = 0; i < ISb.length; ++i) {
            String string = ISb[i];
            if (string.equals("indicate") && !this.IBb.getState(string)) {
                stringBuffer.append("noindicate ");
                continue;
            }
            if (!this.IBb.getState(string)) continue;
            stringBuffer.append(ISb0[i]);
            stringBuffer.append(" ");
        }
        if (!this.Restrict) {
            Global.setParameter("export.tools", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getStyle() {
        int n = this.Style.getSelectedIndex();
        if (n >= 0) {
            Global.setParameter("export.style", n);
        }
        if (n < 0) {
            return ST[0];
        }
        return ST[n];
    }

    public String getJar() {
        return this.Jar.getText();
    }

    public String getSolution() {
        if (this.Solution == null) {
            return "";
        }
        return this.Solution.getText();
    }

    public boolean saveComment() {
        Global.setParameter("export.comment", this.Comment.getState());
        return this.Comment.getState();
    }

    public int getWidth() {
        try {
            int n = Integer.parseInt(this.Width.getText());
            return n;
        }
        catch (Exception exception) {
            return Global.getParameter("export.width", 550);
        }
    }

    public int getHeight() {
        try {
            int n = Integer.parseInt(this.Height.getText());
            return n;
        }
        catch (Exception exception) {
            return Global.getParameter("export.height", 550);
        }
    }

    public boolean jumpSolution() {
        if (this.JumpSolution == null) {
            return false;
        }
        return this.JumpSolution.getState();
    }

    public boolean saveSolution() {
        if (this.SaveSolution == null) {
            return false;
        }
        return this.SaveSolution.getState();
    }

    public boolean linkSolution() {
        if (this.LinkSolution == null) {
            return false;
        }
        return this.LinkSolution.getState();
    }

    public boolean saveDigits() {
        return this.Digits.getState();
    }

    public boolean saveColors() {
        return this.Colors.getState();
    }

    public boolean saveBackground() {
        return this.Background.getState();
    }

    public boolean allowZoom() {
        return this.Zoom.getState();
    }

    public boolean allowPopup() {
        return this.Popup.getState();
    }

    public boolean restrictedMove() {
        return this.RestrictedMove.getState();
    }

    public void setDimensions(int n, int n2) {
        this.Height.setText("" + n2);
        this.Height.setEnabled(false);
        this.Width.setText("" + n);
        this.Width.setEnabled(false);
        this.SaveDimensions = false;
    }
}

