/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.awt.VariableSlider;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Crosshair;
import edu.hws.jcm.draw.DrawBorder;
import edu.hws.jcm.draw.DrawString;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.draw.Graph1D;
import edu.hws.jcm.draw.Grid;
import edu.hws.jcm.draw.Panner;
import edu.hws.jcm.draw.TangentLine;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Derivatives
extends GenericGraphApplet {
    private String functionName;
    private Function func;
    private Function deriv;
    private Expression derivExpression;
    private Function deriv2;
    private Controller subController = new Controller();
    private VariableInput xInput;

    protected void setUpParameterDefaults() {
        this.parameterDefaults = new Hashtable();
        this.parameterDefaults.put("Function", " tan(" + this.getParameter("Variable", "x") + ")");
    }

    protected void setUpMainPanel() {
        Component component;
        Object object;
        super.setUpMainPanel();
        if (this.limitsPanel != null) {
            this.limitsPanel.addCoords(this.canvas.getCoordinateRect(1));
            if (this.deriv2 != null) {
                this.limitsPanel.addCoords(this.canvas.getCoordinateRect(2));
            }
        } else {
            object = new Tie(this.canvas.getCoordinateRect(0), this.canvas.getCoordinateRect(1));
            if (this.deriv2 != null) {
                ((Tie)object).add(this.canvas.getCoordinateRect(2));
            }
            this.canvas.getCoordinateRect(0).setSyncWith((Tie)object);
            this.canvas.getCoordinateRect(1).setSyncWith((Tie)object);
            if (this.deriv2 != null) {
                this.canvas.getCoordinateRect(2).setSyncWith((Tie)object);
            }
        }
        object = this.canvas.getCoordinateRect().getValueObject(0);
        Value value = this.canvas.getCoordinateRect().getValueObject(1);
        this.canvas.getCoordinateRect().setOnChange(this.subController);
        VariableSlider variableSlider = new VariableSlider((Value)object, value);
        variableSlider.setOnUserAction(this.subController);
        this.xInput.setOnTextChange(this.subController);
        this.subController.add(variableSlider);
        this.subController.add(this.xInput);
        this.subController.add(new Tie(variableSlider, this.xInput));
        Component component2 = new Panel();
        component2.setLayout(new BorderLayout(5, 5));
        component2.add(this.xInput.withLabel(), "West");
        component2.add(variableSlider, "Center");
        if (this.limitsPanel == null && !"no".equalsIgnoreCase(this.getParameter("UseRestoreButton", "no"))) {
            component = new Button("Restore Limits");
            component2.add(component, "East");
            component.setBackground(Color.lightGray);
            ((Button)component).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Derivatives.this.canvas.getCoordinateRect(0).restore();
                    Derivatives.this.canvas.getCoordinateRect(1).restore();
                    if (Derivatives.this.deriv2 != null) {
                        Derivatives.this.canvas.getCoordinateRect(2).restore();
                    }
                }
            });
        }
        if ("yes".equalsIgnoreCase(this.getParameter("ShowFormula", "yes"))) {
            component = new Panel();
            ((Container)component).setLayout(new GridLayout(2, 1, 3, 3));
            ((Container)component).add(component2);
            ExprLbl exprLbl = new ExprLbl(" " + this.functionName + "'(" + this.xVar.getName() + ") = ");
            this.mainController.add(exprLbl);
            ((Container)component).add(exprLbl);
            component2 = component;
        }
        if (this.inputPanel == null) {
            component2.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
            this.mainPanel.add(component2, "South");
        } else {
            this.inputPanel.add(component2, "South");
        }
    }

    protected void setUpCanvas() {
        DrawString drawString;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Object object;
        boolean bl = !"no".equalsIgnoreCase(this.getParameter("SecondDerivative", "no"));
        this.xInput = new VariableInput(this.xVar.getName(), this.getParameter("X", "1"));
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
            this.derivExpression = this.functionInput.getExpression().derivative(this.xVar);
        } else {
            object = this.getParameter("Function");
            serializable3 = this.parser.parse((String)object);
            serializable2 = new SimpleFunction((Expression)serializable3, this.xVar);
            this.derivExpression = serializable3.derivative(this.xVar);
            this.func = new WrapperFunction((Function)serializable2);
        }
        object = new Graph1D(this.func);
        serializable3 = this.getColorParam("GraphColor", Color.black);
        ((Graph1D)object).setColor((Color)serializable3);
        this.deriv = this.func.derivative(1);
        serializable2 = new Graph1D(this.deriv);
        ((Graph1D)serializable2).setColor((Color)serializable3);
        Graph1D graph1D = null;
        if (bl) {
            this.deriv2 = this.deriv.derivative(1);
            graph1D = new Graph1D(this.deriv2);
            graph1D.setColor((Color)serializable3);
        }
        if (bl) {
            this.canvas.addNewCoordinateRect(0.0, 0.3333333333333333, 0.0, 1.0);
            this.canvas.addNewCoordinateRect(0.3333333333333333, 0.6666666666666666, 0.0, 1.0);
            this.canvas.addNewCoordinateRect(0.6666666666666666, 1.0, 0.0, 1.0);
        } else {
            this.canvas.addNewCoordinateRect(0.0, 0.5, 0.0, 1.0);
            this.canvas.addNewCoordinateRect(0.5, 1.0, 0.0, 1.0);
        }
        serializable3 = this.getColorParam("CanvasColor");
        if (serializable3 != null) {
            this.canvas.setBackground((Color)serializable3);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UsePanner", "no"))) {
            this.canvas.add(new Panner(), 0);
            this.canvas.add(new Panner(), 1);
            if (bl) {
                this.canvas.add(new Panner(), 2);
            }
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseGrid", "no"))) {
            serializable = new Grid();
            serializable3 = this.getColorParam("GridColor");
            if (serializable3 != null) {
                serializable.setColor((Color)serializable3);
            }
            this.canvas.add((Drawable)serializable, 0);
            serializable = new Grid();
            serializable3 = this.getColorParam("GridColor");
            if (serializable3 != null) {
                serializable.setColor((Color)serializable3);
            }
            this.canvas.add((Drawable)serializable, 1);
            if (bl) {
                serializable = new Grid();
                serializable3 = this.getColorParam("GridColor");
                if (serializable3 != null) {
                    serializable.setColor((Color)serializable3);
                }
                this.canvas.add((Drawable)serializable, 2);
            }
        }
        this.canvas.add(this.makeAxes(), 0);
        this.canvas.add(this.makeAxes(), 1);
        if (bl) {
            this.canvas.add(this.makeAxes(), 2);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseMouseZoom", "no"))) {
            this.canvas.setHandleMouseZooms(true);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("UseOffscreenCanvas", "yes"))) {
            this.canvas.setUseOffscreenCanvas(true);
        }
        this.mainController.setErrorReporter(this.canvas);
        this.mainPanel.add((Component)this.canvas, "Center");
        this.canvas.add((Drawable)object, 0);
        this.canvas.add((Drawable)serializable2, 1);
        if (bl) {
            this.canvas.add(graph1D, 2);
        }
        serializable = this.getColorParam("TangentColor", Color.red);
        Color color = this.getColorParam("TangentColor2", new Color(0, 180, 0));
        this.mainController.remove(this.canvas);
        this.mainController.add(object);
        this.mainController.add(serializable2);
        if (bl) {
            this.mainController.add(graph1D);
        }
        this.subController = new Controller();
        this.mainController.add(this.subController);
        TangentLine tangentLine = new TangentLine(this.xInput, this.func);
        Crosshair crosshair = new Crosshair((Value)this.xInput, this.deriv);
        tangentLine.setColor((Color)serializable);
        crosshair.setColor((Color)serializable);
        this.canvas.add(tangentLine, 0);
        this.canvas.add(crosshair, 1);
        this.subController.add(tangentLine);
        this.subController.add(crosshair);
        if (bl) {
            tangentLine = new TangentLine(this.xInput, this.deriv);
            crosshair = new Crosshair((Value)this.xInput, this.deriv2);
            tangentLine.setColor(color);
            crosshair.setColor(color);
            this.canvas.add(tangentLine, 1);
            this.canvas.add(crosshair, 2);
            this.subController.add(tangentLine);
            this.subController.add(crosshair);
        }
        this.functionName = this.getParameter("FunctionName", "f");
        String string = this.getParameter("YName", "y");
        Color color2 = this.getColorParam("TextColor", Color.black);
        Color color3 = this.getColorParam("TextBackground", Color.white);
        if ("yes".equalsIgnoreCase(this.getParameter("ShowGraphLabels", "yes"))) {
            drawString = new DrawString(string + " = " + this.functionName + "(" + this.xVar.getName() + ")");
            drawString.setColor(color2);
            drawString.setBackgroundColor(color3);
            drawString.setFrameWidth(1);
            this.canvas.add(drawString, 0);
            drawString = new DrawString(string + " = " + this.functionName + " ' (" + this.xVar.getName() + ")");
            drawString.setColor(color2);
            drawString.setBackgroundColor(color3);
            drawString.setFrameWidth(1);
            this.canvas.add(drawString, 1);
            if (bl) {
                drawString = new DrawString(string + " = " + this.functionName + " ' ' (" + this.xVar.getName() + ")");
                drawString.setColor(color2);
                drawString.setBackgroundColor(color3);
                drawString.setFrameWidth(1);
                this.canvas.add(drawString, 2);
            }
        }
        if ("yes".equalsIgnoreCase(this.getParameter("ShowValues", "yes"))) {
            drawString = new DrawString(this.functionName + "(#) = #", 8, new Value[]{this.xInput, new ValueMath(this.func, this.xInput)});
            drawString.setColor(color2);
            drawString.setBackgroundColor(color3);
            drawString.setFrameWidth(1);
            drawString.setNumSize(7);
            this.canvas.add(drawString, 0);
            this.subController.add(drawString);
            drawString = new DrawString(this.functionName + " ' (#) = #", 8, new Value[]{this.xInput, new ValueMath(this.deriv, this.xInput)});
            drawString.setColor(color2);
            drawString.setBackgroundColor(color3);
            drawString.setFrameWidth(1);
            drawString.setNumSize(7);
            this.canvas.add(drawString, 1);
            this.subController.add(drawString);
            if (bl) {
                drawString = new DrawString(this.functionName + " ' ' (#) = #", 8, new Value[]{this.xInput, new ValueMath(this.deriv2, this.xInput)});
                drawString.setColor(color2);
                drawString.setBackgroundColor(color3);
                drawString.setFrameWidth(1);
                drawString.setNumSize(7);
                this.canvas.add(drawString, 2);
                this.subController.add(drawString);
            }
        }
    }

    protected void addCanvasBorder() {
        double[] dArray = this.getNumericParam("BorderWidth");
        int n = dArray == null || dArray.length == 0 || dArray[0] > 25.0 ? 2 : (int)Math.round(dArray[0]);
        if (n > 0) {
            this.canvas.add(new DrawBorder(this.getColorParam("BorderColor", Color.black), n), 0);
            this.canvas.add(new DrawBorder(this.getColorParam("BorderColor", Color.black), n), 1);
            if (this.deriv2 != null) {
                this.canvas.add(new DrawBorder(this.getColorParam("BorderColor", Color.black), n), 2);
            }
        }
    }

    protected void doLoadExample(String string) {
        Object object;
        Object object2;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            object2 = string.substring(n + 1);
            string = string.substring(0, n);
            object = new StringTokenizer((String)object2, " ,");
            if (((StringTokenizer)object).countTokens() >= 4) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        Double d = new Double(((StringTokenizer)object).nextToken());
                        dArray[i] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (((StringTokenizer)object).countTokens() > 0) {
                    try {
                        Double d = new Double(((StringTokenizer)object).nextToken());
                        this.xInput.setVal(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                object2 = this.parser.parse(string);
                this.derivExpression = object2.derivative(this.xVar);
                object = new SimpleFunction((Expression)object2, this.xVar);
                ((WrapperFunction)this.func).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object2 = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object2).setLimits(dArray);
        ((CoordinateRect)object2).setRestoreBuffer();
        this.canvas.getCoordinateRect(1).setRestoreBuffer();
        if (this.deriv2 != null) {
            this.canvas.getCoordinateRect(0).setRestoreBuffer();
        }
        this.mainController.compute();
    }

    private class ExprLbl
    extends Label
    implements Computable {
        String label;

        ExprLbl(String string) {
            this.label = string;
            this.compute();
        }

        public void compute() {
            this.setText(this.label + ((Object)Derivatives.this.derivExpression).toString());
        }
    }
}

