/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include "render_svg.hpp"
#include "../message/Message.hpp"


using namespace std;

Times Svg::_start_interval_time = 0.;
Times Svg::_end_interval_time = 0.;
Element_pos Svg::_wide_factor = 200.;
Element_pos Svg::_height_factor = 20.;
double Svg::_epsilon = 0.1;
double Svg::_scale_frequency = 50.;


const double Svg::_MARGINSTATE = 0.5;
const int Svg::_MARGIN = 10;
const int Svg::_ARROWSIZE = 2;
const int Svg::_MARGINTOP = 20;
const int Svg::_WAIT_NEW_CHRONO = 0;
const int Svg::_INIT = 1;
const int Svg::_WAIT_FOR_POINT = 2;


void Svg::init(const char *path){

    _debug_svg_already_closed_once = false;

    cerr << "wide factor   : "; 
    cerr << _wide_factor << endl;


    cerr << "height factor : "; 
    cerr <<  _height_factor << endl;
  
    cerr << "accuracy      : "; 
    cerr << _epsilon << endl;
  
    _container_width_max = 0;
  
    _container_height_min = 1280;


    _svg_file.open(path, ofstream::out | ofstream::trunc);

    if (!_svg_file.is_open()) {
        *Message::get_instance() << "Unable to open " << path << Message::ende;
    }


    _buffer <<  "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n"
            <<  "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"  \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n"
            <<      "<svg xmlns=\"http://www.w3.org/2000/svg\" x=\"0\" y=\"0\" id=\"svg2\" style=\"background-color:#c1e9ed;\" >\n"
            <<      "\t<style type='text/css' id='stylecss' >\n"
            <<          "\t\t#undef {\n"
            <<              "\t\t\tfill:url(#Degrade);\n"
            <<              "\t\t}\n"
            <<          "\t\tline {\n"
            <<              "\t\t\tstroke:white;stroke-width:1\n"
            <<              "\t\t}\n"
            <<          "\t\tpolyline {\n"
            <<              "\t\t\tfill:white;stroke:white;stroke-width:1\n"
            <<              "\t\t}\n"
            <<          "\t\tpath {\n"
            <<              "\t\t\tfill:none;stroke:green;stroke-width:1\n"
            <<              "\t\t}\n"
	    <<          "\t\ttext {\n"
            <<              "\t\t\tfill:black;font-size:8px;\n"
            <<              "\t\t}\n"
            <<      "\t</style>\n"
            <<      "\t<desc>Rectangles</desc>\n"
            <<      "<g>"
            <<      "<defs>"
            <<      "<linearGradient id='Degrade'>"
	    <<      "<stop offset='5%' stop-color='#F60' />"
	    <<      "<stop offset='95%' stop-color='#FF6' />"
            <<      "</linearGradient>"
            <<      "</defs>";


    print();
}

void Svg::end(){

    if (_debug_svg_already_closed_once) {
        *Message::get_instance()<<"Svg::end() already called" << Message::ende;
        return;
    }
    else {
        _debug_svg_already_closed_once = true;
    }

    _svg_file.write(_buffer.str().c_str(), _buffer.str().size());
    _buffer.flush();
    _buffer.str("");


    _svg_file.write(_chronogramme.str().c_str(), _chronogramme.str().size());
    _chronogramme.flush();
    _chronogramme.str("");

    display_time_scale();    
    

    _thin_element_buffer << "\n<line id='cursor' x1='550' y1='0' x2='550' y2='100%' style='display:none;stroke:black;stroke-width:0.5'/><script><![CDATA[var cursor = document.getElementById('cursor');cursor.style.display='';document.onmousemove = function (event){cursor.setAttribute('x1',event.clientX);cursor.setAttribute('x2',event.clientX);}]]> </script></g></svg>";
    _svg_file.write(_thin_element_buffer.str().c_str(), _thin_element_buffer.str().size());
    _thin_element_buffer.flush();
    _thin_element_buffer.str("");

    

    _svg_file.close();
#ifdef TEST_SVG_MODE
    cout<< "output written" << endl;
#else
    //message_ns::message << "output written" << message_ns::endi;
#endif


    
}


void Svg::display_time_scale() {
    _total_width = _total_time;

    Element_pos w = _total_width*_wide_factor;
    Element_pos h =  (_MARGINTOP*1.0)/2;
    Element_pos x = _container_width_max + _MARGINSTATE;
    Element_pos y = 0;

    Element_col r = 255;
    Element_col g = 255;
    Element_col b = 255;


    _time_scale  << "\n<rect class='scale' title='scale'"
		 << "   width='"  << w
		 << "'  height='" << h
		 << "'  x='"      << x
		 << "'  y='"      << y
		 << "'  fill='rgb(" << r << "," << g << "," << b
                 << ")' stroke='black'"
		 << "  stroke-width='0.1'"
		 << "  />";

    if (_end_interval_time)
        _total_width = _total_time = min(_end_interval_time, _total_time);

    Element_pos inc;
    
   
    inc = _scale_frequency / _wide_factor;

    
    for(Element_pos i = _start_interval_time ; i < _total_time ; i+=inc) {
            
        x = i*_wide_factor + _container_width_max + _MARGINSTATE -_start_interval_time*_wide_factor;
      
        _time_scale << "<text x='" << x <<"' y='" << y + h << "'>|";
        _time_scale << i;
        _time_scale << "</text>";

    }
    


    _svg_file.write(_time_scale.str().c_str(),  _time_scale.str().size());
    _time_scale.flush();
    _time_scale.str("");

}

void Svg::set_height_factor (Element_pos h) {
    _height_factor = h;
}

void Svg::set_wide_factor (Element_pos w) {
    _wide_factor = w;
}

Element_pos Svg::get_height_factor() {
    return _height_factor;
}

Element_pos Svg::get_wide_factor() {
    return _wide_factor;
}


void Svg::set_interval(const Times t1, const Times t2) {
    _start_interval_time = t1;
    _end_interval_time = t2;
}

void Svg::set_accuracy(const double epsilon) {
    _epsilon = epsilon;
}


void Svg::set_scale_frequency(const Element_pos w) {
    _scale_frequency = w;
}

void Svg::set_total_width(const Element_pos) {
}
void Svg::set_total_time(const Times) {
}

Svg::~Svg() {
 
}
