/*
**  This file is part of Vidalia, and is subject to the license terms in the
**  LICENSE file, found in the top level directory of this distribution. If you
**  did not receive the LICENSE file with this file, you may obtain it from the
**  Vidalia source package distributed by the Vidalia Project at
**  http://www.vidalia-project.net/. No part of Vidalia, including this file,
**  may be copied, modified, propagated, or distributed except according to the
**  terms described in the LICENSE file.
*/

/*
** \file net.h
** \version $Id: net.h 2362 2008-02-29 04:30:11Z edmanm $
** \brief Common network I/O and utility functions
*/

#ifndef _NET_H
#define _NET_H

#include <QHostAddress>

/** Attempts a connection to <b>host</b> on <b>port</b>. Returns true if the
 * connection was successful, or false if the connection attempt failed. */
bool net_test_connect(QHostAddress host, quint16 port, int timeout = 250);

#endif

