/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD, Damien
	CALISTE, Olivier D'Astier, laboratoire L_Sim, (2001-2005)
  
	Adresses m�l :
	BILLARD, non joignable par m�l ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	Ce logiciel est un programme informatique servant � visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est r�gi par la licence CeCILL soumise au droit fran�ais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffus�e par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez acc�der � cet en-t�te signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept� les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD and Damien
	CALISTE and Olivier D'Astier, laboratoire L_Sim, (2001-2005)

	E-mail addresses :
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef POT2SURF_H
#define POT2SURF_H

#include "surfaces.h"
#include "scalarFields.h"

/**
 * pot2surf_direct:
 * @surf_file_to_write: target surf file
 * @pot_file_to_read: source pot file
 * @nsurfs_to_build: number of surfaces to build
 * @surf_value: an array with iso-values
 * @surf_name: an array with iso-surface names.
 *
 * Read the given pot file and produce an associated surf
 * file. WARNING, it may be removed later.
 *
 * Returns: 0 in case of success, n!=0 otherwise.
 */
int pot2surf_direct(const gchar *surf_file_to_write, const gchar *pot_file_to_read, int nsurfs_to_build, 
		    const float *surf_value, const gchar **surf_name);
/**
 * pot2surf:
 * @file_to_convert: target instruc file to execute
 * @file_created: a GString (will be filled with the name of the .surf file created)
 *
 * Tries to execute @file_to_convert as a .instruc file.
 * If @file_created is a valid GString, it will be filled with the name of the .surf
 * file created in case of success. If it's NULL, no information about the .surf file is written.
 *
 * Returns: 0 in case of success, n!=0 otherwise.
 */
int pot2surf(const char *file_to_convert, GString *file_created);

/**
 * pot2surfCreate:
 * @surf: a location on a #Surfaces pointer ;
 * @field: the scalar field to create the surface from ;
 * @isoValue: the value of the isosurface ;
 * @id: an integer identifying the surface ;
 * @name: the name of the surface to use (can be NULL).
 *
 * Call pot2surfCreate_uniform_mesh or pot2surfCreate_nonuniform_mesh
 * depending on the meshflag meshtype of the scalar field.
 * Then create on the fly a surface from the scalar field @field. If @name is given, the surface
 * is created with it, if not, "Isosurface @id + 1" is used. @surf can already
 * contains several surfaces, in that case, the new surface is added. If @surf is
 * NULL, then a new #Surfaces object is created and returned.
 * Returns: TRUE if the surface is created.
 */
gboolean pot2surfCreate(Surfaces **surf, ScalarField *field,
			double isoValue, int id, const gchar *name);

/**
 * pot2surfParse_XMLFile:
 * @filename: a path to a file.
 * @surfaces: a location on a #Surfaces pointer.
 * @field: the scalar field to create the surface from.
 * @error: a location to store a possible error.
 *
 * Parse the given XML file, looking for the <surfaces> tag and create
 * the given surfaces.
 *
 * Returns: FALSE if a error occured.
 */
gboolean pot2surfParse_XMLFile(const gchar* filename, Surfaces **surfaces,
			       ScalarField *field, GError **error);
gboolean pot2surfSave_XMLFile(const gchar* filename, float *values,
			      SurfaceResource **res, int n, GError **error);

#endif
