var UnityFaviconUtils = (function () {
  function findFaviconLink (document){
    var linkElements = document.getElementsByTagName("link");
    var i = 0;
    
    for (i = 0; i < linkElements.length; i++){
      var element = linkElements[i];
      
      if (element.hasAttribute("rel") &&
	  (element.rel == "shortcut icon")) {
	var link = element.href;
	
	if (link[0] == "/") {
	  return document.location + link;
	} else {
	  return link;
	}
      }
    }
    
    return null;
  }
  
  UnityFaviconUtils = {
    getFaviconForDocument: function (document) {
      var favIcon = findFaviconLink (document);
      
      if (favIcon == null) {
	favIcon = "http://" + document.domain + "/favicon.ico";
      }
      
      return favIcon;
    }
  }

  return UnityFaviconUtils;

}) ();

