/***************************************************************************
			       AddFolderThread.cpp
			      -------------------
 
     Begin	: Sat Oct 23 2007 10:00 alpha_one_x86
     Project      : Ultracopier
     Email	: ultracopier@first-world.info
     Note	 : See README for copyright and developer
     Target       : Define the class of the add folder threads
 
****************************************************************************/

#include "env.h"

#include <QDir>
#include <QFile>

#include "AddFolder.h"

/*! \brief Initilise the thread
*/
AddFolderThread::AddFolderThread(QObject * parent) :
		QThread(parent)
{
	dirSource		= "";
	stopped			= true;
	stopIt			= false;
	translationOfCopyOf	= tr("Copy of")+" ";
}

AddFolderThread::~AddFolderThread()
{
	if(isRunning())
		this->wait();
}

/** \brief set action if error
\param query the action number clicked
\sa env.h
*/
void AddFolderThread::actionAtError(int query)
{
	DEBUGCONSOLE(70,"AddFolderThread::actionAtError","start");
	actionNum=query;
	waitOneAction.release();
}

/*! \brief Wait the user action and store it
\param query the action number clicked
\sa env.h
*/
void AddFolderThread::action(const int query)
{
	DEBUGCONSOLE(70,"AddFolderThread::action","start");
	if(query==FILEEXIST_ACTION_CANCEL)
	{
		stop();
		return;
	}
	// Removed the 27 mars 2010 for prevent dead lock in var access
	//else if(query==FILEEXIST_ACTION_OVERWRITE)
	//	emit FolderSourceAndDestAreSame(dirDest.path());
	else
	{
		actionNum=query;
		waitOneAction.release();
	}
}

/*! \brief Start the listing thread
\warning The param of the listing need be already set
\sa setDir(), setFileListDropped() and stop()
*/
void AddFolderThread::run()
{
	stopped = false;
	stopIt = false;
	DEBUGCONSOLE(30,"AddFolderThread::run","start");
	//maybe list query
	if(!dirSource.path().isEmpty())
	{
		DEBUGCONSOLE(30,"AddFolderThread::run","!dirSource.path().isEmpty(): "+dirSource.path());
		urlList.append(QUrl().fromLocalFile(dirSource.path()));
		DEBUGCONSOLE(30,"AddFolderThread::run","urlList.append(QUrl().fromLocalFile(dirSource.path())): done");
	}
	DEBUGCONSOLE(30,"AddFolderThread::run","dirSource.path().isEmpty()==true");
	if(urlList.isEmpty())
	{
		DEBUGCONSOLE(10,"AddFolderThread::run","Internal error, the copy and the source folder is empty!");
		DEBUGCONSOLE(10,"AddFolderThread::run","dirSource.path(): "+dirSource.path());
	}
	else
	{
		//if given file and folder is list
		DEBUGCONSOLE(50,"AddFolderThread::run","Listed url");
		for (int i = 0; i < urlList.size() && !stopIt; ++i)
		{
			DEBUGCONSOLE(90,"AddFolderThread::run","urlList.at(i).toLocalFile(): "+urlList.at(i).toLocalFile());
			DEBUGCONSOLE(90,"AddFolderThread::run","dirDest.path(): "+dirDest.path());
			if(QFileInfo(urlList.at(i).toLocalFile()).isFile() ||
			#ifdef Q_OS_UNIX
			QFileInfo(urlList.at(i).toLocalFile()).isSymLink() ||
			#endif
			(!QFileInfo(urlList.at(i).toLocalFile()).isDir() && !urlList.at(i).toLocalFile().endsWith('\\')  && !urlList.at(i).toLocalFile().endsWith('/')))
			{
				DEBUGCONSOLE(90,"AddFolderThread::run","Source=\""+urlList.at(i).toLocalFile()+"\", dirDest="+dirDest.path());
				emit addToCopyList(QFileInfo(urlList.at(i).toLocalFile()),QFileInfo(dirDest.path()));
			}
			else
			{
				DEBUGCONSOLE(90,"AddFolderThread::run","if("+QString::number(QFileInfo(urlList.at(i).toLocalFile()).isFile())+" || (!"+QString::number(QFileInfo(urlList.at(i).toLocalFile()).isDir())+" && !"+QString::number(urlList.at(i).toLocalFile().endsWith('\\'))+"  && !"+QString::number(urlList.at(i).toLocalFile().endsWith('/'))+"))");
				dirSource=urlList.at(i).toLocalFile();
				if(dirSource.absolutePath()=="" && !urlList.at(i).isEmpty())
				{
					DEBUGCONSOLE(10,"AddFolderThread::run",QString("dirSource is empty and urlList.at(")+QString::number(i)+"): \""+urlList.at(i).path()+"\" and \""+urlList.at(i).toString()+"\"");
					dirSource=urlList.at(i).toString();
				}
				else
				{
					DEBUGCONSOLE(90,"AddFolderThread::run","dirDest: "+dirDest.path()+", dirSource: "+dirSource.path());
					QDir dirDestTemp=dirDest;
					/// \note Important code
					//add of destination the last directory in the sources
					//if source is /home/user/sources/
					//add destination /home/user/
					//final destination should by: /home/user/sources/, ... renaming...
					DEBUGCONSOLE(90,"AddFolderThread::run","dirSource.dirName(): \""+dirSource.dirName()+"\"");
					//add here folder source name to destination
					if(!dirDest.path().endsWith('\\') && !dirDest.path().endsWith('/'))
					{
						DEBUGCONSOLE(90,"AddFolderThread::run","dirDest.setPath(\""+dirDest.path()+QDir::separator()+dirSource.dirName()+QDir::separator()+"\")");
						dirDest.setPath(dirDest.path()+QDir::separator()+dirSource.dirName()+QDir::separator());
					}
					else
					{
						DEBUGCONSOLE(90,"AddFolderThread::run","dirDest.setPath(\""+dirDest.path()+dirSource.dirName()+QDir::separator()+"\")");
						dirDest.setPath(dirDest.path()+dirSource.dirName()+QDir::separator());
					}
					actionNum=0;
					DEBUGCONSOLE(90,"AddFolderThread::run","dirDest: "+dirDest.path()+", dirSource: "+dirSource.path());
					//only manager same folder, same file is managed in the copy thread
					if(dirDest==dirSource)
					{
						DEBUGCONSOLE(50,"AddFolderThread::run","dirDest==dirSource, emit FolderSourceAndDestAreSame(\""+dirDest.path()+"\")");
						emit FolderSourceAndDestAreSame(dirDest.path());
						waitOneAction.acquire();
						if(stopIt || actionNum==FILEEXIST_ACTION_CANCEL)
						{
							stopIt=true;
							goto skipTheListing;
						}
						if(actionNum==FILEEXIST_ACTION_SKIP)
							goto skipTheListing;
						if(actionNum==FILEEXIST_ACTION_RENAME)
						{
							DEBUGCONSOLE(50,"AddFolderThread::run","Rename, multiple shot");
							DEBUGCONSOLE(90,"AddFolderThread::run","dirDest: "+dirDest.dirName()+", dirSource: "+dirSource.dirName());
							QString NewName=translationOfCopyOf+dirDest.dirName();
							dirDest.cdUp();
							if(dirDest.path().endsWith('\\') || dirDest.path().endsWith('/'))
								dirDest.setPath(dirDest.path()+NewName);
							else
								dirDest.setPath(dirDest.path()+'/'+NewName);
							DEBUGCONSOLE(90,"AddFolderThread::run","dirDest: "+dirDest.dirName()+", dirSource: "+dirSource.dirName());
						}
					}
					DEBUGCONSOLE(90,"AddFolderThread::run","dirDest="+dirDest.path()+", Source=\""+dirSource.path()+"\"");
					DEBUGCONSOLE(90,"AddFolderThread::run","emit putToSourceDirList(\""+dirSource.path()+"\")");
					emit putToSourceDirList(QDir(dirSource));
					scandir();
					dirDest=dirDestTemp;
				}
			}
		}
	}
	skipTheListing:
	//reset the dirSource
	dirSource="";
	sourceDirList.clear();
	stop();
	stopIt=true;
	DEBUGCONSOLE(70,"AddFolderThread::run","Stop and emit runTheCopy()");
	stopped = true;
}

/*! \brief Stop the listing thread

Close condition wait, unlock mutex...
\sa run()
*/
void AddFolderThread::stop()
{
	DEBUGCONSOLE(90,"AddFolderThread::stop","start");
	stopIt = true;
	while(waitOneAction.available()<=0)
		waitOneAction.release();
	waitOneAction.acquire();
	DEBUGCONSOLE(90,"AddFolderThread::stop","stop");
}

/*! \brief Wait the user action and store it
\param dir Set the url of destination or source directory
\param isDestDir if true texte set the destination directory else it set the source directory
\sa setFileListDropped() */
void AddFolderThread::setDir(const QDir& dir,bool isDestDir)
{
	if(this->isRunning())
	{
		DEBUGCONSOLE(10,"AddFolderThread::setDir","the current thread is not finished");
		return;
	}
	// if isDestDir then this slot define the Destination Directory
	if(isDestDir)
	{
		dirDest = dir;
		DEBUGCONSOLE(90,"AddFolderThread::setDir","dirDest define mode");
		DEBUGCONSOLE(90,"AddFolderThread::setDir","Is set as: "+dir.path());
	}
	else // else it define the source directory
	{
		dirSource = dir;
		DEBUGCONSOLE(90,"AddFolderThread::setDir","dirSource define mode");
		DEBUGCONSOLE(90,"AddFolderThread::setDir","dirSource: "+dirSource.path());
	}
}

/*! \brief Set the list of url that should be listed
\param url The list of url as QList<QUrl>
\sa setDir() */
void AddFolderThread::setFileListDropped(const QList<QUrl>& url)
{
	if(this->isRunning())
	{
		DEBUGCONSOLE(10,"AddFolderThread::setFileListDropped","the current thread is not finished");
		return;
	}
	urlList=url;
	DEBUGCONSOLE(50,"AddFolderThread::setFileListDropped","Start");
	#if (DEBUG_ULTRACOPIER>0)
	for (int i = 0; i < urlList.size(); ++i)
	{
		if(urlList.at(i).isEmpty())
			DEBUGCONSOLE(50,"AddFolderThread::setFileListDropped","urlList.at("+QString::number(i)+") is empty");
	}
	#endif
	DEBUGCONSOLE(90,"AddFolderThread::setFileListDropped","Stop");
}

/*! \brief Recursive loop for list directory
\param dirPath The name of the current directory
for root need be call with dirPath=""
*/
void AddFolderThread::scandir(const QString& dirPath)
{
	if(stopIt)
		return;
	QString finalSource;
	if(!dirSource.path().endsWith('\\') && !dirSource.path().endsWith('/'))
		finalSource = dirSource.path()+'/'+dirPath;
	else
		finalSource = dirSource.path()+dirPath;
	QString finalDest;
	if(!dirDest.path().endsWith('\\') && !dirDest.path().endsWith('/'))
		finalDest = dirDest.path()+'/'+dirPath;
	else
		finalDest = dirDest.path()+dirPath;
	DEBUGCONSOLE(90,"AddFolderThread::scandir","finalSource: "+finalSource+", finalDest: "+finalDest);
	//if destination is empty
	if(finalDest.isEmpty())
	{
		DEBUGCONSOLE(10,"AddFolderThread::scandir","finalDest is empty!");
		return;
	}
	//if source is empty
	if(finalSource.isEmpty())
	{
		DEBUGCONSOLE(10,"AddFolderThread::scandir","finalSource is empty!");
		return;
	}
	QDir dir(finalSource);
	if(!dir.exists())
	{
		DEBUGCONSOLE(10,"AddFolderThread::scandir","The dir folder not exists!");
		return;
	}
	QFileInfo infoDir(finalSource);
	//check if unique
	if(sourceDirList.lastIndexOf(dir)==-1)
	{
		sourceDirList<<dir;
		emit putToDirList(dir);
	}
	else
	{
		DEBUGCONSOLE(90,"AddFolderThread::scandir","dir: \""+finalSource+"\" not added because exists!");
	}
	do
	{
		actionNum=0;
		if(!infoDir.isReadable() || !infoDir.isExecutable() || !infoDir.exists())
		{
			if(!infoDir.exists())
				emit ErrorInListing(finalSource,tr("The folder not exists"));
			else
				emit ErrorInListing(finalSource,tr("The folder is not readable"));
			waitOneAction.acquire();
			DEBUGCONSOLE(90,"AddFolderThread::scandir","actionNum: "+QString::number(actionNum));
			if(stopIt || actionNum==ERRORACTION_CLOSE)
				return;
		}
	} while(actionNum==ERRORACTION_RETRY);
	if(actionNum!=ERRORACTION_SKIP)
	{
		QFileInfoList list = dir.entryInfoList(QDir::AllEntries|QDir::NoDotAndDotDot|QDir::Hidden|QDir::System,QDir::DirsFirst);
		if(list.isEmpty())
		{
			DEBUGCONSOLE(90,"AddFolderThread::scandir","The folder is empty");
			//add the empty folder to list
			emit putToDirDestinationEmptyList(QDir(finalDest));
		}
		else
		{
			if(stopIt)
				return;
			for (int i=0;i< list.size();++i)
			{
				QFileInfo fileInfo=list.at(i);
				if(!fileInfo.isDir()
				#ifdef Q_OS_UNIX
				|| fileInfo.isSymLink()
				#endif
				)
				{
					//add the file in the list
					DEBUGCONSOLE(90,"AddFolderThread::scandir","File emit: "+fileInfo.path()+", "+finalDest);
					emit addToCopyList(fileInfo,QFileInfo(finalDest));
				}
				else
				{
					DEBUGCONSOLE(90,"AddFolderThread::scandir","Folder need to scan: "+dirPath+fileInfo.fileName());
					//return the fonction for scan the new folder
					if(!fileInfo.fileName().endsWith('/') && !fileInfo.fileName().endsWith('\\'))
						scandir(dirPath+fileInfo.fileName()+'/');
					else
						scandir(dirPath+fileInfo.fileName());
				}
				if(stopIt)
					return;
			}
		}
	}
}
