/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 396 $
 * $Date: 2012-02-19 16:31:43 +0800 (Sun, 19 Feb 2012) $
 */
#include "Splash.hpp"

#include "../reg/Components.hpp"
#include "../meta.hpp"

#include "wx/dcmemory.h"
#include "wx/settings.h"

using namespace indii;

Splash::Splash(wxBitmap* bmp, const Components::Component c) : wxBitmap(bmp->GetWidth(), bmp->GetHeight() + 32) {
  wxMemoryDC dc(*this);
  dc.DrawBitmap(*bmp, 0, 0);
      
  if (Components::isActivated(c)) {
    SetHeight(GetHeight() - 32);
  } else {
    /* add message giving days left */
    int daysLeft = Components::daysLeft();
    wxRect bounds(0, GetHeight() - 32, GetWidth(), 32);

    /* construct message */
    wxString message(_(""));

    if (daysLeft == 21) {
      message.Append(_("Welcome to "));
      message.Append(_(PACKAGE_NAME));
      message.Append(_(". Your 21 day trial starts today."));
    } else if (daysLeft == 0) {
      message.Append(_("Your "));
      message.Append(_(PACKAGE_NAME));
      message.Append(_(" trial period has expired."));
    } else {
      message.Append(_("You have "));
      if (daysLeft == 1) {
        message.Append(_("only "));
        message = message << daysLeft;
        message.Append(_(" day"));
      } else if (daysLeft > 0 && daysLeft <= 7) {
        message.Append(_("only "));
        message = message << daysLeft;
        message.Append(_(" days"));
      } else {
        message = message << daysLeft;
        message.Append(_(" days"));
      }
      message.Append(_(" left in your trial period."));
    }
    if (daysLeft <= 7) {
      dc.SetBrush(*wxRED);
    } else {
      dc.SetBrush(*wxBLACK);
    }
    #ifndef WX_28
    dc.SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT).Bold());
    #else
    wxFont fntDc(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
    fntDc.SetWeight(wxFONTWEIGHT_BOLD);
    dc.SetFont(fntDc);
    #endif
    dc.SetPen(wxNullPen);
    dc.SetTextBackground(*wxWHITE);
    dc.SetTextForeground(*wxWHITE);
    dc.DrawRectangle(bounds.GetX(), bounds.GetY(), bounds.GetWidth(), bounds.GetHeight());
    dc.DrawLabel(message, bounds, wxALIGN_CENTRE|wxALIGN_CENTRE_VERTICAL);
  }
}
