require 'tofu/tofulet'
require 'drb/drb'

def setup_bartender
  require 'yourapp'
  Tofu::Bartender.new(YourTofuSession)
end


def main
  DRb.start_service

  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)

  s = WEBrick::HTTPServer.new(:Port => 2000,
                             :AddressFamily => Socket::AF_INET,
                             :BindAddress => '127.0.0.1',
                             :Logger => logger)

  bartender = setup_bartender
  logger.info "SumDiv: #{SumDiv.ancestors.inspect}"
  logger.info "BaseDiv: #{BaseDiv.ancestors.inspect}"
  s.mount("/div", WEBrick::Tofulet, bartender)

  trap("INT"){ s.shutdown }
  s.start
end

if ARGV.size != 2 then
  $stderr.puts "usage: ruby tofu-runner.rb BASEDIV SUMDIV"
  $stderr.puts
  $stderr.puts "  BASEDIV and SUMDIV is 'erb' or 'tempura'"
  $stderr.puts "    erb: use a div by Div::Div. This is a Div original version."
  $stderr.puts "    tempura: use a div by Tempura::Div.This is a Div::Div of Tempura version."
  $stderr.puts
  $stderr.puts "  EXAMPLE"
  $stderr.puts "    ruby tofu-runner.rb erb tempura => BaseDiv.is_a? Div::Div and SumDiv.is_a? Tempura::Div"
  $stderr.puts "    ruby tofu-runner.rb tempura erb => BaseDiv.is_a? Tempura::Div and SumDiv.is_a? Div::Div"
  exit 1
end
$BASEDIV = ARGV.shift
$SUMDIV = ARGV.shift

main
