/***************************************************************************
 *  IChannelText.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using NDesk.DBus;
using org.freedesktop.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void LostMessageHandler ();
	public delegate void ReceivedHandler (uint id, uint timestamp, uint sender, MessageType type, MessageFlag flags, string text);
	public delegate void SendErrorHandler (MessageSendError error, uint timestamp, MessageType type, string text);
	public delegate void SentHandler (uint timestamp, MessageType type, string text);

	public enum MessageSendError : uint
	{
		Unknown = 0,
		Offline = 1,
		InvalidContact = 2,
		PermissionDenied = 3,
		TooLong = 4
	}

	public enum MessageType : uint
	{
		Normal = 0,
		Action = 1,
		Notice = 2,
		AutoReply = 3
	}

	public enum MessageFlag : uint
	{
		Truncated = 1
	}

	public struct PendingMessageInfo
	{
		public uint Id;
		public uint TimeStamp;
		public uint ContactHandle;
		public MessageType Type;
		public MessageFlag Flags;
		public string Message;
	}

	[Interface ("org.freedesktop.Telepathy.Channel.Type.Text")]
	public interface IChannelText : IChannel
	{
		event LostMessageHandler LostMessage;
		event ReceivedHandler Received;
		event SendErrorHandler SendError;
		event SentHandler Sent;

	 	void AcknowledgePendingMessages (uint[] ids);
	 	uint[] MessageTypes { get; }
	 	PendingMessageInfo[] ListPendingMessages (bool clear);
	 	void Send (MessageType type, string text);
	}
}
