#
# antirefspamfilter.rb
#
# Copyright (c) 2004-2005 T.Shimomura <redbug@netlife.gr.jp>
# You can redistribute it and/or modify it under GPL2.
# Please use version 1.0.0 (not 1.0.0G) if GPL doesn't want to be forced on me.
#

require 'net/http'
require 'uri'

module TDiary
  module Filter

    class AntirefspamFilter < Filter
      # ͭˤȻꤷե˥ǥХåʸɵ
      def debug_out(filename, str)
        if $debug
          filename = File.join(@conf.data_path,"AntiRefSpamFilter",filename)
          File::open(filename, "a+") {|f|
            f.puts str
          }
        end
      end

      # str ˻ꤵ줿ʸŬڤʥޤǤ뤫å
      def isIncludeMyUrl(str)
        # str URLޤޤƤ뤫ɤ
        base_url = @conf.base_url
        unless base_url.empty?
          if str.include? base_url
            return true
          end
        end

        # str ˥ȥåץڡURLޤޤƤ뤫ɤ
        unless @conf.index_page.empty?
          if /\Ahttps?:\/\// =~ @conf.index_page
            if str.include? @conf.index_page
              return true
            end
          end
        end

        # str ˵Ƥ褬ޤޤƤ뤫ɤ
        if (myurl = @conf['antirefspam.myurl']) && !myurl.empty?
          if str.include? myurl
            return true
          end
          
          url = myurl.gsub("/", "\\/").gsub(":", "\\:")
          exp = Regexp.new(url)
          if exp =~ str
            return true
          end
        end

        return false
      end

      def referer_filter(referer)
        conf_disable = @conf['antirefspam.disable'] != nil ? @conf['antirefspam.disable'].to_s : ''
        conf_checkreftable = @conf['antirefspam.checkreftable'] != nil ? @conf['antirefspam.checkreftable'].to_s : ''
        conf_trustedurl = @conf['antirefspam.trustedurl'] != nil ? @conf['antirefspam.trustedurl'].to_s : ''
        conf_proxy_server = @conf['antirefspam.proxy_server'] != nil && @conf['antirefspam.proxy_server'].size > 0 ? @conf['antirefspam.proxy_server'].to_s : nil
        conf_proxy_port = @conf['antirefspam.proxy_port'] != nil && @conf['antirefspam.proxy_port'].size > 0 ? @conf['antirefspam.proxy_port'].to_s : nil

        if conf_disable == 'true'  or    # 󥯸åͭǤϤʤϥ롼
           referer == nil          or    # 󥯸̵
           referer.size <= 1       or    # Υƥʤǹ郎ʤʤб뤿ᡢ󥯸ʸξϵ
           isIncludeMyUrl(referer)       # ʬ⤫Υ󥯤Ͽꤹ
        then
          return true
        end

        # "ǤURL" 򣱤ĤļФrefererȹפ뤫å
        conf_trustedurl.each_line do |trusted|
          trusted.sub!(/\r?\n/,'')
          next if trusted =~ /\A(\#|\s*)\z/  # #ޤ϶ǻϤޤԤɤФ
          
          # ޤ "Ǥ URL"  referer ˴ޤޤ뤫ɤ
          if referer.include? trusted
            debug_out("trusted", trusted+" (include?) "+referer)
            return true
          end
          
          # ޤޤʤä "Ǥ URL" ɽȤߤʤƺƥå
          begin
            if referer =~ Regexp.new( trusted.gsub("/", "\\/").gsub(":", "\\:") )
              debug_out("trusted", trusted+" (=~) "+referer)
              return true
            end
          rescue
            debug_out("error_config", "trustedurl: "+trusted)
          end
        end

        # URLִꥹȤ򸫤
        if conf_checkreftable == 'true'
          # "URLִꥹ" 򣱤ĤļФrefererȹפ뤫å
          @conf.referer_table.each do |url, name|
            begin
              if /#{url}/i =~ referer && url != '^(.{50}).*$'
                debug_out("trusted", url+" (=~referer_table)  "+referer)
                return true
              end
            rescue
              debug_out("error_config", "referer_table: "+url)
            end
          end
        end

        @work_path = File.join(@conf.data_path,"AntiRefSpamFilter")
        @spamurl_list = File.join(@work_path,"spamurls")  # referer spam Υ󥯸
        @spamip_list  = File.join(@work_path,"spamips")   # referer spam IP
        @safeurl_list = File.join(@work_path,"safeurls")  # 餯Τʤ󥯸

        # ǥ쥯ȥ/ե뤬¸ߤʤк
        unless File.exist? @work_path
          Dir::mkdir(@work_path)
        end
        unless File.exist? @spamurl_list
          File::open(@spamurl_list, "a").close
        end
        unless File.exist? @safeurl_list
          File::open(@safeurl_list, "a").close
        end

        uri = URI.parse(referer)
        temp_filename = File.join(@work_path,uri.host)
        # åˤоݤΥɥᥤ̾äե
        begin
          File::open(temp_filename, File::RDONLY | File::CREAT | File::EXCL).close

          #  SPAM URL Ȥߤʤʸϰʸϵ
          spamurls = IO::readlines(@spamurl_list).map {|url| url.chomp }
          if spamurls.include? referer
            return false
          end

          #  SPAM URL ǤʤȽǤʸϵ
          safeurls = IO::readlines(@safeurl_list).map {|url| url.chomp }
          if safeurls.include? referer
            return true
          end

          # 󥯸 URL  HTML ĥäƤ
          Net::HTTP.version_1_2   # ޤʤ餷
          body = ""
          begin
            Net::HTTP::Proxy(conf_proxy_server, conf_proxy_port).start(uri.host, uri.port) do |http|
              if uri.path == ""
                response, = http.get("/")
              else
                response, = http.get(uri.request_uri)
              end
              body = response.body
            end

            # body  URL ޤޤƤʤ SPAM Ȥߤʤ
            unless isIncludeMyUrl(body)
              File::open(@spamurl_list, "a+") {|f|
                f.puts referer
              }
              File::open(@spamip_list, "a+") {|f|
                f.puts [@cgi.remote_addr, Time.now.utc.strftime("%Y/%m/%d %H:%M:%S UTC")].join("\t")
              }
              return false
            else
              File::open(@safeurl_list, "a+") {|f|
                f.puts referer
              }
            end
          rescue
            # 顼Ф @spamurl_list ʤ󥯸ˤʤ
            return false
          end

        rescue StandardError, TimeoutError
          # ߥåʤ顢ϥ󥯸˴ꤷʤ
          return false
        ensure
          begin
            File::delete(temp_filename)
          rescue
          end
        end

        return true
      end



      def log_spamcomment( diary, comment )
        @work_path = File.join(@conf.data_path,"AntiRefSpamFilter")
        @spamcomment_list = File.join(@work_path,"spamcomments")  # comment spam ΰ

        # ǥ쥯ȥ/ե뤬¸ߤʤк
        unless File.exist? @work_path
          Dir::mkdir(@work_path)
        end
        unless File.exist? @spamcomment_list
          File::open(@spamcomment_list, "a").close
        end

        File::open(@spamcomment_list, "a+") {|f|
          f.puts "From: "+comment.name+" <"+comment.mail+">"
          f.puts "To: "+diary.date.to_s
          f.puts "Date: "+comment.date.to_s
          f.puts comment.body
          f.puts ".\n\n"
        }
      end

      def comment_filter( diary, comment )
        # ĥåߤܸ(Ҥ餬/)ޤޤƤʤԵ
        if @conf['antirefspam.comment_kanaonly'] != nil
          if @conf['antirefspam.comment_kanaonly'].to_s == 'true'
            unless comment.body =~ /[--]/
              log_spamcomment( diary, comment )
              return false
            end
          end
        end

        # ĥåߤʸꤷ°ǤʤʤԵ
        maxsize = @conf['antirefspam.comment_maxsize'].to_i
        if maxsize > 0
          unless comment.body.size <= maxsize
            log_spamcomment( comment )
            return false
          end
        end

        # NGɤĤǤޤޤƤԵ
        if @conf['antirefspam.comment_ngwords'] != nil
          ngwords = @conf['antirefspam.comment_ngwords']
          ngwords.to_s.each_line do |ngword|
            ngword.sub!(/\r?\n/,'')
            if comment.body.downcase.include? ngword.downcase
              log_spamcomment( comment )
              return false
            end

            # ޤޤʤä "NG" ɽȤߤʤƺƥå
            begin
              if comment.body =~ Regexp.new( ngword, Regexp::MULTILINE )
                log_spamcomment( comment )
                return false
              end
            rescue
              debug_out("error_config", "comment_ngwords: "+ngword)
            end
          end
        end

        return true
      end
    end
  end
end
