/* === S Y N F I G ========================================================= */
/*!	\file keyframewaypointset.cpp
**	\brief Template File
**
**	$Id: keyframewaypointset.cpp 336 2007-03-16 00:39:42Z dooglus $
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === H E A D E R S ======================================================= */

#ifdef USING_PCH
#	include "pch.h"
#else
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include "keyframewaypointset.h"
#include <synfigapp/canvasinterface.h>
#include <synfig/valuenode_dynamiclist.h>
#include <synfig/valuenode_animated.h>
#include "activepointsetsmart.h"
#include "waypointsetsmart.h"

#endif

using namespace std;
using namespace etl;
using namespace synfig;
using namespace synfigapp;
using namespace Action;

/* === M A C R O S ========================================================= */

ACTION_INIT(Action::KeyframeWaypointSet);
ACTION_SET_NAME(Action::KeyframeWaypointSet,"keyframe_waypoint_set");
ACTION_SET_LOCAL_NAME(Action::KeyframeWaypointSet,"Set Waypoints at Keyframe");
ACTION_SET_TASK(Action::KeyframeWaypointSet,"set");
ACTION_SET_CATEGORY(Action::KeyframeWaypointSet,Action::CATEGORY_KEYFRAME);
ACTION_SET_PRIORITY(Action::KeyframeWaypointSet,0);
ACTION_SET_VERSION(Action::KeyframeWaypointSet,"0.0");
ACTION_SET_CVS_ID(Action::KeyframeWaypointSet,"$Id: keyframewaypointset.cpp 336 2007-03-16 00:39:42Z dooglus $");

/* === G L O B A L S ======================================================= */

/* === P R O C E D U R E S ================================================= */

/* === M E T H O D S ======================================================= */

Action::KeyframeWaypointSet::KeyframeWaypointSet()
{
	keyframe.set_time(Time::begin()-1);
	set_dirty(false);
}

Action::ParamVocab
Action::KeyframeWaypointSet::get_param_vocab()
{
	ParamVocab ret(Action::CanvasSpecific::get_param_vocab());

	ret.push_back(ParamDesc("keyframe",Param::TYPE_KEYFRAME)
		.set_local_name(_("Keyframe"))
	);

	ret.push_back(ParamDesc("model",Param::TYPE_WAYPOINTMODEL)
		.set_local_name(_("Waypoint Model"))
	);

	return ret;
}

bool
Action::KeyframeWaypointSet::is_candidate(const ParamList &x)
{
	return candidate_check(get_param_vocab(),x);
}

bool
Action::KeyframeWaypointSet::set_param(const synfig::String& name, const Action::Param &param)
{
	if(name=="keyframe" && param.get_type()==Param::TYPE_KEYFRAME)
	{
		keyframe=param.get_keyframe();

		return true;
	}
	if(name=="model" && param.get_type()==Param::TYPE_WAYPOINTMODEL)
	{
		waypoint_model=param.get_waypoint_model();

		return true;
	}

	return Action::CanvasSpecific::set_param(name,param);
}

bool
Action::KeyframeWaypointSet::is_ready()const
{
	if(keyframe.get_time()==(Time::begin()-1) || waypoint_model.is_trivial())
		return false;
	return Action::CanvasSpecific::is_ready();
}

void
Action::KeyframeWaypointSet::prepare()
{
	clear();

	try { get_canvas()->keyframe_list().find(keyframe);}
	catch(synfig::Exception::NotFound)
	{
		throw Error(_("Unable to find the given keyframe"));
	}

	{
		std::vector<synfigapp::ValueDesc> value_desc_list;
		get_canvas_interface()->find_important_value_descs(value_desc_list);
		while(!value_desc_list.empty())
		{
			process_value_desc(value_desc_list.back());
			value_desc_list.pop_back();
		}
	}
}

void
Action::KeyframeWaypointSet::process_value_desc(const synfigapp::ValueDesc& value_desc)
{
	if(value_desc.is_value_node())
	{
		ValueNode_Animated::Handle value_node(ValueNode_Animated::Handle::cast_dynamic(value_desc.get_value_node()));

		if(value_node)
		{
			Action::Handle action(WaypointSetSmart::create());

			action->set_param("canvas",get_canvas());
			action->set_param("canvas_interface",get_canvas_interface());
			action->set_param("value_node",ValueNode::Handle(value_node));

			Waypoint waypoint;
			try
			{
				waypoint=*value_node->find(keyframe.get_time());
			}
			catch(...)
			{
				waypoint.set_time(keyframe.get_time());
				waypoint.set_value((*value_node)(keyframe.get_time()));
			}
			waypoint.apply_model(waypoint_model);

			action->set_param("waypoint",waypoint);

			assert(action->is_ready());
			if(!action->is_ready())
				throw Error(Error::TYPE_NOTREADY);

			add_action_front(action);
		}
	}
}
