#include "header.h"

#include <grp.h>
#include <string.h>
struct cfg *cfg;
struct mixer *mix;

int udpsock;
int udpport=NET_PORT;
int killssbd;
char *kill_ip=NULL;

struct sockaddr_in reply_sin;
socklen_t reply_socklen;
char reply_data[256];
int nofork=0;

int init_net_udp(void){
    int on;
    struct sockaddr_in sin;
    socklen_t socklen;


    udpsock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (udpsock < 0) goto err;

    on=1;
/*    if (setsockopt(udpsock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))){
        error("Can't set SO_REUSEADDR");
        goto err;
    }*/
    
    if (fcntl(udpsock, F_SETFL, O_NONBLOCK)){
        error("Can't set O_NONBLOCK");
        goto err;
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(udpport);
    sin.sin_addr.s_addr = INADDR_ANY;
    if (bind(udpsock, (struct sockaddr *)&sin, sizeof(sin))){
        error("Can't bind UDP port %d", udpport);
        goto err;
    }
    
    memset(&sin, 0, sizeof(sin));
    socklen = sizeof(sin);
    getsockname(udpsock, (struct sockaddr *) &sin, &socklen);
    
    memset(&reply_sin, 0, sizeof(reply_sin));
    strcpy(reply_data,"");
    set_handlers(udpsock, udp_read_handler, NULL, udp_exception_handler, NULL);

    return 0;
err:;
    close(udpsock);
    udpsock = -1;
    
    /* kill_timer not needed */
    return 1;    
}


void free_udp(){
    set_handlers(udpsock, NULL, NULL, NULL, NULL);
    if (udpsock>=0) close(udpsock);
    udpsock=-1;
}

#define DELIM "\r\n"

#define REMEMBER_REPLY_ADDR memcpy(&reply_sin, &sin, sizeof(reply_sin));\
                            reply_socklen = socklen;


void dbgids(){
    int ruid,euid,suid,rgid,egid,sgid;
    getresuid(&ruid, &euid, &suid);
    getresgid(&rgid, &egid, &sgid);
    printf("UID %d/%d/%d GID %d/%d/%d\n", ruid, euid, suid, rgid, egid, sgid);
    system("id");
}

void udp_read_handler(void *data){
    char s[1024],*item,*token_ptr,*c;
    struct sockaddr_in sin;
    socklen_t socklen;
    int rcvd,a;
    struct passwd *pwd;
    struct group *grp;
    
    /*dbg("udp_read_handler()\n");*/

    memset(s, 0, sizeof(s));
    socklen = sizeof(sin);
    rcvd=recvfrom(udpsock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);

    if (rcvd<0) return;
    
    if (strlen(s)>0 && s[strlen(s)-1]=='\n') s[strlen(s)-1]='\0';
    if (strlen(s)>0 && s[strlen(s)-1]=='\r') s[strlen(s)-1]='\0';
    if (*s=='\0') return;
    
    REMEMBER_REPLY_ADDR;

    dbg(" **********   read='%s'-------\n",s);
    for (item=strtok_r(s,DELIM,&token_ptr); item!=NULL; item=strtok_r(NULL, DELIM, &token_ptr)){

        dbg("*** item='%s'\n",item);
        
            switch(*item){
            case 'a': /* abort play and rec */
                play_abort();
                break;

            case 'c': /* number of channels */ 
                cfg->channels = atoi(item+1); 
                break;              
                
            case 'd': /* set dsp filename */ 
                g_free(dsp->filename); 
                dsp->filename=g_strdup(item+1);
                break;
                
            case 'e': /* echo after end of sample */
                safe_strncpy0(reply_data, item, sizeof(reply_data));
              /*  dbg("echo %x %d '%s'\n", (int)reply_sin.s_addr,  reply_sin, reply_data);*/
                break;
                
            case 'f': /* libsndfile file format */
                cfg->format = strtol(item+1, NULL, 0);
                break;
            
                
            case 'k': /* kill (exit immediatelly) */ 
                dbg("ssbd(%d) exiting\n", getpid());
                sprintf(reply_data, "K%d", getpid());
                terminate=1;
                send_reply();
                /* TODO exit */
                break;       

            case 'm': /* umask */
                a=strtol(item+1, NULL, 0);
                if (a==cfg->umask) break;
                cfg->umask=a;
                a=umask(cfg->umask);
                dbg("oldumask=0%o umask=0%o\n",a, cfg->umask);
                break;
                
            case 'p': /* play file */
                c = convert_esc(item+1, CE_NONE);
                init_play_file(c);
                g_free(c);
                break;
                
            case 'r': /* record file */
                cfg->serno++;
                CONDGFREE(cfg->template);
                cfg->template=convert_esc(item+1, CE_ONLY_STRFTIME);
                /*cfg->template=g_strdup(item+1);*/
                c = convert_esc(item+1, CE_NONE);
                c=unique_filename(c);
                init_rec_file(c); 
                g_free(c);
                break;   

            case 's': /* rate of samples */
                cfg->samplerate = atoi(item+1);
                break;

            case 'u': /* user and group */
                if (strcmp(cfg->user, item+1)==0) break;
                g_free(cfg->user);
                cfg->user=g_strdup(item+1);
                
                pwd=getpwnam(cfg->user);
                if (!pwd){
                    error("Can't get info about user '%s'\n", cfg->user);
                    break;
                }
                
                grp=getgrgid(pwd->pw_gid);
                if (!grp){
                    error("Can't get info about group gid '%d'\n", pwd->pw_gid);
                    break;
                }

                
               // dbgids();
                a=setresuid(0,0,0);
               // dbg("setresuid(0) returns %d/%d\n", a, a?errno:0);
                a=setresgid(0,0,0);
               // dbg("setresgid(0) returns %d/%d\n", a, a?errno:0);
                dbgids();
                
                a=setresgid(-1, grp->gr_gid, 0);
               // dbg("setresgid(%d) returns %d/%d\n", grp->gr_gid, a, a?errno:0);
                a=initgroups(cfg->user, grp->gr_gid);
               // dbg("initgroups(%s,%d) returns %d/%d\n", cfg->user, grp->gr_gid, a, a?errno:0);
                
                a=setresuid(-1, pwd->pw_uid, 0);
               // dbg("setresuid(%s/%d) returns %d/%d\n", cfg->user, pwd->pw_uid, a, a?errno:0);
              //  dbgids();
                break;
            
                break;
            
            case 'v': /* received callsign */  
                CONDGFREE(cfg->callsign);
                cfg->callsign=g_strdup(item+1);
                break;

            case 'x': /* path to mixer */ 
                if (!mix) {
                    error("No mixer");
                    break;
                }
                mixer_set_filename(mix, item+1);
                break;
                
            case 'y': /* get recording source */ 
                if (!mix) {
                    error("No mixer");
                    break;
                }
                sprintf(reply_data, "Y%d %d", mix->recmask, mix->recsrc);
                send_reply();
                
                break;
            case 'z': /* set recording source */ 
                if (!mix) {
                    error("No mixer");
                    break;
                }
                mixer_set_source(mix, strtol(item+1, NULL, 0));
                break;
            default:
                dbg("unknown command '%s'\n",item);
        }
    }
            
}    

void udp_exception_handler(void *data){
    dbg("udp_exception_handler()\n");
}

int send_reply(){
    if (strlen(reply_data)==0) return 1;
    sendto(udpsock, reply_data, strlen(reply_data), 0, 
        (struct sockaddr *)&reply_sin, reply_socklen);
    strcpy(reply_data,"");
    return 0;
}               


void sigalrm(int sig){
    dbg("SIGALRM!\n");
}

void sigint(int sig){
    dbg("SIGINT!\n");
    play_abort();
    exit(1);
}

void sigterm(int sig){
    dbg("SIGTERM!\n");
    play_abort();
    exit(1);
}

void init(){
    /*debug_type=0;*/
    init_debug();
    set_sigcld();
    signal(SIGALRM, sigalrm);
    signal(SIGINT,  sigint);
    signal(SIGTERM, sigterm);
    cfg = g_new0(struct cfg,1);
    cfg->user=g_strdup("");
    cfg->umask=-1;
    cfg->euid=0;
    if (init_net_udp()) {
        terminate_all_subsystems();
        exit(1);
    }
    if (init_mon()) {
        terminate_all_subsystems();
        exit(1);
    }
    
    dsp=init_dsp("/dev/dsp");
    mix=init_mixer("/dev/mixer");
    
    if (!nofork){
        int pid;

        pid=fork();
        if (pid>0) exit(0); /* parent */

        if (pid==0) {  /* child */
            setsid();
            chdir("/");
            debug_type=0;
            fclose(stdin);
            fclose(stdout);
            fclose(stderr);
        }

        if (pid<0) { /* error */
            printf("Can't fork() ! \n");
            debug_type=2;
        }
    }
    
}

void terminate_all_subsystems(void){
    check_bottom_halves();
    check_bottom_halves();
    free_dsp(dsp);
    free_mixer(mix);
    free_mon();
    free_udp();

    CONDGFREE(cfg->filename);
    CONDGFREE(cfg->template );
    CONDGFREE(cfg->callsign);
    CONDGFREE(cfg->user);
    g_free(cfg);
}

char *parse_options(int argc, char **argv){
    int c;
    char *s;

    s=getenv("SSBD_DEBUG");
    if (s){
        if (strlen(s)!=0){
            debug_type=1;
            debug_filename=s;
        }else{
            debug_type=2;
        }
    }
    
    while (1){
            
        int option_index = 0;
        static struct option long_options[] = {
            {"debug", 2, 0, 'd'},
            {"help", 0, 0, 'h'},
            {"kill", 2, 0, 'k'},
            {"port", 1, 0, 'p'},
            {"version", 0, 0, 'v'},
            {0, 0, 0, 0}
        };

        c = getopt_long (argc, argv, "d:hknp:v?", long_options, &option_index);
        if (c == -1) break;
     /*   printf("c='%c\n",c);
       printf("optarg=%p '%s'\n", optarg,optarg);*/

        switch (c){
            case 0:
                printf ("option %s", long_options[option_index].name);
                if (optarg) printf (" with arg %s", optarg);
                printf ("\n");
                break;
            
            case 'd':
                if (optarg) {
                    debug_type=1;
                    debug_filename=optarg;
                }else{
                    debug_type=2;
                }
                break;

            case 'h':     
            case '?':
                printf("Options: ssbd -[dh?knpv]\n");
                
                exit(0);
                break;

            case 'k':
                killssbd=1;
                if (optarg){
                    kill_ip=optarg;
                }else{
                    kill_ip="127.0.0.1";
                }
                    
                break;

            case 'n':
                nofork=1; 
                debug_type=2; 
                break;   
           
            case 'p':
                udpport=atoi(optarg);
                break;
                
            case 'v':
                printf ("%s version %s\n", PACKAGE, VERSION);
                printf ("http://tucnak.nagano.cz/ssbd.html\n");
                
                exit(0);
                break;


            default:
                printf ("?? getopt returned character code 0%o ??\n", c);
        }
    }

    if (optind < argc){
        printf ("non-option ARGV-elements: ");
        while (optind < argc) printf ("%s ", argv[optind++]);
        printf ("\n");
    }

    return NULL;
}

void kill_ssbd(){
    int sock;
    struct sockaddr_in sin;
    char s[1024]="k";
    fd_set rfd;
    struct timeval tv;
    int ret;

    sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock < 0) return;

    if (fcntl(udpsock, F_SETFL, O_NONBLOCK)){
        error("Can't set O_NONBLOCK");
        return;
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(udpport);
    ret=inet_aton(kill_ip, &sin.sin_addr); 
    
    sendto(sock, s, strlen(s), 0, (struct sockaddr *)&sin, sizeof(sin));
    
    
    FD_ZERO(&rfd);
    FD_SET(sock, &rfd);
    tv.tv_sec=1;
    tv.tv_usec=0;
    memset(s, 0, sizeof(s));
    ret=select(sock+1, &rfd, NULL, NULL, &tv);
    if (ret<0){
        error("Select failed");
    }
    
    if (ret==0){
        error("Timeout!");
    }
    
    if (ret>0){
        if (FD_ISSET(sock, &rfd)){
            read(sock, s, 100);
            error("Killed PID %s", s+1);
        }
    }
    
    close(sock);
}



int main(int argc, char **argv){

    parse_options(argc, argv);
    
    if (udpport<=0 || udpport>65535){
        printf("UDP port must be 1..65535\n");
        exit(1);
    }

    if (killssbd) kill_ssbd();
        
    select_loop(init);
    terminate_all_subsystems();
    return 0;
}    
    

