#include <stdint.h>
#include "diskimage.h" 
#include "signode.h"
	
	
typedef struct NandFlashController NandFlashController;

typedef struct NFPlane {
	uint8_t page_reg[528];
} NFPlane;

typedef struct NandFlashDevice {
	NandFlashController *nfc;
	char *type;
	DiskImage *disk_image;
	SigNode *busySig;
	int page_pointer; /* A Area 0-255, B Area 256-511, C-Area 512-527 */
	uint8_t cmd;
	uint64_t addr; /* complete addr (row + column) */
	int state;
	int transfer_count;
	NFPlane *nfplane;
	int nfplanes;
	uint64_t addrmask;
} NandFlashDevice;

struct NandFlashController 
{
	void *owner;
	NandFlashDevice *nf_dev;
	//handleReply();
};

void NandFlash_RegisterController(NandFlashDevice *nfd,NandFlashController *nfc);
#define NFCTRL_CLE	(1)
#define NFCTRL_nCE	(2)
#define NFCTRL_nWE	(4)
#define NFCTRL_ALE	(8)
void NandFlash_Access(NandFlashDevice *nf,uint8_t *data,int ctrl);
NandFlashDevice * NandFlash_New(const char *name);
