/*
 * ----------------------------------------------------------------------
 * Virtual base class for keyboard emulation 
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * state: working with rfbserver as implementation of a keyboard 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "keyboard.h"
#include "sgstring.h"

/* 
 * --------------------------------------
 * Keyboard_AddListener
 * --------------------------------------
 */
void 
Keyboard_AddListener(Keyboard *keyboard,KeyEventProc *eventProc,void *clientData) 
{
	KeyboardListener *listener;
	if(!keyboard)
		return;
	listener = sg_new(KeyboardListener);

	listener->clientData = clientData;
	listener->eventProc = eventProc;
	listener->next = keyboard->listener_head;
	keyboard->listener_head = listener;
}

/*
 * ----------------------------------------------------------------------------
 * Keyboard_RemoveListener
 * 	Remove a keyevent sink from the linked list of listeners
 * ----------------------------------------------------------------------------
 */
void 
Keyboard_RemoveListener(Keyboard *keyboard,KeyEventProc *eventProc) 
{
	KeyboardListener *cursor,*prev;
	for(prev=NULL,cursor=keyboard->listener_head;cursor;prev=cursor,cursor=cursor->next) {
		if(cursor->eventProc == eventProc) {
			if(prev) {
				prev->next = cursor->next;
			} else {
				keyboard->listener_head = cursor->next;
			}
			free(cursor);
			return;
		}		
	}
}

/* 
 * ------------------------------------------------------------------------------
 * KeyBoard_SendEvent 
 * 	The SendEvent is done by the keyboard implementation when it
 *	finds a change in some key status. Example
 *	The rfbserver calls send event when it receives a key_event message
 *	from the vncclient
 * ------------------------------------------------------------------------------
 */
void 
Keyboard_SendEvent(Keyboard *keyboard,KeyEvent *event) 
{
	KeyboardListener *cursor;	
	if(!keyboard) {
		return;
	}
	for(cursor=keyboard->listener_head;cursor;cursor=cursor->next) {
		cursor->eventProc(cursor->clientData,event);	
	}
}

