CC=gcc
CPP=g++
RANLIB=ranlib
AR=ar

prefix=/usr/local
bindir=$(prefix)/bin
libdir=$(prefix)/lib/softgun/

#CFLAGS=-Wall -pg -O1 -g   
CFLAGS=-Wall -O9 -g  -fomit-frame-pointer
DEFS=-D_GNU_SOURCE

# ubuntu requires -nostdlib in compiler call 
# to omit stack protection symbol in object file
SHAREDCFLAGS=-fPIC -nostdlib  -D_SHARED_
SHAREDLDFLAGS=-nostdlib -shared
ifeq ($(shell uname),Linux)
LDFLAGS=-rdynamic -lpthread -ldl -lrt -lm -lz -lasound 
else
 ifeq ($(shell uname),FreeBSD)
 LDFLAGS=-rdynamic -lpthread -lm -lz -lSDL
 else
 $(error Unknown architecture)
 endif
endif
INCLUDES:=-I$(top_srcdir) -I.

.SUFFIXES: .c .o .be.o
.PHONY: clean all

%.be.o: %.c
	$(CC) $(CFLAGS) $(DEFS)  $(INCLUDES) -DTARGET_BIG_ENDIAN=1 -c -o $@ $<

%.o: %.c
	$(CC) $(CFLAGS) $(DEFS) $(INCLUDES) -DTARGET_BIG_ENDIAN=0 -o $@ -c $<


# Position independent version
%.po: %.c
	$(CC) $(SHAREDCFLAGS) $(CFLAGS) $(DEFS) $(INCLUDES) -DTARGET_BIG_ENDIAN=0 -o $@ -c $<

%.be.po: %.c
	$(CC) $(SHAREDCFLAGS) $(CFLAGS) $(DEFS) $(INCLUDES) -DTARGET_BIG_ENDIAN=1 -o $@ -c $<
