/*
 * -----------------------------------------------------------------------
 * Emulation of Freescale i.MX21 PCMCIA Controller  
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 * state: not implemented 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * -----------------------------------------------------------------------
 */
#include <errno.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <bus.h>
#include <imx21_pcmcia.h>

#define PCMCIA_PIPR(base)	((base) + 0x00)
#define PCMCIA_PSCR(base)	((base) + 0x04)
#define	PCMCIA_PER(base)	((base) + 0x08)
#define PCMCIA_PBR0(base)	((base) + 0x0c)
#define	PCMCIA_PBR1(base)	((base) + 0x10)
#define	PCMCIA_PBR2(base)	((base) + 0x14)
#define	PCMCIA_PBR3(base)	((base) + 0x18)
#define	PCMCIA_PBR4(base)	((base) + 0x1c)
#define	PCMCIA_POR0(base)	((base) + 0x28)
#define	PCMCIA_POR1(base)	((base) + 0x2c)
#define	PCMCIA_POR2(base)	((base) + 0x30)
#define	PCMCIA_POR3(base)	((base) + 0x34)
#define	PCMCIA_POR4(base)	((base) + 0x38)
#define PCMCIA_POFR0(base)	((base) + 0x44)
#define PCMCIA_POFR1(base)	((base) + 0x48)
#define PCMCIA_POFR2(base)	((base) + 0x4c)
#define PCMCIA_POFR3(base)	((base) + 0x50)
#define PCMCIA_POFR4(base)	((base) + 0x54)
#define PCMCIA_PGCR(base)	((base) + 0x60)
#define PCMCIA_PGSR(base)	((base) + 0x64)

typedef struct IMX21Pcmcia {
	BusDevice bdev;
} IMX21Pcmcia;

static uint32_t
pipr_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pipr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}

static uint32_t
pscr_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pscr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
per_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
per_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pbr0_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pbr0_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pbr1_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pbr1_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pbr2_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pbr2_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pbr3_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pbr3_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pbr4_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pbr4_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
por0_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
por0_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
por1_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
por1_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
por2_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
por2_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
por3_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
por3_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
por4_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
por4_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pofr0_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pofr0_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pofr1_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pofr1_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pofr2_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pofr2_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pofr3_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pofr3_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pofr4_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pofr4_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pgcr_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pgcr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}
static uint32_t
pgsr_read(void *clientData,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: register 0x%08x not implemented\n",address);
	return 0;
}

static void
pgsr_write(void *clientData,uint32_t value,uint32_t address,int rqlen)
{
	fprintf(stderr,"PCMCIA: write register 0x%08x not implemented\n",address);
}

static void
IMXPcmcia_Unmap(void *owner,uint32_t base,uint32_t mask)
{
	IOH_Delete32(PCMCIA_PIPR(base));
	IOH_Delete32(PCMCIA_PSCR(base));
	IOH_Delete32(PCMCIA_PER(base));
	IOH_Delete32(PCMCIA_PBR0(base));
	IOH_Delete32(PCMCIA_PBR1(base));
	IOH_Delete32(PCMCIA_PBR2(base));
	IOH_Delete32(PCMCIA_PBR3(base));
	IOH_Delete32(PCMCIA_PBR4(base));
	IOH_Delete32(PCMCIA_POR0(base));
	IOH_Delete32(PCMCIA_POR1(base));
	IOH_Delete32(PCMCIA_POR2(base));
	IOH_Delete32(PCMCIA_POR3(base));
	IOH_Delete32(PCMCIA_POR4(base));
	IOH_Delete32(PCMCIA_POFR0(base));
	IOH_Delete32(PCMCIA_POFR1(base));
	IOH_Delete32(PCMCIA_POFR2(base));
	IOH_Delete32(PCMCIA_POFR3(base));
	IOH_Delete32(PCMCIA_POFR4(base));
	IOH_Delete32(PCMCIA_PGCR(base));
	IOH_Delete32(PCMCIA_PGSR(base));
}

static void
IMXPcmcia_Map(void *owner,uint32_t base,uint32_t mask,uint32_t mapflags)
{
	IMX21Pcmcia *pc = (IMX21Pcmcia *) owner;
	IOH_New32(PCMCIA_PIPR(base),pipr_read,pipr_write,pc);
	IOH_New32(PCMCIA_PSCR(base),pscr_read,pscr_write,pc);
	IOH_New32(PCMCIA_PER(base),per_read,per_write,pc);
	IOH_New32(PCMCIA_PBR0(base),pbr0_read,pbr0_write,pc);
	IOH_New32(PCMCIA_PBR1(base),pbr1_read,pbr1_write,pc);
	IOH_New32(PCMCIA_PBR2(base),pbr2_read,pbr2_write,pc);
	IOH_New32(PCMCIA_PBR3(base),pbr3_read,pbr3_write,pc);
	IOH_New32(PCMCIA_PBR4(base),pbr4_read,pbr4_write,pc);
	IOH_New32(PCMCIA_POR0(base),por0_read,por0_write,pc);
	IOH_New32(PCMCIA_POR1(base),por1_read,por1_write,pc);
	IOH_New32(PCMCIA_POR2(base),por2_read,por2_write,pc);
	IOH_New32(PCMCIA_POR3(base),por3_read,por3_write,pc);
	IOH_New32(PCMCIA_POR4(base),por4_read,por4_write,pc);
	IOH_New32(PCMCIA_POFR0(base),pofr0_read,pofr0_write,pc);
	IOH_New32(PCMCIA_POFR1(base),pofr1_read,pofr1_write,pc);
	IOH_New32(PCMCIA_POFR2(base),pofr2_read,pofr2_write,pc);
	IOH_New32(PCMCIA_POFR3(base),pofr3_read,pofr3_write,pc);
	IOH_New32(PCMCIA_POFR4(base),pofr4_read,pofr4_write,pc);
	IOH_New32(PCMCIA_PGCR(base),pgcr_read,pgcr_write,pc);
	IOH_New32(PCMCIA_PGSR(base),pgsr_read,pgsr_write,pc);
}

BusDevice *
IMX21Pcmcia_New(const char *name)
{
	IMX21Pcmcia *pc = malloc(sizeof(*pc));	
	if(!pc) {
		fprintf(stderr,"No memory for i.MX21 PCMCIA controller\n");
		exit(1);
	}
	memset(pc,0,sizeof(*pc));
	pc->bdev.first_mapping=NULL;
        pc->bdev.Map=IMXPcmcia_Map;
        pc->bdev.UnMap=IMXPcmcia_Unmap;
       	pc->bdev.owner=pc;
        pc->bdev.hw_flags=MEM_FLAG_WRITABLE|MEM_FLAG_READABLE;
        return &pc->bdev;

}
