#ifndef _GDEBUG_H
#define _GDEBUG_H

typedef struct GdbServer GdbServer;

/*
 * -------------------------------------------------------
 * Every architecture which wants to use gdb for debugging 
 * has to implement the GdebugOps
 * -------------------------------------------------------
 */
typedef struct GDebugOps {
        int (*get_status)(void *clientData);        /* For gdb "?" query */
        int (*step) (void *clientData,uint32_t addr,int use_addr);
        int (*stop)(void *clientData);
        int (*cont)(void *clientData);
        int (*getreg) (void * clientData,uint8_t *val,int index,int maxlen);
        void (*setreg) (void *clientData,const uint8_t *val,int index,int len);
        int (*getmem)(void *clientData,uint8_t *data,uint64_t addr,uint32_t len);
        int (*setmem)(void *clientData,const uint8_t *data,uint64_t addr,uint32_t len);
	void (*get_bkpt_ins)(void *clientData,uint8_t *ins,uint64_t addr,int len);
} GDebugOps;
GdbServer * GdbServer_New(GDebugOps *,void *clientData);
int GdbServer_Signal(GdbServer *gserv,int sig);
#endif
