#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <instructions_avr8.h>
typedef struct AVR8_Instruction {
	uint16_t opcode;
	uint16_t mask;
	const char *name;
	AVR8_InstructionProc *iproc;
	int cycles;
} AVR8_Instruction;


AVR8_InstructionProc **avr8_iProcTab = NULL;

AVR8_Instruction instrlist[] = {
	{0x1c00,0xfc00,"avr8_adc",avr8_adc,1},
	{0x0c00,0xfc00,"avr8_add",avr8_add,1},
	{0x9600,0xff00,"avr8_adiw",avr8_adiw,2},
	{0x2000,0xfc00,"avr8_and",avr8_and,1},
	{0x7000,0xf000,"avr8_andi",avr8_andi,1},
	{0x9405,0xfe0f,"avr8_asr",avr8_asr,1},
	{0x9488,0xff8f,"avr8_bclr",avr8_bclr,1},
	{0xf800,0xfe08,"avr8_bld",avr8_bld,1},

	{0xf400,0xfc00,"avr8_brbc",avr8_brbc,1},
	{0xf000,0xfc00,"avr8_brbs",avr8_brbs,1},

//	{0xf400,0xfc07,"avr8_brcc",avr8_brcc,1}, // see brbc
//	{0xf000,0xfc07,"avr8_brcs",avr8_brcs,1}, // see brbs

	{0x9598,0xffff,"avr8_break",avr8_break,1},

//	{0xf001,0xfc07,"avr8_breq",avr8_breq,1}, // see brbs
//	{0xf400,0xfc07,"avr8_brge",avr8_brge,1}, // see brbc
//	{0xf405,0xfc07,"avr8_brhc",avr8_brhc,1}, // see brbc
//	{0xf005,0xfc07,"avr8_brhs",avr8_brhs,1}, // see brbs
//	{0xf407,0xfc07,"avr8_brid",avr8_brid,1}, // see brbc
//	{0xf007,0xfc07,"avr8_brie",avr8_brie,1}, // see brbs
//	{0xf000,0xfc07,"avr8_brlo",avr8_brlo,1}, // see brbs
//	{0xf004,0xfc07,"avr8_brlt",avr8_brlt,1},
//	{0xf002,0xfc07,"avr8_brmi",avr8_brmi,1},
//	{0xf401,0xfc07,"avr8_brne",avr8_brne,1},
//	{0xf402,0xfc07,"avr8_brpl",avr8_brpl,1},
//	{0xf400,0xfc07,"avr8_brsh",avr8_brsh,1},
//	{0xf406,0xfc07,"avr8_brtc",avr8_brtc,1},
//	{0xf006,0xfc07,"avr8_brts",avr8_brts,1},
//	{0xf403,0xfc07,"avr8_brvc",avr8_brvc,1},
//	{0xf003,0xfc07,"avr8_brvs",avr8_brvs,1},

	{0x9408,0xff8f,"avr8_bset",avr8_bset,1},
	{0xfa00,0xfe08,"avr8_bst",avr8_bst,1},
	{0x940e,0xfe0e,"avr8_call",avr8_call,1},
	{0x9800,0xff00,"avr8_cbi",avr8_cbi,1},
//	{0x9488,0xffff,"avr8_clc",avr8_clc,1}, bclr
//	{0x94d8,0xffff,"avr8_clh",avr8_clh,1}, bclr
//	{0x94f8,0xffff,"avr8_cli",avr8_cli,1}, bclr 7
//	{0x94a8,0xffff,"avr8_cln",avr8_cln,1}, bcl4
//	{0x2400,0xfc00,"avr8_clr",avr8_clr,1}, // eor
//	{0x94c8,0xffff,"avr8_cls",avr8_cls,1}, bclr
//	{0x94e8,0xffff,"avr8_clt",avr8_clt,1}, bclr
//	{0x94b8,0xffff,"avr8_clv",avr8_clv,1}, bclr
//	{0x9498,0xffff,"avr8_clz",avr8_clz,1}, bclr
	{0x9400,0xfe0f,"avr8_com",avr8_com,1},
	{0x1400,0xfc00,"avr8_cp",avr8_cp,1},
	{0x0400,0xfc00,"avr8_cpc",avr8_cpc,1},
	{0x3000,0xf000,"avr8_cpi",avr8_cpi,1},	
	{0x1000,0xfc00,"avr8_cpse",avr8_cpse,1},
	{0x940a,0xfe0f,"avr8_dec",avr8_dec,1},
	{0x9519,0xffff,"avr8_eicall",avr8_eicall,1},
	{0x9419,0xffff,"avr8_eijmp",avr8_eijmp,1},
	{0x95d8,0xffff,"avr8_elpm1",avr8_elpm1,1},
	{0x9006,0xfe0f,"avr8_elpm2",avr8_elpm2,1},
	{0x9007,0xfe0f,"avr8_elpm3",avr8_elpm3,1},
	{0x2400,0xfc00,"avr8_eor",avr8_eor,1},	
	{0x0308,0xff88,"avr8_fmul",avr8_fmul,1},
	{0x0380,0xff88,"avr8_fmuls",avr8_fmuls,1},
	{0x0388,0xff88,"avr8_fmulsu",avr8_fmulsu,1},
	{0x9509,0xffff,"avr8_icall",avr8_icall,1},	
	{0x9409,0xffff,"avr8_ijmp",avr8_ijmp,1},
	{0xb000,0xf800,"avr8_in",avr8_in,1},
	{0x9403,0xfe0f,"avr8_inc",avr8_inc,1},
	{0x940c,0xfe0e,"avr8_jmp",avr8_jmp,1},

	{0x900c,0xfe0f,"avr8_ld1",avr8_ld1,1},	
	{0x900d,0xfe0f,"avr8_ld2",avr8_ld2,1},	
	{0x900e,0xfe0f,"avr8_ld3",avr8_ld3,1},
	//{0x8008,0xfe0f,"avr8_ldy1",avr8_ldy1,2}, special case of ldy4
	{0x9009,0xfe0f,"avr8_ldy2",avr8_ldy2,2},
	{0x900a,0xfe0f,"avr8_ldy3",avr8_ldy3,2},
	{0x8008,0xd208,"avr8_ldy4",avr8_ldy4,2},
	//{0x8000,0xfe0f,"avr8_ldz1",avr8_ldz1,2}, special case of ldz4
	{0x9001,0xfe0f,"avr8_ldz2",avr8_ldz2,2},
	{0x9002,0xfe0f,"avr8_ldz3",avr8_ldz3,2},
	{0x8000,0xd208,"avr8_ldz4",avr8_ldz4,2},
	{0xe000,0xf000,"avr8_ldi",avr8_ldi,1},
	{0x9000,0xfe0f,"avr8_lds",avr8_lds,2},

	{0x95c8,0xffff,"avr8_lpm1",avr8_lpm1,3},
	{0x9004,0xfe0f,"avr8_lpm2",avr8_lpm2,3},
	{0x9005,0xfe0f,"avr8_lpm3",avr8_lpm3,3},
//	{0x0c00,0xfc00,"avr8_lsl",avr8_lsl,1}, // add rd,rd
	{0x9406,0xfe0f,"avr8_lsr",avr8_lsr,1},
	{0x2c00,0xfc00,"avr8_mov",avr8_mov,1},
	{0x0100,0xff00,"avr8_movw",avr8_movw,1},	
	{0x9c00,0xfc00,"avr8_mul",avr8_mul,2},
	{0x0200,0xff00,"avr8_muls",avr8_muls,2},
	{0x0300,0xff88,"avr8_mulsu",avr8_mulsu,2},
	{0x9401,0xfe0f,"avr8_neg",avr8_neg,1},
	{0x0000,0xffff,"avr8_nop",avr8_nop,1},
	{0x2800,0xfc00,"avr8_or",avr8_or,1},
	{0x6000,0xf000,"avr8_ori",avr8_ori,1},
	{0xb800,0xf800,"avr8_out",avr8_out,1},
	{0x900f,0xfe0f,"avr8_pop",avr8_pop,2},
	{0x920f,0xfe0f,"avr8_push",avr8_push,2},
	{0xd000,0xf000,"avr8_rcall",avr8_rcall,3},
	{0x9508,0xffff,"avr8_ret",avr8_ret,4},
	{0x9518,0xffff,"avr8_reti",avr8_reti,4},
	{0xc000,0xf000,"avr8_rjmp",avr8_rjmp,2},
//{0x1c00,0xfc00,"avr8_rol",avr8_rol,1}, // addc rd,rd
	{0x9407,0xfe0f,"avr8_ror",avr8_ror,1},
	{0x0800,0xfc00,"avr8_sbc",avr8_sbc,1},
	{0x4000,0xf000,"avr8_sbci",avr8_sbci,1},	
	{0x9a00,0xff00,"avr8_sbi",avr8_sbi,2},
	{0x9900,0xff00,"avr8_sbic",avr8_sbic,2},
	{0x9b00,0xff00,"avr8_sbis",avr8_sbis,2},
	{0x9700,0xff00,"avr8_sbiw",avr8_sbiw,2},	
//	{0x6000,0xf000,"avr8_sbr",avr8_sbr,1}, ori
	{0xfc00,0xfe08,"avr8_sbrc",avr8_sbrc,2},
	{0xfe00,0xfe08,"avr8_sbrs",avr8_sbrs,2},
//	{0x9408,0xffff,"avr8_sec",avr8_sec,1}, bset
//	{0x9458,0xffff,"avr8_seh",avr8_seh,1}, bset
//	{0x9478,0xffff,"avr8_sei",avr8_sei,1}, bset
//	{0x9428,0xffff,"avr8_sen",avr8_sen,1}, bset
//	{0xef0f,0xff0f,"avr8_ser",avr8_ser,1}, // ldi 0xff
//	{0x9448,0xffff,"avr8_ses",avr8_ses,1}, bset
//	{0x9468,0xffff,"avr8_set",avr8_set,1}, bset
//	{0x9438,0xffff,"avr8_sev",avr8_sev,1}, bset	
//	{0x9418,0xffff,"avr8_sez",avr8_sez,1}, bset
	{0x9588,0xffff,"avr8_sleep",avr8_sleep,1},
	{0x95e8,0xffff,"avr8_spm",avr8_spm,1},
	{0x920c,0xfe0f,"avr8_st1",avr8_st1,2},
	{0x920d,0xfe0f,"avr8_st2",avr8_st2,2},
	{0x920e,0xfe0f,"avr8_st3",avr8_st3,2},
	//{0x8208,0xfe0f,"avr8_sty1",avr8_sty1,1},	 // special case of sty4
	{0x9209,0xfe0f,"avr8_sty2",avr8_sty2,1},
	{0x920a,0xfe0f,"avr8_sty3",avr8_sty3,1},
	{0x8208,0xd208,"avr8_sty4",avr8_sty4,1},
	//{0x8200,0xfe0f,"avr8_stz1",avr8_stz1,1},	// special case of stz4
	{0x9201,0xfe0f,"avr8_stz2",avr8_stz2,1},
	{0x9202,0xfe0f,"avr8_stz3",avr8_stz3,1},
	{0x8200,0xd208,"avr8_stz4",avr8_stz4,1},
	{0x9200,0xfe0f,"avr8_sts",avr8_sts,1},
	{0x1800,0xfc00,"avr8_sub",avr8_sub,1},
	{0x5000,0xf000,"avr8_subi",avr8_subi,1},
	{0x9402,0xfe0f,"avr8_swap",avr8_swap,1},
//	{0x2000,0xfc00,"avr8_tst",avr8_tst,1},
	{0x95a8,0xffff,"avr8_wdr",avr8_wdr,1},
};

void
AVR8_IDecoderNew() 
{
	int icode;
	int j;
	int num_instr = sizeof(instrlist) / sizeof(AVR8_Instruction);
	avr8_iProcTab = malloc(sizeof(AVR8_InstructionProc *) * 0x10000);
	if(!avr8_iProcTab) {
		fprintf(stderr,"Out of memory for allocating AVR8 Instruction decoder\n");
		exit(1);
	}	
	memset(avr8_iProcTab,0,sizeof(AVR8_InstructionProc *) * 0x10000);
	for(icode=0;icode<65536;icode++) {
		for(j=num_instr-1;j>=0;j--) {
			AVR8_Instruction *instr = &instrlist[j];
			if((icode & instr->mask) == instr->opcode) {
				if(avr8_iProcTab[icode]) {
					fprintf(stdout,"conflict at %04x %s\n",icode,instr->name);
				} else {
					avr8_iProcTab[icode] = instr->iproc;
				}
			}
		}
		if(avr8_iProcTab[icode] == NULL) {
			avr8_iProcTab[icode] = 	avr8_undef;
		}
	}
	fprintf(stderr,"AVR8 instruction decoder with %d Instructions created\n",num_instr);
}
#ifdef TEST
int
main() {
	AVR8_IDecoderNew();
}
#endif
