/*
 * dvutils.h -- DV Utils for ffmpeg2raw
 * Copyright (C) 2003 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdint.h>

typedef struct
{
	int frequency;
	int scale;
	int wide;
	int pal;
	int twopass;
	int preview;
	double start;
	double end;
	int ppm_output;
	int audio_output;
	char *filter;
	int scaler;
	int every;
	int width;
	int height;
}
dvframes_info;

extern void dvframes_init( dvframes_info info, double multiplier );
extern int dvframes_add_video( uint8_t *data, int width, int height, int linesize );
extern int dvframes_add_audio( int16_t *samples, int count );
extern void dvframes_flush( int ignore_audio );
extern void dvframes_close( );

