/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/


#ifndef SRKTRANSMITRECORDINGDIALOG_H
#define SRKTRANSMITRECORDINGDIALOG_H

#include <libinstrudeo/isdprogresscallback.h>

#include "srktransmitrecordingdialogbase.h"

class SRKMainView;
class KProgressDialog;

class SRKTransmitRecordingDialog : public SRKTransmitRecordingDialogBase
{
  Q_OBJECT

public:
  SRKTransmitRecordingDialog(QString& fileName, SRKMainView* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  virtual ~SRKTransmitRecordingDialog();
  
public slots:

protected slots:
  virtual void editMetaInformation();
  virtual void disclaimerDisagreeToggled(bool b);
  virtual void disclaimerAgreeToggled(bool b);
  virtual void reject();
  virtual void accept();

protected:
  //-----METHODS-----
  void webserviceError(string errorString);

  //----CHILD CLASS-----
  /**
   * This class is used to monitor the progress of the ftp transmission.
   * It subclasses ISDProgressCallback, and implements
   * its procentDone() method, that is called regularly to report the procent
   * of sent data.
   */
  class SRKFtpProgressCallback : public ISDProgressCallback {
  public:
      SRKFtpProgressCallback(KProgressDialog* progressDialog);
      virtual ~SRKFtpProgressCallback();
      virtual void procentDone(float procent);
      virtual bool wasCancelled();
  protected:
      KProgressDialog* progressDialog;
  };
  
  //-----VARIABLES-----
  QString recFileName;
  SRKMainView* parent;
};

#endif

