/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcolor.h>

#include <kcolorbutton.h>

#include <libinstrudeo/isdcommentbox.h>

#include "srkcommentbox.h"
#include "srkcommentpropertiesdialog.h"

SRKCommentPropertiesDialog::SRKCommentPropertiesDialog(SRKCommentbox* comment, 
						       QWidget* parent, const char* name, bool modal, WFlags fl)
    : SRKCommentPropertiesDialogBase(parent, name, modal, fl),
      commentbox(comment)
{
    if (comment!=NULL) {
	ISDCommentbox* isdBox = comment->getISDCommentbox();
	
	//set colors
	float colors[4];
	isdBox->getColor(colors);
	opacity->setValue((int)(colors[3]*100.0));
	fillColor->setColor(QColor((int)(colors[0]*255.0), (int)(colors[1]*255.0), (int)(colors[2]*255.0)));
	isdBox->getTextColor(colors);
	textColor->setColor(QColor((int)(colors[0]*255.0), (int)(colors[1]*255.0), (int)(colors[2]*255.0)));

	//set dimensions
	int size[2];
	isdBox->getSize(size);
	width->setValue(size[0]);
	height->setValue(size[1]);
	
	//set mirrormode
	ISDCommentbox::commentboxMirrorMode mirrorMode = isdBox->getMirrorMode();
	mirrorH->setChecked(mirrorMode==ISDCommentbox::ISD_COMMENTBOX_MIRROR_HORIZONTAL ||
			    mirrorMode==ISDCommentbox::ISD_COMMENTBOX_MIRROR_BOTH);
	mirrorV->setChecked(mirrorMode==ISDCommentbox::ISD_COMMENTBOX_MIRROR_VERTICAL ||
			    mirrorMode==ISDCommentbox::ISD_COMMENTBOX_MIRROR_BOTH);
	
	//set timing
	startTime->setValue(isdBox->getStartTime());
	duration->setValue(isdBox->getDuration());
    }
}

SRKCommentPropertiesDialog::~SRKCommentPropertiesDialog()
{
}

/*$SPECIALIZATION$*/
void SRKCommentPropertiesDialog::reject()
{
    QDialog::reject();
}

void SRKCommentPropertiesDialog::accept()
{
    //save properties
    if (commentbox!=NULL) {
	ISDCommentbox* isdBox = commentbox->getISDCommentbox();
	
	//save colors
	isdBox->setColor(fillColor->color().red()/255.0,
			 fillColor->color().green()/255.0,
			 fillColor->color().blue()/255.0,
			 opacity->value()/100.0);
	//we don't use the alpha color for the text
	isdBox->setTextColor(textColor->color().red()/255.0,
			     textColor->color().green()/255.0,
			     textColor->color().blue()/255.0,
			     1.0);

	//save dimensions
	isdBox->setSize(width->value(), height->value());

	//save mirrormode
	if (mirrorH->isChecked() && mirrorV->isChecked())
	    isdBox->setMirrorMode(ISDCommentbox::ISD_COMMENTBOX_MIRROR_BOTH);
	else if (mirrorH->isChecked())
	    isdBox->setMirrorMode(ISDCommentbox::ISD_COMMENTBOX_MIRROR_HORIZONTAL);
	else if (mirrorV->isChecked())
	    isdBox->setMirrorMode(ISDCommentbox::ISD_COMMENTBOX_MIRROR_VERTICAL);
	else
	    isdBox->setMirrorMode(ISDCommentbox::ISD_COMMENTBOX_MIRROR_NONE);

	//save timing
	isdBox->setStartTime(startTime->value());
	isdBox->setDuration(duration->value());
    }

    QDialog::accept();
}

#include "srkcommentpropertiesdialog.moc"

