/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef CATEGORYCOMBOBOX_H
#define CATEGORYCOMBOBOX_H

/**
 * Combobox that is used in the SRKMetaInfoDialog class.
 * It displays the different category-options, as fetched from the 
 * Instrudeo webservice. The combobox can have child-comboboxes,
 * so that they form a linked list of category-choices.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <vector>

#include <kcombobox.h>

#include <libinstrudeo/isdwscategory.h>

class SRKCategoryComboBox : public KComboBox
{
    Q_OBJECT
    
  public:
    //----CONSTRUCTORS-----
    SRKCategoryComboBox(QWidget* parent=0, const char* name=0);
    virtual ~SRKCategoryComboBox();
    
    //-----METHODS-----
    /**
     * Returns the child combobox of  this combobox.
     *
     * @return The child combobox or NULL if none is set.
     */
    SRKCategoryComboBox* getChildBox();

    /**
     * Sets the child combobox of this combobox.
     *
     * @param child The child combobox.
     */
    void setChildBox(SRKCategoryComboBox* child);

    /**
     * Deletes all child comboboxes, recursively.
     * This objects are destroyed and set to NULL.
     */
    void deleteChildBoxes();
    
    //Use following functions instead of "insertItem" & co.

    /**
     * Adds a category to the combobox.
     * Use this instead of KComboBox::insertItem()
     *
     * @param c The new category or NULL to add an empty choice.
     */
    void addChoice(ISDWSCategory* c);

    /**
     * Removes the specified category from this combobox.
     * If the category isn't present, nothing happens.
     $ The categories are matched by ID.
     * Use this instead of KComboBox::removeItem()
     *
     * @param c The category to remove.
     */
    void removeChoice(ISDWSCategory* c);
    
    /**
     * Returns the selected category.
     * Use this instead of KComboBox::currentItem()
     *
     * @return The currently selected combobox. Can be NULL.
     */
    ISDWSCategory* getCurrentSelection();

    /**
     * Sets the current selected category.
     * If c isn't present, nothing happens.
     *
     * @param c The category to select.
     */
    void setCurrentSelection(ISDWSCategory* c);
    
  protected slots:
    void slotActivated(const QString&);
    
  signals:
    void activated(const QString&, SRKCategoryComboBox*);
    
  protected:
    SRKCategoryComboBox* childBox;
    /**
     * Note: this list must be kept synchronized with the items in the combobox.
     */
    vector<ISDWSCategory*> categoryList;
};

#endif //CATEGORY_COMBOBOX_H
