/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

extern numlist hours;

void report_day(const char *user)
{

   FILE *fp_in, *fp_ou;

   char data[20];
   char odata[20];
   char hour[20];
   char elap[20];
   char oelap[20];
   char html[8000];
   char arqout[MAXLEN];
   char wdirname[MAXLEN];
   char wuser[255];
   char c[ 24 ][20];
   int  count=0;
   int  ihour=0;
   long long int v[ 24 ] = { 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
			     0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
   long long int t[ 24 ] = { 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
			     0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
   long long int tt=0, ttt=0;
   int i;

   sprintf(arqout,"%s/%s/d%s.html",dirname,user,user);
   sprintf(wdirname,"%s/%s.day",tmp,user);

   if(access(wdirname, R_OK) != 0)
      return;

   if((fp_in=fopen(wdirname,"r"))==NULL) {
     fprintf(stderr, "SARG: (repday) %s: %s\n",text[8],wdirname);
     exit(1);
   }

   if((fp_ou=fopen(arqout,"w"))==NULL) {
     fprintf(stderr, "SARG: (repday) %s: %s\n",text[8],arqout);
     exit(1);
   }

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);
   //if(strlen(FontFace) > 0) fprintf(fp_ou,"<font face=%s>\n",FontFace);
   fprintf(fp_ou,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou, "../../../..");
   else
      show_sarg(fp_ou, "../..");

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\" colspan=\"2\">%s</th></tr>\n",Title);

   fputs("</table></div>\n",fp_ou);
   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);

   fprintf(fp_ou,"<tr><td class=\"header3\" colspan=\"2\">%s:&nbsp;%s</td></tr>\n",text[89],period);

   strcpy(wuser,user);
   if(strstr(wuser,"_") != 0)
      fixip(wuser);

   if(strcmp(Ip2Name,"yes") == 0)
      if((str=(char *) strstr(name, ".")) != (char *) NULL) {
         if((str=(char *) strstr(str+1, ".")) != (char *) NULL)
            ip2name(wuser,sizeof(wuser));
   }

   get_usertab_name(wuser,name,sizeof(name));

   if(dotinuser && strchr(name,'_')) {
      subs(name,sizeof(name),"_",".");
   }

   fprintf(fp_ou,"<tr><th class=\"header3\" colspan=\"2\">%s:&nbsp;%s</th></tr>\n",text[90],name);

   fputs("<tr><td></td></tr><tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr><tr><td></td></tr></table>\n",fp_ou);

   fputs("<table cellpadding=\"0\" cellspacing=\"2\">\n", fp_ou);

   fputs( "<tr><td></td>\n", fp_ou );

   if(strcmp(datetimeby,"bytes") == 0)
     strcpy( html, text[93] );
   else
     strcpy( html, "H:M:S" );

   for( i = 0; i < hours.len; i++ )
     fprintf( fp_ou, "<td class=\"header3\">%02dH<br>%s</td>\n", hours.list[ i ], html );
   fprintf( fp_ou,
     "<td class=\"header3\">%s<br>%s</td></tr>\n", text[107], html );

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if (getword(data,sizeof(data),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wdirname);
         exit(1);
      }
      if(!count) {
         strcpy(odata,data);
         count++;
      }

      if (getword(hour,sizeof(hour),buf,' ')<0 || getword(elap,sizeof(elap),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wdirname);
         exit(1);
      }
      elap[strlen(elap)-1]='\0';

      if(strcmp(data,odata) != 0) {
         strcpy(oelap,elap);

         for( i = 0; i < hours.len; i++ )
            sprintf(c[ hours.list[ i ] ],"%s",fixtime(v[ hours.list[ i ] ]));

         for( i = 8; i <= 17; i++ )
            if(strcmp(c[ hours.list[ i ] ],"00:00:00") == 0)
               bzero(c[ hours.list[ i ] ],12);

         fprintf(fp_ou, "<tr><td class=\"data\">%s</td>\n", odata );
         for( i = 0; i < hours.len; i++ )
            fprintf(fp_ou,"<td class=\"data\">%s</td>\n", c[ hours.list[ i ] ] );
         fprintf( fp_ou, "<td class=\"data\">%s</td>\n", fixtime(tt) );

         tt=0;
         for( i = 0; i < hours.len; i++ ) v[ hours.list[ i ] ]=0;
         strcpy(odata,data);
         strcpy(elap,oelap);
      }

      ihour=atoi(hour);

      v[ ihour ]+=my_atoll(elap);
      tt+=my_atoll(elap);
      t[ ihour ]+=my_atoll(elap);
      ttt+=my_atoll(elap);

   }

   for( i = 0; i < hours.len; i++ )
     sprintf(c[ hours.list[ i ] ],"%s",fixtime(v[ hours.list[ i ] ]));

   for( i = 0; i < hours.len; i++ )
     if(strcmp(c[ hours.list[ i ] ],"00:00:00") == 0) bzero(c[ hours.list[ i ] ],12);

   fprintf(fp_ou, "<tr><td class=\"data\">%s</td>\n", data );
   for( i = 0; i < hours.len; i++ )
     fprintf(fp_ou, "<td class=\"data\">%s</td>\n", c[ hours.list[ i ] ] );
   fprintf(fp_ou, "<td class=\"data\">%s</td></tr>\n", fixtime(tt) );

   for( i = 0; i < hours.len; i++ )
     sprintf(c[ hours.list[ i ] ],"%s",fixtime(t[ hours.list[ i ] ]));

   fprintf(fp_ou, "<tr><td class=\"header\">%s</td>\n", text[107] );
   for( i = 0; i < hours.len; i++ )
     fprintf(fp_ou, "<td class=\"header2\">%s</td>\n", c[ hours.list[ i ] ] );
   fprintf(fp_ou, "<td class=\"header2\">%s</td></tr>\n", fixtime(ttt) );

   fputs("</table></div>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);
   fclose(fp_in);
   fclose(fp_ou);
   return;
}
