/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

int vhexclude(const char *excludefile, const char *url)
{

   char whost[1024];
   char *str;
   char *wurl;
   int len;
   char *port;

   len = strlen(excludefile);
   if((str=(char *) malloc(len+1))==NULL) {
         fprintf(stderr, "SARG: %s (%d):\n",text[59], len);
         exit(1);
   }
   len = strlen(url);
   if((wurl=(char *) malloc(len+1))==NULL) {
         fprintf(stderr, "SARG: %s (%d):\n",text[59], len);
         exit(1);
   }
   whost[0]='\0';
   strcpy(str,excludefile);
   strcpy(wurl,url);
   if (getword(whost,sizeof(whost),str,' ')<0) {
      printf("SARG: Maybe you have a broken record or garbage in your exclude host file.\n");
      exit(1);
   }

   port=strchr(wurl,':');
   if(port != NULL) {
      // remove the port number at the end of the site's address
      *port='\0';
   }

   while(strcmp(whost,"*END*") != 0) {
      if(strcmp(wurl,whost) == 0) {
         free(wurl);
         free(str);
         return(0);
      }
      if(strchr(whost,'*') != 0) {
         if (getword(warea,sizeof(warea),whost,'.')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your exclude host file.\n");
            exit(1);
         }
         if (getword(warea,sizeof(warea),wurl,'.')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your exclude host file.\n");
            exit(1);
         }
         if(strcmp(wurl,whost) == 0) {
            free(wurl);
            free(str);
            return(0);
         }
      }
      if (getword(whost,sizeof(whost),str,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your exclude host file.\n");
         exit(1);
      }
   }
   free(wurl);
   free(str);
   return(1);
}


int vuexclude(const char *excludeuser, const char *user)
{
   const char *wuser;
   int len;

   len=strlen(user);
   wuser=excludeuser;
   while ((wuser=strstr(wuser,user))!=NULL) {
      if (wuser[len]==' ') return(0);
      wuser+=len;
   }

   return(1);
}
