/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_rap.h"
#include "autoconf/librpc/gen_ndr/ndr_rap_c.h"

/* rap - client functions generated by pidl */

struct dcerpc_rap_NetShareEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetShareEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetShareEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetShareEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetShareEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetShareEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSHAREENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetShareEnum_r_done, req);

	return req;
}

static void dcerpc_rap_NetShareEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetShareEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetShareEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetShareEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetShareEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetShareEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSHAREENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetShareAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetShareAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetShareAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetShareAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetShareAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetShareAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSHAREADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetShareAdd_r_done, req);

	return req;
}

static void dcerpc_rap_NetShareAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetShareAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetShareAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetShareAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetShareAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetShareAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSHAREADD, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetServerEnum2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetServerEnum2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetServerEnum2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetServerEnum2 *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetServerEnum2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetServerEnum2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSERVERENUM2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetServerEnum2_r_done, req);

	return req;
}

static void dcerpc_rap_NetServerEnum2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetServerEnum2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetServerEnum2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetServerEnum2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetServerEnum2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetServerEnum2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSERVERENUM2, mem_ctx, r);

	return status;
}

struct dcerpc_rap_WserverGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_WserverGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_WserverGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_WserverGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_WserverGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_WserverGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_WSERVERGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_WserverGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_WserverGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_WserverGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_WserverGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_WserverGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_WserverGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_WserverGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_WSERVERGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintQEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintQEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintQEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintQEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintQEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintQEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintQEnum_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintQEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintQEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintQEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintQEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintQEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintQEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintQGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintQGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintQGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintQGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintQGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintQGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintQGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintQGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintQGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintQGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintQGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintQGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintQGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobPause_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobPause_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobPause_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobPause *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobPause_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobPause_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBPAUSE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobPause_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobPause_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobPause_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobPause_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobPause_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobPause_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobPause *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBPAUSE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobContinue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobContinue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobContinue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobContinue *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobContinue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobContinue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBCONTINUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobContinue_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobContinue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobContinue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobContinue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobContinue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobContinue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobContinue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBCONTINUE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobDelete_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobDelete_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobDelete_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobDelete *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobDelete_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobDelete_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBDELETE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobDelete_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobDelete_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobDelete_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobDelete_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobDelete_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobDelete_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobDelete *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBDELETE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintQueuePause_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintQueuePause_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintQueuePause_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintQueuePause *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintQueuePause_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintQueuePause_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUEPAUSE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintQueuePause_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintQueuePause_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintQueuePause_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintQueuePause_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintQueuePause_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintQueuePause_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintQueuePause *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUEPAUSE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintQueueResume_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintQueueResume_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintQueueResume_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintQueueResume *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintQueueResume_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintQueueResume_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUERESUME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintQueueResume_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintQueueResume_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintQueueResume_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintQueueResume_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintQueueResume_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintQueueResume_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintQueueResume *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUERESUME, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintQueuePurge_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintQueuePurge_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintQueuePurge_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintQueuePurge *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintQueuePurge_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintQueuePurge_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUEPURGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintQueuePurge_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintQueuePurge_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintQueuePurge_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintQueuePurge_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintQueuePurge_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintQueuePurge_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintQueuePurge *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTQUEUEPURGE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobEnum_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintJobSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintJobSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintJobSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintJobSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintJobSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintJobSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintJobSetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintJobSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintJobSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintJobSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintJobSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintJobSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintJobSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTJOBSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintDestEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintDestEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintDestEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintDestEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintDestEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintDestEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTDESTENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintDestEnum_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintDestEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintDestEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintDestEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintDestEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintDestEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintDestEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTDESTENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetPrintDestGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetPrintDestGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetPrintDestGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetPrintDestGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetPrintDestGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetPrintDestGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTDESTGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetPrintDestGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetPrintDestGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetPrintDestGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetPrintDestGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetPrintDestGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetPrintDestGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetPrintDestGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETPRINTDESTGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetUserPasswordSet2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetUserPasswordSet2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetUserPasswordSet2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetUserPasswordSet2 *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetUserPasswordSet2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetUserPasswordSet2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERPASSWORDSET2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetUserPasswordSet2_r_done, req);

	return req;
}

static void dcerpc_rap_NetUserPasswordSet2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetUserPasswordSet2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetUserPasswordSet2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetUserPasswordSet2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetUserPasswordSet2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetUserPasswordSet2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERPASSWORDSET2, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetOEMChangePassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetOEMChangePassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetOEMChangePassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetOEMChangePassword *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetOEMChangePassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetOEMChangePassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETOEMCHANGEPASSWORD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetOEMChangePassword_r_done, req);

	return req;
}

static void dcerpc_rap_NetOEMChangePassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetOEMChangePassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetOEMChangePassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetOEMChangePassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetOEMChangePassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetOEMChangePassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETOEMCHANGEPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetUserGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetUserGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetUserGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetUserGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetUserGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetUserGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetUserGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetUserGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetUserGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetUserGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetUserGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetUserGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetUserGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetSessionEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetSessionEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetSessionEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetSessionEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetSessionEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetSessionEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSESSIONENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetSessionEnum_r_done, req);

	return req;
}

static void dcerpc_rap_NetSessionEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetSessionEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetSessionEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetSessionEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetSessionEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetSessionEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSESSIONENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetSessionGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetSessionGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetSessionGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetSessionGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetSessionGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetSessionGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSESSIONGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetSessionGetInfo_r_done, req);

	return req;
}

static void dcerpc_rap_NetSessionGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetSessionGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetSessionGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetSessionGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetSessionGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetSessionGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETSESSIONGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetUserAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetUserAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetUserAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetUserAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetUserAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetUserAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetUserAdd_r_done, req);

	return req;
}

static void dcerpc_rap_NetUserAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetUserAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetUserAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetUserAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetUserAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetUserAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERADD, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetUserDelete_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetUserDelete_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetUserDelete_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetUserDelete *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetUserDelete_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetUserDelete_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERDELETE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetUserDelete_r_done, req);

	return req;
}

static void dcerpc_rap_NetUserDelete_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetUserDelete_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetUserDelete_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetUserDelete_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetUserDelete_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetUserDelete *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETUSERDELETE, mem_ctx, r);

	return status;
}

struct dcerpc_rap_NetRemoteTOD_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rap_NetRemoteTOD_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rap_NetRemoteTOD_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rap_NetRemoteTOD *r)
{
	struct tevent_req *req;
	struct dcerpc_rap_NetRemoteTOD_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rap_NetRemoteTOD_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETREMOTETOD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rap_NetRemoteTOD_r_done, req);

	return req;
}

static void dcerpc_rap_NetRemoteTOD_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rap_NetRemoteTOD_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rap_NetRemoteTOD_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rap_NetRemoteTOD_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rap_NetRemoteTOD_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rap_NetRemoteTOD *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rap,
			NDR_RAP_NETREMOTETOD, mem_ctx, r);

	return status;
}

