/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_eventlog6.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_eventlog6_RpcInfo(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_RpcInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sub_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sub_err_param));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_RpcInfo(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_RpcInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sub_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sub_err_param));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_RpcInfo(struct ndr_print *ndr, const char *name, const struct eventlog6_RpcInfo *r)
{
	ndr_print_struct(ndr, name, "eventlog6_RpcInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "error", r->error);
	ndr_print_uint32(ndr, "sub_err", r->sub_err);
	ndr_print_uint32(ndr, "sub_err_param", r->sub_err_param);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_boolean8Array(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_boolean8Array *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_boolean8Array(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_boolean8Array *r)
{
	uint32_t _ptr_ptr;
	uint32_t size_ptr_1 = 0;
	TALLOC_CTX *_mem_save_ptr_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_BOOLEAN8_ARRAY_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
		if (_ptr_ptr) {
			NDR_PULL_ALLOC(ndr, r->ptr);
		} else {
			r->ptr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			_mem_save_ptr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr));
			size_ptr_1 = ndr_get_array_size(ndr, &r->ptr);
			NDR_PULL_ALLOC_N(ndr, r->ptr, size_ptr_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->ptr, size_ptr_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_0, 0);
		}
		if (r->ptr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_boolean8Array(struct ndr_print *ndr, const char *name, const struct eventlog6_boolean8Array *r)
{
	ndr_print_struct(ndr, name, "eventlog6_boolean8Array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ptr", r->ptr);
	ndr->depth++;
	if (r->ptr) {
		ndr_print_array_uint8(ndr, "ptr", r->ptr, r->count);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_UInt32Array(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_UInt32Array *r)
{
	uint32_t cntr_ptr_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_ptr_1 = 0; cntr_ptr_1 < r->count; cntr_ptr_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ptr[cntr_ptr_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_UInt32Array(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_UInt32Array *r)
{
	uint32_t _ptr_ptr;
	uint32_t size_ptr_1 = 0;
	uint32_t cntr_ptr_1;
	TALLOC_CTX *_mem_save_ptr_0;
	TALLOC_CTX *_mem_save_ptr_1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_UINT32_ARRAY_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
		if (_ptr_ptr) {
			NDR_PULL_ALLOC(ndr, r->ptr);
		} else {
			r->ptr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			_mem_save_ptr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr));
			size_ptr_1 = ndr_get_array_size(ndr, &r->ptr);
			NDR_PULL_ALLOC_N(ndr, r->ptr, size_ptr_1);
			_mem_save_ptr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			for (cntr_ptr_1 = 0; cntr_ptr_1 < size_ptr_1; cntr_ptr_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ptr[cntr_ptr_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_0, 0);
		}
		if (r->ptr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_UInt32Array(struct ndr_print *ndr, const char *name, const struct eventlog6_UInt32Array *r)
{
	uint32_t cntr_ptr_1;
	ndr_print_struct(ndr, name, "eventlog6_UInt32Array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ptr", r->ptr);
	ndr->depth++;
	if (r->ptr) {
		ndr->print(ndr, "%s: ARRAY(%d)", "ptr", (int)r->count);
		ndr->depth++;
		for (cntr_ptr_1=0;cntr_ptr_1<r->count;cntr_ptr_1++) {
			ndr_print_uint32(ndr, "ptr", r->ptr[cntr_ptr_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_UInt64Array(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_UInt64Array *r)
{
	uint32_t cntr_ptr_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_ptr_1 = 0; cntr_ptr_1 < r->count; cntr_ptr_1++) {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->ptr[cntr_ptr_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_UInt64Array(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_UInt64Array *r)
{
	uint32_t _ptr_ptr;
	uint32_t size_ptr_1 = 0;
	uint32_t cntr_ptr_1;
	TALLOC_CTX *_mem_save_ptr_0;
	TALLOC_CTX *_mem_save_ptr_1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_UINT64_ARRAY_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
		if (_ptr_ptr) {
			NDR_PULL_ALLOC(ndr, r->ptr);
		} else {
			r->ptr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			_mem_save_ptr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr));
			size_ptr_1 = ndr_get_array_size(ndr, &r->ptr);
			NDR_PULL_ALLOC_N(ndr, r->ptr, size_ptr_1);
			_mem_save_ptr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			for (cntr_ptr_1 = 0; cntr_ptr_1 < size_ptr_1; cntr_ptr_1++) {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->ptr[cntr_ptr_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_0, 0);
		}
		if (r->ptr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_UInt64Array(struct ndr_print *ndr, const char *name, const struct eventlog6_UInt64Array *r)
{
	uint32_t cntr_ptr_1;
	ndr_print_struct(ndr, name, "eventlog6_UInt64Array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ptr", r->ptr);
	ndr->depth++;
	if (r->ptr) {
		ndr->print(ndr, "%s: ARRAY(%d)", "ptr", (int)r->count);
		ndr->depth++;
		for (cntr_ptr_1=0;cntr_ptr_1<r->count;cntr_ptr_1++) {
			ndr_print_hyper(ndr, "ptr", r->ptr[cntr_ptr_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_StringArray(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_StringArray *r)
{
	uint32_t cntr_ptr_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_ptr_1 = 0; cntr_ptr_1 < r->count; cntr_ptr_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr[cntr_ptr_1]));
			}
			for (cntr_ptr_1 = 0; cntr_ptr_1 < r->count; cntr_ptr_1++) {
				if (r->ptr[cntr_ptr_1]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ptr[cntr_ptr_1], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ptr[cntr_ptr_1], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ptr[cntr_ptr_1], ndr_charset_length(r->ptr[cntr_ptr_1], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_StringArray(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_StringArray *r)
{
	uint32_t _ptr_ptr;
	uint32_t size_ptr_1 = 0;
	uint32_t cntr_ptr_1;
	uint32_t size_ptr_3 = 0;
	uint32_t length_ptr_3 = 0;
	TALLOC_CTX *_mem_save_ptr_0;
	TALLOC_CTX *_mem_save_ptr_1;
	TALLOC_CTX *_mem_save_ptr_2;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_STRING_ARRAY_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
		if (_ptr_ptr) {
			NDR_PULL_ALLOC(ndr, r->ptr);
		} else {
			r->ptr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			_mem_save_ptr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr));
			size_ptr_1 = ndr_get_array_size(ndr, &r->ptr);
			NDR_PULL_ALLOC_N(ndr, r->ptr, size_ptr_1);
			_mem_save_ptr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			for (cntr_ptr_1 = 0; cntr_ptr_1 < size_ptr_1; cntr_ptr_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
				if (_ptr_ptr) {
					NDR_PULL_ALLOC(ndr, r->ptr[cntr_ptr_1]);
				} else {
					r->ptr[cntr_ptr_1] = NULL;
				}
			}
			for (cntr_ptr_1 = 0; cntr_ptr_1 < size_ptr_1; cntr_ptr_1++) {
				if (r->ptr[cntr_ptr_1]) {
					_mem_save_ptr_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ptr[cntr_ptr_1], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr[cntr_ptr_1]));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->ptr[cntr_ptr_1]));
					size_ptr_3 = ndr_get_array_size(ndr, &r->ptr[cntr_ptr_1]);
					length_ptr_3 = ndr_get_array_length(ndr, &r->ptr[cntr_ptr_1]);
					if (length_ptr_3 > size_ptr_3) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_ptr_3, length_ptr_3);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_ptr_3, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ptr[cntr_ptr_1], length_ptr_3, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_0, 0);
		}
		if (r->ptr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_StringArray(struct ndr_print *ndr, const char *name, const struct eventlog6_StringArray *r)
{
	uint32_t cntr_ptr_1;
	ndr_print_struct(ndr, name, "eventlog6_StringArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ptr", r->ptr);
	ndr->depth++;
	if (r->ptr) {
		ndr->print(ndr, "%s: ARRAY(%d)", "ptr", (int)r->count);
		ndr->depth++;
		for (cntr_ptr_1=0;cntr_ptr_1<r->count;cntr_ptr_1++) {
			ndr_print_ptr(ndr, "ptr", r->ptr[cntr_ptr_1]);
			ndr->depth++;
			if (r->ptr[cntr_ptr_1]) {
				ndr_print_string(ndr, "ptr", r->ptr[cntr_ptr_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_GuidArray(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_GuidArray *r)
{
	uint32_t cntr_ptr_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ptr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_ptr_1 = 0; cntr_ptr_1 < r->count; cntr_ptr_1++) {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->ptr[cntr_ptr_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_GuidArray(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_GuidArray *r)
{
	uint32_t _ptr_ptr;
	uint32_t size_ptr_1 = 0;
	uint32_t cntr_ptr_1;
	TALLOC_CTX *_mem_save_ptr_0;
	TALLOC_CTX *_mem_save_ptr_1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_GUID_ARRAY_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ptr));
		if (_ptr_ptr) {
			NDR_PULL_ALLOC(ndr, r->ptr);
		} else {
			r->ptr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ptr) {
			_mem_save_ptr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ptr));
			size_ptr_1 = ndr_get_array_size(ndr, &r->ptr);
			NDR_PULL_ALLOC_N(ndr, r->ptr, size_ptr_1);
			_mem_save_ptr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ptr, 0);
			for (cntr_ptr_1 = 0; cntr_ptr_1 < size_ptr_1; cntr_ptr_1++) {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->ptr[cntr_ptr_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ptr_0, 0);
		}
		if (r->ptr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ptr, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_GuidArray(struct ndr_print *ndr, const char *name, const struct eventlog6_GuidArray *r)
{
	uint32_t cntr_ptr_1;
	ndr_print_struct(ndr, name, "eventlog6_GuidArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ptr", r->ptr);
	ndr->depth++;
	if (r->ptr) {
		ndr->print(ndr, "%s: ARRAY(%d)", "ptr", (int)r->count);
		ndr->depth++;
		for (cntr_ptr_1=0;cntr_ptr_1<r->count;cntr_ptr_1++) {
			ndr_print_GUID(ndr, "ptr", &r->ptr[cntr_ptr_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcVariantType(struct ndr_push *ndr, int ndr_flags, enum eventlog6_EvtRpcVariantType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcVariantType(struct ndr_pull *ndr, int ndr_flags, enum eventlog6_EvtRpcVariantType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcVariantType(struct ndr_print *ndr, const char *name, enum eventlog6_EvtRpcVariantType r)
{
	const char *val = NULL;

	switch (r) {
		case EvtRpcVarTypeNull: val = "EvtRpcVarTypeNull"; break;
		case EvtRpcVarTypeboolean8: val = "EvtRpcVarTypeboolean8"; break;
		case EvtRpcVarTypeUInt32: val = "EvtRpcVarTypeUInt32"; break;
		case EvtRpcVarTypeUInt64: val = "EvtRpcVarTypeUInt64"; break;
		case EvtRpcVarTypeString: val = "EvtRpcVarTypeString"; break;
		case EvtRpcVarTypeGuid: val = "EvtRpcVarTypeGuid"; break;
		case EvtRpcVarTypeboolean8Array: val = "EvtRpcVarTypeboolean8Array"; break;
		case EvtRpcVarTypeUInt32Array: val = "EvtRpcVarTypeUInt32Array"; break;
		case EvtRpcVarTypeUInt64Array: val = "EvtRpcVarTypeUInt64Array"; break;
		case EvtRpcVarTypeStringArray: val = "EvtRpcVarTypeStringArray"; break;
		case EvtRpcVarTypeGuidArray: val = "EvtRpcVarTypeGuidArray"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcVariantUnion(struct ndr_push *ndr, int ndr_flags, const union eventlog6_EvtRpcVariantUnion *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantType(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case EvtRpcVarTypeNull: {
				NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->nullVal));
			break; }

			case EvtRpcVarTypeboolean8: {
				NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->boolean8Val));
			break; }

			case EvtRpcVarTypeUInt32: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->uint32Val));
			break; }

			case EvtRpcVarTypeUInt64: {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->uint64Val));
			break; }

			case EvtRpcVarTypeString: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->stringVal));
			break; }

			case EvtRpcVarTypeGuid: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->guidVal));
			break; }

			case EvtRpcVarTypeboolean8Array: {
				NDR_CHECK(ndr_push_eventlog6_boolean8Array(ndr, NDR_SCALARS, &r->boolean8Array));
			break; }

			case EvtRpcVarTypeUInt32Array: {
				NDR_CHECK(ndr_push_eventlog6_UInt32Array(ndr, NDR_SCALARS, &r->uint32Array));
			break; }

			case EvtRpcVarTypeUInt64Array: {
				NDR_CHECK(ndr_push_eventlog6_UInt64Array(ndr, NDR_SCALARS, &r->uint64Array));
			break; }

			case EvtRpcVarTypeStringArray: {
				NDR_CHECK(ndr_push_eventlog6_StringArray(ndr, NDR_SCALARS, &r->stringArray));
			break; }

			case EvtRpcVarTypeGuidArray: {
				NDR_CHECK(ndr_push_eventlog6_GuidArray(ndr, NDR_SCALARS, &r->guidArray));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case EvtRpcVarTypeNull:
			break;

			case EvtRpcVarTypeboolean8:
			break;

			case EvtRpcVarTypeUInt32:
			break;

			case EvtRpcVarTypeUInt64:
			break;

			case EvtRpcVarTypeString:
				if (r->stringVal) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stringVal, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->stringVal, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->stringVal, ndr_charset_length(r->stringVal, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case EvtRpcVarTypeGuid:
				if (r->guidVal) {
					NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->guidVal));
				}
			break;

			case EvtRpcVarTypeboolean8Array:
				NDR_CHECK(ndr_push_eventlog6_boolean8Array(ndr, NDR_BUFFERS, &r->boolean8Array));
			break;

			case EvtRpcVarTypeUInt32Array:
				NDR_CHECK(ndr_push_eventlog6_UInt32Array(ndr, NDR_BUFFERS, &r->uint32Array));
			break;

			case EvtRpcVarTypeUInt64Array:
				NDR_CHECK(ndr_push_eventlog6_UInt64Array(ndr, NDR_BUFFERS, &r->uint64Array));
			break;

			case EvtRpcVarTypeStringArray:
				NDR_CHECK(ndr_push_eventlog6_StringArray(ndr, NDR_BUFFERS, &r->stringArray));
			break;

			case EvtRpcVarTypeGuidArray:
				NDR_CHECK(ndr_push_eventlog6_GuidArray(ndr, NDR_BUFFERS, &r->guidArray));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcVariantUnion(struct ndr_pull *ndr, int ndr_flags, union eventlog6_EvtRpcVariantUnion *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_stringVal_0;
	uint32_t _ptr_stringVal;
	uint32_t size_stringVal_1 = 0;
	uint32_t length_stringVal_1 = 0;
	TALLOC_CTX *_mem_save_guidVal_0;
	uint32_t _ptr_guidVal;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case EvtRpcVarTypeNull: {
				NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->nullVal));
			break; }

			case EvtRpcVarTypeboolean8: {
				NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->boolean8Val));
			break; }

			case EvtRpcVarTypeUInt32: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uint32Val));
			break; }

			case EvtRpcVarTypeUInt64: {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->uint64Val));
			break; }

			case EvtRpcVarTypeString: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stringVal));
				if (_ptr_stringVal) {
					NDR_PULL_ALLOC(ndr, r->stringVal);
				} else {
					r->stringVal = NULL;
				}
			break; }

			case EvtRpcVarTypeGuid: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_guidVal));
				if (_ptr_guidVal) {
					NDR_PULL_ALLOC(ndr, r->guidVal);
				} else {
					r->guidVal = NULL;
				}
			break; }

			case EvtRpcVarTypeboolean8Array: {
				NDR_CHECK(ndr_pull_eventlog6_boolean8Array(ndr, NDR_SCALARS, &r->boolean8Array));
			break; }

			case EvtRpcVarTypeUInt32Array: {
				NDR_CHECK(ndr_pull_eventlog6_UInt32Array(ndr, NDR_SCALARS, &r->uint32Array));
			break; }

			case EvtRpcVarTypeUInt64Array: {
				NDR_CHECK(ndr_pull_eventlog6_UInt64Array(ndr, NDR_SCALARS, &r->uint64Array));
			break; }

			case EvtRpcVarTypeStringArray: {
				NDR_CHECK(ndr_pull_eventlog6_StringArray(ndr, NDR_SCALARS, &r->stringArray));
			break; }

			case EvtRpcVarTypeGuidArray: {
				NDR_CHECK(ndr_pull_eventlog6_GuidArray(ndr, NDR_SCALARS, &r->guidArray));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case EvtRpcVarTypeNull:
			break;

			case EvtRpcVarTypeboolean8:
			break;

			case EvtRpcVarTypeUInt32:
			break;

			case EvtRpcVarTypeUInt64:
			break;

			case EvtRpcVarTypeString:
				if (r->stringVal) {
					_mem_save_stringVal_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->stringVal, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->stringVal));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->stringVal));
					size_stringVal_1 = ndr_get_array_size(ndr, &r->stringVal);
					length_stringVal_1 = ndr_get_array_length(ndr, &r->stringVal);
					if (length_stringVal_1 > size_stringVal_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_stringVal_1, length_stringVal_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_stringVal_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->stringVal, length_stringVal_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stringVal_0, 0);
				}
			break;

			case EvtRpcVarTypeGuid:
				if (r->guidVal) {
					_mem_save_guidVal_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->guidVal, 0);
					NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->guidVal));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guidVal_0, 0);
				}
			break;

			case EvtRpcVarTypeboolean8Array:
				NDR_CHECK(ndr_pull_eventlog6_boolean8Array(ndr, NDR_BUFFERS, &r->boolean8Array));
			break;

			case EvtRpcVarTypeUInt32Array:
				NDR_CHECK(ndr_pull_eventlog6_UInt32Array(ndr, NDR_BUFFERS, &r->uint32Array));
			break;

			case EvtRpcVarTypeUInt64Array:
				NDR_CHECK(ndr_pull_eventlog6_UInt64Array(ndr, NDR_BUFFERS, &r->uint64Array));
			break;

			case EvtRpcVarTypeStringArray:
				NDR_CHECK(ndr_pull_eventlog6_StringArray(ndr, NDR_BUFFERS, &r->stringArray));
			break;

			case EvtRpcVarTypeGuidArray:
				NDR_CHECK(ndr_pull_eventlog6_GuidArray(ndr, NDR_BUFFERS, &r->guidArray));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcVariantUnion(struct ndr_print *ndr, const char *name, const union eventlog6_EvtRpcVariantUnion *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "eventlog6_EvtRpcVariantUnion");
	switch (level) {
		case EvtRpcVarTypeNull:
			ndr_print_int32(ndr, "nullVal", r->nullVal);
		break;

		case EvtRpcVarTypeboolean8:
			ndr_print_uint8(ndr, "boolean8Val", r->boolean8Val);
		break;

		case EvtRpcVarTypeUInt32:
			ndr_print_uint32(ndr, "uint32Val", r->uint32Val);
		break;

		case EvtRpcVarTypeUInt64:
			ndr_print_hyper(ndr, "uint64Val", r->uint64Val);
		break;

		case EvtRpcVarTypeString:
			ndr_print_ptr(ndr, "stringVal", r->stringVal);
			ndr->depth++;
			if (r->stringVal) {
				ndr_print_string(ndr, "stringVal", r->stringVal);
			}
			ndr->depth--;
		break;

		case EvtRpcVarTypeGuid:
			ndr_print_ptr(ndr, "guidVal", r->guidVal);
			ndr->depth++;
			if (r->guidVal) {
				ndr_print_GUID(ndr, "guidVal", r->guidVal);
			}
			ndr->depth--;
		break;

		case EvtRpcVarTypeboolean8Array:
			ndr_print_eventlog6_boolean8Array(ndr, "boolean8Array", &r->boolean8Array);
		break;

		case EvtRpcVarTypeUInt32Array:
			ndr_print_eventlog6_UInt32Array(ndr, "uint32Array", &r->uint32Array);
		break;

		case EvtRpcVarTypeUInt64Array:
			ndr_print_eventlog6_UInt64Array(ndr, "uint64Array", &r->uint64Array);
		break;

		case EvtRpcVarTypeStringArray:
			ndr_print_eventlog6_StringArray(ndr, "stringArray", &r->stringArray);
		break;

		case EvtRpcVarTypeGuidArray:
			ndr_print_eventlog6_GuidArray(ndr, "guidArray", &r->guidArray);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcVariant(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_EvtRpcVariant *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		if (r->var == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->var, r->type));
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantUnion(ndr, NDR_SCALARS|NDR_BUFFERS, r->var));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcVariant(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_EvtRpcVariant *r)
{
	uint32_t _ptr_var;
	TALLOC_CTX *_mem_save_var_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_var));
		if (_ptr_var) {
			NDR_PULL_ALLOC(ndr, r->var);
		} else {
			r->var = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_var_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->var, 0);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->var, r->type));
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantUnion(ndr, NDR_SCALARS|NDR_BUFFERS, r->var));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_var_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcVariant(struct ndr_print *ndr, const char *name, const struct eventlog6_EvtRpcVariant *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcVariant");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_eventlog6_EvtRpcVariantType(ndr, "type", r->type);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "var", r->var);
	ndr->depth++;
	ndr_print_set_switch_value(ndr, r->var, r->type);
	ndr_print_eventlog6_EvtRpcVariantUnion(ndr, "var", r->var);
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcVariantList(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_EvtRpcVariantList *r)
{
	uint32_t cntr_props_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->props));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->props) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_props_1 = 0; cntr_props_1 < r->count; cntr_props_1++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcVariant(ndr, NDR_SCALARS, &r->props[cntr_props_1]));
			}
			for (cntr_props_1 = 0; cntr_props_1 < r->count; cntr_props_1++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcVariant(ndr, NDR_BUFFERS, &r->props[cntr_props_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcVariantList(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_EvtRpcVariantList *r)
{
	uint32_t _ptr_props;
	uint32_t size_props_1 = 0;
	uint32_t cntr_props_1;
	TALLOC_CTX *_mem_save_props_0;
	TALLOC_CTX *_mem_save_props_1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > MAX_RPC_VARIANT_LIST_COUNT) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_props));
		if (_ptr_props) {
			NDR_PULL_ALLOC(ndr, r->props);
		} else {
			r->props = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->props) {
			_mem_save_props_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->props, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->props));
			size_props_1 = ndr_get_array_size(ndr, &r->props);
			NDR_PULL_ALLOC_N(ndr, r->props, size_props_1);
			_mem_save_props_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->props, 0);
			for (cntr_props_1 = 0; cntr_props_1 < size_props_1; cntr_props_1++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariant(ndr, NDR_SCALARS, &r->props[cntr_props_1]));
			}
			for (cntr_props_1 = 0; cntr_props_1 < size_props_1; cntr_props_1++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariant(ndr, NDR_BUFFERS, &r->props[cntr_props_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_props_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_props_0, 0);
		}
		if (r->props) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->props, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcVariantList(struct ndr_print *ndr, const char *name, const struct eventlog6_EvtRpcVariantList *r)
{
	uint32_t cntr_props_1;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcVariantList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "props", r->props);
	ndr->depth++;
	if (r->props) {
		ndr->print(ndr, "%s: ARRAY(%d)", "props", (int)r->count);
		ndr->depth++;
		for (cntr_props_1=0;cntr_props_1<r->count;cntr_props_1++) {
			ndr_print_eventlog6_EvtRpcVariant(ndr, "props", &r->props[cntr_props_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcQueryChannelInfo(struct ndr_push *ndr, int ndr_flags, const struct eventlog6_EvtRpcQueryChannelInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcQueryChannelInfo(struct ndr_pull *ndr, int ndr_flags, struct eventlog6_EvtRpcQueryChannelInfo *r)
{
	uint32_t _ptr_name;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_name_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			size_name_1 = ndr_get_array_size(ndr, &r->name);
			length_name_1 = ndr_get_array_length(ndr, &r->name);
			if (length_name_1 > size_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_1, length_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcQueryChannelInfo(struct ndr_print *ndr, const char *name, const struct eventlog6_EvtRpcQueryChannelInfo *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcQueryChannelInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "status", r->status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRegisterRemoteSubscription(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	uint32_t cntr_queryChannelInfo_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.channelPath));
		if (r->in.channelPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channelPath, ndr_charset_length(r->in.channelPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.query, ndr_charset_length(r->in.query, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bookmarkXml));
		if (r->in.bookmarkXml) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.bookmarkXml, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.bookmarkXml, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.bookmarkXml, ndr_charset_length(r->in.bookmarkXml, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		if (r->out.control == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.control));
		if (r->out.queryChannelInfoSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.queryChannelInfoSize));
		if (r->out.queryChannelInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.queryChannelInfo));
		if (*r->out.queryChannelInfo) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.queryChannelInfoSize));
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < *r->out.queryChannelInfoSize; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_SCALARS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < *r->out.queryChannelInfoSize; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_BUFFERS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
		}
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRegisterRemoteSubscription(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	uint32_t _ptr_channelPath;
	uint32_t size_channelPath_1 = 0;
	uint32_t length_channelPath_1 = 0;
	uint32_t size_query_1 = 0;
	uint32_t length_query_1 = 0;
	uint32_t _ptr_bookmarkXml;
	uint32_t size_bookmarkXml_1 = 0;
	uint32_t length_bookmarkXml_1 = 0;
	uint32_t _ptr_queryChannelInfo;
	uint32_t size_queryChannelInfo_2 = 0;
	uint32_t cntr_queryChannelInfo_2;
	TALLOC_CTX *_mem_save_channelPath_0;
	TALLOC_CTX *_mem_save_bookmarkXml_0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_control_0;
	TALLOC_CTX *_mem_save_queryChannelInfoSize_0;
	TALLOC_CTX *_mem_save_queryChannelInfo_0;
	TALLOC_CTX *_mem_save_queryChannelInfo_1;
	TALLOC_CTX *_mem_save_queryChannelInfo_2;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_channelPath));
		if (_ptr_channelPath) {
			NDR_PULL_ALLOC(ndr, r->in.channelPath);
		} else {
			r->in.channelPath = NULL;
		}
		if (r->in.channelPath) {
			_mem_save_channelPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.channelPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channelPath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channelPath));
			size_channelPath_1 = ndr_get_array_size(ndr, &r->in.channelPath);
			if (size_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_channelPath_1 = ndr_get_array_length(ndr, &r->in.channelPath);
			if (length_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_channelPath_1 > size_channelPath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPath_1, length_channelPath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channelPath, length_channelPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPath_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.query));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.query));
		size_query_1 = ndr_get_array_size(ndr, &r->in.query);
		if (size_query_1 < 1 || size_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_query_1 = ndr_get_array_length(ndr, &r->in.query);
		if (length_query_1 < 1 || length_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_query_1 > size_query_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_query_1, length_query_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_query_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.query, length_query_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bookmarkXml));
		if (_ptr_bookmarkXml) {
			NDR_PULL_ALLOC(ndr, r->in.bookmarkXml);
		} else {
			r->in.bookmarkXml = NULL;
		}
		if (r->in.bookmarkXml) {
			_mem_save_bookmarkXml_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bookmarkXml, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.bookmarkXml));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.bookmarkXml));
			size_bookmarkXml_1 = ndr_get_array_size(ndr, &r->in.bookmarkXml);
			if (size_bookmarkXml_1 > MAX_RPC_BOOKMARK_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_bookmarkXml_1 = ndr_get_array_length(ndr, &r->in.bookmarkXml);
			if (length_bookmarkXml_1 > MAX_RPC_BOOKMARK_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_bookmarkXml_1 > size_bookmarkXml_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_bookmarkXml_1, length_bookmarkXml_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_bookmarkXml_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.bookmarkXml, length_bookmarkXml_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bookmarkXml_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
		NDR_PULL_ALLOC(ndr, r->out.control);
		ZERO_STRUCTP(r->out.control);
		NDR_PULL_ALLOC(ndr, r->out.queryChannelInfoSize);
		ZERO_STRUCTP(r->out.queryChannelInfoSize);
		NDR_PULL_ALLOC(ndr, r->out.queryChannelInfo);
		ZERO_STRUCTP(r->out.queryChannelInfo);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.control);
		}
		_mem_save_control_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.control, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.control));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_control_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.queryChannelInfoSize);
		}
		_mem_save_queryChannelInfoSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.queryChannelInfoSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.queryChannelInfoSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfoSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.queryChannelInfo);
		}
		_mem_save_queryChannelInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.queryChannelInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_queryChannelInfo));
		if (_ptr_queryChannelInfo) {
			NDR_PULL_ALLOC(ndr, *r->out.queryChannelInfo);
		} else {
			*r->out.queryChannelInfo = NULL;
		}
		if (*r->out.queryChannelInfo) {
			_mem_save_queryChannelInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.queryChannelInfo, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.queryChannelInfo));
			size_queryChannelInfo_2 = ndr_get_array_size(ndr, r->out.queryChannelInfo);
			if (size_queryChannelInfo_2 > MAX_RPC_QUERY_CHANNEL_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.queryChannelInfo, size_queryChannelInfo_2);
			_mem_save_queryChannelInfo_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.queryChannelInfo, 0);
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < size_queryChannelInfo_2; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_SCALARS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < size_queryChannelInfo_2; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_BUFFERS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.queryChannelInfo) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.queryChannelInfo, *r->out.queryChannelInfoSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRegisterRemoteSubscription(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	uint32_t cntr_queryChannelInfo_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRegisterRemoteSubscription");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRegisterRemoteSubscription");
		ndr->depth++;
		ndr_print_ptr(ndr, "channelPath", r->in.channelPath);
		ndr->depth++;
		if (r->in.channelPath) {
			ndr_print_string(ndr, "channelPath", r->in.channelPath);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "query", r->in.query);
		ndr->depth++;
		ndr_print_string(ndr, "query", r->in.query);
		ndr->depth--;
		ndr_print_ptr(ndr, "bookmarkXml", r->in.bookmarkXml);
		ndr->depth++;
		if (r->in.bookmarkXml) {
			ndr_print_string(ndr, "bookmarkXml", r->in.bookmarkXml);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRegisterRemoteSubscription");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "control", r->out.control);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "control", r->out.control);
		ndr->depth--;
		ndr_print_ptr(ndr, "queryChannelInfoSize", r->out.queryChannelInfoSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "queryChannelInfoSize", *r->out.queryChannelInfoSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "queryChannelInfo", r->out.queryChannelInfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "queryChannelInfo", *r->out.queryChannelInfo);
		ndr->depth++;
		if (*r->out.queryChannelInfo) {
			ndr->print(ndr, "%s: ARRAY(%d)", "queryChannelInfo", (int)*r->out.queryChannelInfoSize);
			ndr->depth++;
			for (cntr_queryChannelInfo_2=0;cntr_queryChannelInfo_2<*r->out.queryChannelInfoSize;cntr_queryChannelInfo_2++) {
				ndr_print_eventlog6_EvtRpcQueryChannelInfo(ndr, "queryChannelInfo", &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRemoteSubscriptionNextAsync(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.numRequestedRecords));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numActualRecords == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numActualRecords));
		if (r->out.eventDataIndices == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataIndices));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < *r->out.numActualRecords; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
		}
		if (r->out.eventDataSizes == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataSizes));
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < *r->out.numActualRecords; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
		}
		if (r->out.resultBufferSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resultBufferSize));
		if (r->out.resultBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.resultBuffer));
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.resultBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, *r->out.resultBufferSize));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRemoteSubscriptionNextAsync(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	uint32_t _ptr_eventDataIndices;
	uint32_t size_eventDataIndices_2 = 0;
	uint32_t cntr_eventDataIndices_2;
	uint32_t _ptr_eventDataSizes;
	uint32_t size_eventDataSizes_2 = 0;
	uint32_t cntr_eventDataSizes_2;
	uint32_t _ptr_resultBuffer;
	uint32_t size_resultBuffer_2 = 0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_numActualRecords_0;
	TALLOC_CTX *_mem_save_eventDataIndices_0;
	TALLOC_CTX *_mem_save_eventDataIndices_1;
	TALLOC_CTX *_mem_save_eventDataIndices_2;
	TALLOC_CTX *_mem_save_eventDataSizes_0;
	TALLOC_CTX *_mem_save_eventDataSizes_1;
	TALLOC_CTX *_mem_save_eventDataSizes_2;
	TALLOC_CTX *_mem_save_resultBufferSize_0;
	TALLOC_CTX *_mem_save_resultBuffer_0;
	TALLOC_CTX *_mem_save_resultBuffer_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.numRequestedRecords));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		ZERO_STRUCTP(r->out.numActualRecords);
		NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		ZERO_STRUCTP(r->out.eventDataIndices);
		NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		ZERO_STRUCTP(r->out.eventDataSizes);
		NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		ZERO_STRUCTP(r->out.resultBufferSize);
		NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		ZERO_STRUCTP(r->out.resultBuffer);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		}
		_mem_save_numActualRecords_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numActualRecords, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numActualRecords));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numActualRecords_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		}
		_mem_save_eventDataIndices_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataIndices, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataIndices));
		if (_ptr_eventDataIndices) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataIndices);
		} else {
			*r->out.eventDataIndices = NULL;
		}
		if (*r->out.eventDataIndices) {
			_mem_save_eventDataIndices_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataIndices));
			size_eventDataIndices_2 = ndr_get_array_size(ndr, r->out.eventDataIndices);
			if (size_eventDataIndices_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataIndices, size_eventDataIndices_2);
			_mem_save_eventDataIndices_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < size_eventDataIndices_2; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		}
		_mem_save_eventDataSizes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataSizes, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataSizes));
		if (_ptr_eventDataSizes) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataSizes);
		} else {
			*r->out.eventDataSizes = NULL;
		}
		if (*r->out.eventDataSizes) {
			_mem_save_eventDataSizes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataSizes));
			size_eventDataSizes_2 = ndr_get_array_size(ndr, r->out.eventDataSizes);
			if (size_eventDataSizes_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataSizes, size_eventDataSizes_2);
			_mem_save_eventDataSizes_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < size_eventDataSizes_2; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		}
		_mem_save_resultBufferSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBufferSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resultBufferSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBufferSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		}
		_mem_save_resultBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBuffer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resultBuffer));
		if (_ptr_resultBuffer) {
			NDR_PULL_ALLOC(ndr, *r->out.resultBuffer);
		} else {
			*r->out.resultBuffer = NULL;
		}
		if (*r->out.resultBuffer) {
			_mem_save_resultBuffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.resultBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.resultBuffer));
			size_resultBuffer_2 = ndr_get_array_size(ndr, r->out.resultBuffer);
			if (size_resultBuffer_2 > MAX_RPC_BATCH_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.resultBuffer, size_resultBuffer_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, size_resultBuffer_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataIndices, *r->out.numActualRecords));
		}
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataSizes, *r->out.numActualRecords));
		}
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.resultBuffer, *r->out.resultBufferSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRemoteSubscriptionNextAsync(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRemoteSubscriptionNextAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRemoteSubscriptionNextAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "numRequestedRecords", r->in.numRequestedRecords);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRemoteSubscriptionNextAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "numActualRecords", r->out.numActualRecords);
		ndr->depth++;
		ndr_print_uint32(ndr, "numActualRecords", *r->out.numActualRecords);
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataIndices", r->out.eventDataIndices);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataIndices", *r->out.eventDataIndices);
		ndr->depth++;
		if (*r->out.eventDataIndices) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataIndices", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataIndices_2=0;cntr_eventDataIndices_2<*r->out.numActualRecords;cntr_eventDataIndices_2++) {
				ndr_print_uint32(ndr, "eventDataIndices", (*r->out.eventDataIndices)[cntr_eventDataIndices_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataSizes", r->out.eventDataSizes);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataSizes", *r->out.eventDataSizes);
		ndr->depth++;
		if (*r->out.eventDataSizes) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataSizes", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataSizes_2=0;cntr_eventDataSizes_2<*r->out.numActualRecords;cntr_eventDataSizes_2++) {
				ndr_print_uint32(ndr, "eventDataSizes", (*r->out.eventDataSizes)[cntr_eventDataSizes_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBufferSize", r->out.resultBufferSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "resultBufferSize", *r->out.resultBufferSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBuffer", r->out.resultBuffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "resultBuffer", *r->out.resultBuffer);
		ndr->depth++;
		if (*r->out.resultBuffer) {
			ndr_print_array_uint8(ndr, "resultBuffer", *r->out.resultBuffer, *r->out.resultBufferSize);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRemoteSubscriptionNext(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.numRequestedRecords));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeOut));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numActualRecords == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numActualRecords));
		if (r->out.eventDataIndices == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataIndices));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < *r->out.numActualRecords; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
		}
		if (r->out.eventDataSizes == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataSizes));
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < *r->out.numActualRecords; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
		}
		if (r->out.resultBufferSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resultBufferSize));
		if (r->out.resultBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.resultBuffer));
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.resultBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, *r->out.resultBufferSize));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRemoteSubscriptionNext(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	uint32_t _ptr_eventDataIndices;
	uint32_t size_eventDataIndices_2 = 0;
	uint32_t cntr_eventDataIndices_2;
	uint32_t _ptr_eventDataSizes;
	uint32_t size_eventDataSizes_2 = 0;
	uint32_t cntr_eventDataSizes_2;
	uint32_t _ptr_resultBuffer;
	uint32_t size_resultBuffer_2 = 0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_numActualRecords_0;
	TALLOC_CTX *_mem_save_eventDataIndices_0;
	TALLOC_CTX *_mem_save_eventDataIndices_1;
	TALLOC_CTX *_mem_save_eventDataIndices_2;
	TALLOC_CTX *_mem_save_eventDataSizes_0;
	TALLOC_CTX *_mem_save_eventDataSizes_1;
	TALLOC_CTX *_mem_save_eventDataSizes_2;
	TALLOC_CTX *_mem_save_resultBufferSize_0;
	TALLOC_CTX *_mem_save_resultBuffer_0;
	TALLOC_CTX *_mem_save_resultBuffer_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.numRequestedRecords));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeOut));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		ZERO_STRUCTP(r->out.numActualRecords);
		NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		ZERO_STRUCTP(r->out.eventDataIndices);
		NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		ZERO_STRUCTP(r->out.eventDataSizes);
		NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		ZERO_STRUCTP(r->out.resultBufferSize);
		NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		ZERO_STRUCTP(r->out.resultBuffer);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		}
		_mem_save_numActualRecords_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numActualRecords, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numActualRecords));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numActualRecords_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		}
		_mem_save_eventDataIndices_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataIndices, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataIndices));
		if (_ptr_eventDataIndices) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataIndices);
		} else {
			*r->out.eventDataIndices = NULL;
		}
		if (*r->out.eventDataIndices) {
			_mem_save_eventDataIndices_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataIndices));
			size_eventDataIndices_2 = ndr_get_array_size(ndr, r->out.eventDataIndices);
			if (size_eventDataIndices_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataIndices, size_eventDataIndices_2);
			_mem_save_eventDataIndices_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < size_eventDataIndices_2; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		}
		_mem_save_eventDataSizes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataSizes, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataSizes));
		if (_ptr_eventDataSizes) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataSizes);
		} else {
			*r->out.eventDataSizes = NULL;
		}
		if (*r->out.eventDataSizes) {
			_mem_save_eventDataSizes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataSizes));
			size_eventDataSizes_2 = ndr_get_array_size(ndr, r->out.eventDataSizes);
			if (size_eventDataSizes_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataSizes, size_eventDataSizes_2);
			_mem_save_eventDataSizes_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < size_eventDataSizes_2; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		}
		_mem_save_resultBufferSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBufferSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resultBufferSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBufferSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		}
		_mem_save_resultBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBuffer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resultBuffer));
		if (_ptr_resultBuffer) {
			NDR_PULL_ALLOC(ndr, *r->out.resultBuffer);
		} else {
			*r->out.resultBuffer = NULL;
		}
		if (*r->out.resultBuffer) {
			_mem_save_resultBuffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.resultBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.resultBuffer));
			size_resultBuffer_2 = ndr_get_array_size(ndr, r->out.resultBuffer);
			if (size_resultBuffer_2 > MAX_RPC_BATCH_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.resultBuffer, size_resultBuffer_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, size_resultBuffer_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataIndices, *r->out.numActualRecords));
		}
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataSizes, *r->out.numActualRecords));
		}
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.resultBuffer, *r->out.resultBufferSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRemoteSubscriptionNext(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRemoteSubscriptionNext");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRemoteSubscriptionNext");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "numRequestedRecords", r->in.numRequestedRecords);
		ndr_print_uint32(ndr, "timeOut", r->in.timeOut);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRemoteSubscriptionNext");
		ndr->depth++;
		ndr_print_ptr(ndr, "numActualRecords", r->out.numActualRecords);
		ndr->depth++;
		ndr_print_uint32(ndr, "numActualRecords", *r->out.numActualRecords);
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataIndices", r->out.eventDataIndices);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataIndices", *r->out.eventDataIndices);
		ndr->depth++;
		if (*r->out.eventDataIndices) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataIndices", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataIndices_2=0;cntr_eventDataIndices_2<*r->out.numActualRecords;cntr_eventDataIndices_2++) {
				ndr_print_uint32(ndr, "eventDataIndices", (*r->out.eventDataIndices)[cntr_eventDataIndices_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataSizes", r->out.eventDataSizes);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataSizes", *r->out.eventDataSizes);
		ndr->depth++;
		if (*r->out.eventDataSizes) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataSizes", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataSizes_2=0;cntr_eventDataSizes_2<*r->out.numActualRecords;cntr_eventDataSizes_2++) {
				ndr_print_uint32(ndr, "eventDataSizes", (*r->out.eventDataSizes)[cntr_eventDataSizes_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBufferSize", r->out.resultBufferSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "resultBufferSize", *r->out.resultBufferSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBuffer", r->out.resultBuffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "resultBuffer", *r->out.resultBuffer);
		ndr->depth++;
		if (*r->out.resultBuffer) {
			ndr_print_array_uint8(ndr, "resultBuffer", *r->out.resultBuffer, *r->out.resultBufferSize);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRemoteSubscriptionWaitAsync(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRemoteSubscriptionWaitAsync(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRemoteSubscriptionWaitAsync(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRemoteSubscriptionWaitAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRemoteSubscriptionWaitAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRemoteSubscriptionWaitAsync");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRegisterControllableOperation(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRegisterControllableOperation(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRegisterControllableOperation(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRegisterControllableOperation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRegisterControllableOperation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRegisterControllableOperation");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRegisterLogQuery(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	uint32_t cntr_queryChannelInfo_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.path));
		if (r->in.path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.query, ndr_charset_length(r->in.query, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		if (r->out.opControl == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.opControl));
		if (r->out.queryChannelInfoSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.queryChannelInfoSize));
		if (r->out.queryChannelInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.queryChannelInfo));
		if (*r->out.queryChannelInfo) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.queryChannelInfoSize));
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < *r->out.queryChannelInfoSize; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_SCALARS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < *r->out.queryChannelInfoSize; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_BUFFERS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
		}
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRegisterLogQuery(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	uint32_t size_query_1 = 0;
	uint32_t length_query_1 = 0;
	uint32_t _ptr_queryChannelInfo;
	uint32_t size_queryChannelInfo_2 = 0;
	uint32_t cntr_queryChannelInfo_2;
	TALLOC_CTX *_mem_save_path_0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_opControl_0;
	TALLOC_CTX *_mem_save_queryChannelInfoSize_0;
	TALLOC_CTX *_mem_save_queryChannelInfo_0;
	TALLOC_CTX *_mem_save_queryChannelInfo_1;
	TALLOC_CTX *_mem_save_queryChannelInfo_2;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->in.path);
		} else {
			r->in.path = NULL;
		}
		if (r->in.path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
			size_path_1 = ndr_get_array_size(ndr, &r->in.path);
			if (size_path_1 > MAX_RPC_CHANNEL_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_path_1 = ndr_get_array_length(ndr, &r->in.path);
			if (length_path_1 > MAX_RPC_CHANNEL_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.query));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.query));
		size_query_1 = ndr_get_array_size(ndr, &r->in.query);
		if (size_query_1 < 1 || size_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_query_1 = ndr_get_array_length(ndr, &r->in.query);
		if (length_query_1 < 1 || length_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_query_1 > size_query_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_query_1, length_query_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_query_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.query, length_query_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
		NDR_PULL_ALLOC(ndr, r->out.opControl);
		ZERO_STRUCTP(r->out.opControl);
		NDR_PULL_ALLOC(ndr, r->out.queryChannelInfoSize);
		ZERO_STRUCTP(r->out.queryChannelInfoSize);
		NDR_PULL_ALLOC(ndr, r->out.queryChannelInfo);
		ZERO_STRUCTP(r->out.queryChannelInfo);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.opControl);
		}
		_mem_save_opControl_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.opControl, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.opControl));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_opControl_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.queryChannelInfoSize);
		}
		_mem_save_queryChannelInfoSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.queryChannelInfoSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.queryChannelInfoSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfoSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.queryChannelInfo);
		}
		_mem_save_queryChannelInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.queryChannelInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_queryChannelInfo));
		if (_ptr_queryChannelInfo) {
			NDR_PULL_ALLOC(ndr, *r->out.queryChannelInfo);
		} else {
			*r->out.queryChannelInfo = NULL;
		}
		if (*r->out.queryChannelInfo) {
			_mem_save_queryChannelInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.queryChannelInfo, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.queryChannelInfo));
			size_queryChannelInfo_2 = ndr_get_array_size(ndr, r->out.queryChannelInfo);
			if (size_queryChannelInfo_2 > MAX_RPC_QUERY_CHANNEL_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.queryChannelInfo, size_queryChannelInfo_2);
			_mem_save_queryChannelInfo_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.queryChannelInfo, 0);
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < size_queryChannelInfo_2; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_SCALARS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			for (cntr_queryChannelInfo_2 = 0; cntr_queryChannelInfo_2 < size_queryChannelInfo_2; cntr_queryChannelInfo_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcQueryChannelInfo(ndr, NDR_BUFFERS, &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_queryChannelInfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.queryChannelInfo) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.queryChannelInfo, *r->out.queryChannelInfoSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRegisterLogQuery(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	uint32_t cntr_queryChannelInfo_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRegisterLogQuery");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRegisterLogQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		if (r->in.path) {
			ndr_print_string(ndr, "path", r->in.path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "query", r->in.query);
		ndr->depth++;
		ndr_print_string(ndr, "query", r->in.query);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRegisterLogQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "opControl", r->out.opControl);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "opControl", r->out.opControl);
		ndr->depth--;
		ndr_print_ptr(ndr, "queryChannelInfoSize", r->out.queryChannelInfoSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "queryChannelInfoSize", *r->out.queryChannelInfoSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "queryChannelInfo", r->out.queryChannelInfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "queryChannelInfo", *r->out.queryChannelInfo);
		ndr->depth++;
		if (*r->out.queryChannelInfo) {
			ndr->print(ndr, "%s: ARRAY(%d)", "queryChannelInfo", (int)*r->out.queryChannelInfoSize);
			ndr->depth++;
			for (cntr_queryChannelInfo_2=0;cntr_queryChannelInfo_2<*r->out.queryChannelInfoSize;cntr_queryChannelInfo_2++) {
				ndr_print_eventlog6_EvtRpcQueryChannelInfo(ndr, "queryChannelInfo", &(*r->out.queryChannelInfo)[cntr_queryChannelInfo_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcClearLog(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcClearLog *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.control == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.control));
		if (r->in.channelPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channelPath, ndr_charset_length(r->in.channelPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.backupPath));
		if (r->in.backupPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backupPath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backupPath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.backupPath, ndr_charset_length(r->in.backupPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcClearLog(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcClearLog *r)
{
	uint32_t size_channelPath_1 = 0;
	uint32_t length_channelPath_1 = 0;
	uint32_t _ptr_backupPath;
	uint32_t size_backupPath_1 = 0;
	uint32_t length_backupPath_1 = 0;
	TALLOC_CTX *_mem_save_control_0;
	TALLOC_CTX *_mem_save_backupPath_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.control);
		}
		_mem_save_control_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.control, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.control));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_control_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channelPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channelPath));
		size_channelPath_1 = ndr_get_array_size(ndr, &r->in.channelPath);
		if (size_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_channelPath_1 = ndr_get_array_length(ndr, &r->in.channelPath);
		if (length_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_channelPath_1 > size_channelPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPath_1, length_channelPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channelPath, length_channelPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_backupPath));
		if (_ptr_backupPath) {
			NDR_PULL_ALLOC(ndr, r->in.backupPath);
		} else {
			r->in.backupPath = NULL;
		}
		if (r->in.backupPath) {
			_mem_save_backupPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.backupPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.backupPath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.backupPath));
			size_backupPath_1 = ndr_get_array_size(ndr, &r->in.backupPath);
			if (size_backupPath_1 > MAX_RPC_FILE_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_backupPath_1 = ndr_get_array_length(ndr, &r->in.backupPath);
			if (length_backupPath_1 > MAX_RPC_FILE_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_backupPath_1 > size_backupPath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_backupPath_1, length_backupPath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_backupPath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.backupPath, length_backupPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_backupPath_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcClearLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcClearLog *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcClearLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcClearLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "control", r->in.control);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "control", r->in.control);
		ndr->depth--;
		ndr_print_ptr(ndr, "channelPath", r->in.channelPath);
		ndr->depth++;
		ndr_print_string(ndr, "channelPath", r->in.channelPath);
		ndr->depth--;
		ndr_print_ptr(ndr, "backupPath", r->in.backupPath);
		ndr->depth++;
		if (r->in.backupPath) {
			ndr_print_string(ndr, "backupPath", r->in.backupPath);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcClearLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcExportLog(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcExportLog *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.control == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.channelPath));
		if (r->in.channelPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channelPath, ndr_charset_length(r->in.channelPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.query, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.query, ndr_charset_length(r->in.query, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.backupPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backupPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.backupPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.backupPath, ndr_charset_length(r->in.backupPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcExportLog(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcExportLog *r)
{
	uint32_t _ptr_channelPath;
	uint32_t size_channelPath_1 = 0;
	uint32_t length_channelPath_1 = 0;
	uint32_t size_query_1 = 0;
	uint32_t length_query_1 = 0;
	uint32_t size_backupPath_1 = 0;
	uint32_t length_backupPath_1 = 0;
	TALLOC_CTX *_mem_save_control_0;
	TALLOC_CTX *_mem_save_channelPath_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.control);
		}
		_mem_save_control_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.control, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.control));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_control_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_channelPath));
		if (_ptr_channelPath) {
			NDR_PULL_ALLOC(ndr, r->in.channelPath);
		} else {
			r->in.channelPath = NULL;
		}
		if (r->in.channelPath) {
			_mem_save_channelPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.channelPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channelPath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channelPath));
			size_channelPath_1 = ndr_get_array_size(ndr, &r->in.channelPath);
			if (size_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_channelPath_1 = ndr_get_array_length(ndr, &r->in.channelPath);
			if (length_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_channelPath_1 > size_channelPath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPath_1, length_channelPath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channelPath, length_channelPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPath_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.query));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.query));
		size_query_1 = ndr_get_array_size(ndr, &r->in.query);
		if (size_query_1 < 1 || size_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_query_1 = ndr_get_array_length(ndr, &r->in.query);
		if (length_query_1 < 1 || length_query_1 > MAX_RPC_QUERY_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_query_1 > size_query_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_query_1, length_query_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_query_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.query, length_query_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.backupPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.backupPath));
		size_backupPath_1 = ndr_get_array_size(ndr, &r->in.backupPath);
		if (size_backupPath_1 < 1 || size_backupPath_1 > MAX_RPC_FILE_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_backupPath_1 = ndr_get_array_length(ndr, &r->in.backupPath);
		if (length_backupPath_1 < 1 || length_backupPath_1 > MAX_RPC_FILE_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_backupPath_1 > size_backupPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_backupPath_1, length_backupPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_backupPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.backupPath, length_backupPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcExportLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcExportLog *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcExportLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcExportLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "control", r->in.control);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "control", r->in.control);
		ndr->depth--;
		ndr_print_ptr(ndr, "channelPath", r->in.channelPath);
		ndr->depth++;
		if (r->in.channelPath) {
			ndr_print_string(ndr, "channelPath", r->in.channelPath);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "query", r->in.query);
		ndr->depth++;
		ndr_print_string(ndr, "query", r->in.query);
		ndr->depth--;
		ndr_print_ptr(ndr, "backupPath", r->in.backupPath);
		ndr->depth++;
		ndr_print_string(ndr, "backupPath", r->in.backupPath);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcExportLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcLocalizeExportLog(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.control == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.control));
		if (r->in.logFilePath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logFilePath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logFilePath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logFilePath, ndr_charset_length(r->in.logFilePath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.locale));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcLocalizeExportLog(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	uint32_t size_logFilePath_1 = 0;
	uint32_t length_logFilePath_1 = 0;
	TALLOC_CTX *_mem_save_control_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.control);
		}
		_mem_save_control_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.control, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.control));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_control_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logFilePath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logFilePath));
		size_logFilePath_1 = ndr_get_array_size(ndr, &r->in.logFilePath);
		if (size_logFilePath_1 < 1 || size_logFilePath_1 > MAX_RPC_FILE_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_logFilePath_1 = ndr_get_array_length(ndr, &r->in.logFilePath);
		if (length_logFilePath_1 < 1 || length_logFilePath_1 > MAX_RPC_FILE_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_logFilePath_1 > size_logFilePath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logFilePath_1, length_logFilePath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logFilePath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logFilePath, length_logFilePath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.locale));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcLocalizeExportLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcLocalizeExportLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcLocalizeExportLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "control", r->in.control);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "control", r->in.control);
		ndr->depth--;
		ndr_print_ptr(ndr, "logFilePath", r->in.logFilePath);
		ndr->depth++;
		ndr_print_string(ndr, "logFilePath", r->in.logFilePath);
		ndr->depth--;
		ndr_print_uint32(ndr, "locale", r->in.locale);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcLocalizeExportLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcMessageRender(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcMessageRender *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pubCfgObj == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.pubCfgObj));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.sizeEventId));
		if (r->in.eventId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.sizeEventId));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.eventId, r->in.sizeEventId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.messageId));
		if (r->in.values == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.values));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.maxSizeString));
	}
	if (flags & NDR_OUT) {
		if (r->out.actualSizeString == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.actualSizeString));
		if (r->out.neededSizeString == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.neededSizeString));
		if (r->out.string == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.string));
		if (*r->out.string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.actualSizeString));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.string, *r->out.actualSizeString));
		}
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcMessageRender(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcMessageRender *r)
{
	uint32_t size_eventId_1 = 0;
	uint32_t _ptr_string;
	uint32_t size_string_2 = 0;
	TALLOC_CTX *_mem_save_pubCfgObj_0;
	TALLOC_CTX *_mem_save_values_0;
	TALLOC_CTX *_mem_save_actualSizeString_0;
	TALLOC_CTX *_mem_save_neededSizeString_0;
	TALLOC_CTX *_mem_save_string_0;
	TALLOC_CTX *_mem_save_string_1;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pubCfgObj);
		}
		_mem_save_pubCfgObj_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pubCfgObj, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.pubCfgObj));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pubCfgObj_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.sizeEventId));
		if (r->in.sizeEventId < 1 || r->in.sizeEventId > MAX_RPC_EVENT_ID_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.eventId));
		size_eventId_1 = ndr_get_array_size(ndr, &r->in.eventId);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.eventId, size_eventId_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.eventId, size_eventId_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.messageId));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.values);
		}
		_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.values, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.values));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.maxSizeString));
		NDR_PULL_ALLOC(ndr, r->out.actualSizeString);
		ZERO_STRUCTP(r->out.actualSizeString);
		NDR_PULL_ALLOC(ndr, r->out.neededSizeString);
		ZERO_STRUCTP(r->out.neededSizeString);
		NDR_PULL_ALLOC(ndr, r->out.string);
		ZERO_STRUCTP(r->out.string);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
		if (r->in.eventId) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.eventId, r->in.sizeEventId));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.actualSizeString);
		}
		_mem_save_actualSizeString_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.actualSizeString, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.actualSizeString));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_actualSizeString_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.neededSizeString);
		}
		_mem_save_neededSizeString_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.neededSizeString, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.neededSizeString));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_neededSizeString_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.string);
		}
		_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.string, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, *r->out.string);
		} else {
			*r->out.string = NULL;
		}
		if (*r->out.string) {
			_mem_save_string_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.string));
			size_string_2 = ndr_get_array_size(ndr, r->out.string);
			if (size_string_2 > MAX_RPC_RENDERED_STRING_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.string, size_string_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.string, size_string_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.string) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.string, *r->out.actualSizeString));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcMessageRender(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcMessageRender *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcMessageRender");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcMessageRender");
		ndr->depth++;
		ndr_print_ptr(ndr, "pubCfgObj", r->in.pubCfgObj);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pubCfgObj", r->in.pubCfgObj);
		ndr->depth--;
		ndr_print_uint32(ndr, "sizeEventId", r->in.sizeEventId);
		ndr_print_ptr(ndr, "eventId", r->in.eventId);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "eventId", r->in.eventId, r->in.sizeEventId);
		ndr->depth--;
		ndr_print_uint32(ndr, "messageId", r->in.messageId);
		ndr_print_ptr(ndr, "values", r->in.values);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "values", r->in.values);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "maxSizeString", r->in.maxSizeString);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcMessageRender");
		ndr->depth++;
		ndr_print_ptr(ndr, "actualSizeString", r->out.actualSizeString);
		ndr->depth++;
		ndr_print_uint32(ndr, "actualSizeString", *r->out.actualSizeString);
		ndr->depth--;
		ndr_print_ptr(ndr, "neededSizeString", r->out.neededSizeString);
		ndr->depth++;
		ndr_print_uint32(ndr, "neededSizeString", *r->out.neededSizeString);
		ndr->depth--;
		ndr_print_ptr(ndr, "string", r->out.string);
		ndr->depth++;
		ndr_print_ptr(ndr, "string", *r->out.string);
		ndr->depth++;
		if (*r->out.string) {
			ndr_print_array_uint8(ndr, "string", *r->out.string, *r->out.actualSizeString);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcMessageRenderDefault(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.sizeEventId));
		if (r->in.eventId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.sizeEventId));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.eventId, r->in.sizeEventId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.messageId));
		if (r->in.values == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.values));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.maxSizeString));
	}
	if (flags & NDR_OUT) {
		if (r->out.actualSizeString == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.actualSizeString));
		if (r->out.neededSizeString == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.neededSizeString));
		if (r->out.string == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.string));
		if (*r->out.string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.actualSizeString));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.string, *r->out.actualSizeString));
		}
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcMessageRenderDefault(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	uint32_t size_eventId_1 = 0;
	uint32_t _ptr_string;
	uint32_t size_string_2 = 0;
	TALLOC_CTX *_mem_save_values_0;
	TALLOC_CTX *_mem_save_actualSizeString_0;
	TALLOC_CTX *_mem_save_neededSizeString_0;
	TALLOC_CTX *_mem_save_string_0;
	TALLOC_CTX *_mem_save_string_1;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.sizeEventId));
		if (r->in.sizeEventId < 1 || r->in.sizeEventId > MAX_RPC_EVENT_ID_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.eventId));
		size_eventId_1 = ndr_get_array_size(ndr, &r->in.eventId);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.eventId, size_eventId_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.eventId, size_eventId_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.messageId));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.values);
		}
		_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.values, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.values));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.maxSizeString));
		NDR_PULL_ALLOC(ndr, r->out.actualSizeString);
		ZERO_STRUCTP(r->out.actualSizeString);
		NDR_PULL_ALLOC(ndr, r->out.neededSizeString);
		ZERO_STRUCTP(r->out.neededSizeString);
		NDR_PULL_ALLOC(ndr, r->out.string);
		ZERO_STRUCTP(r->out.string);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
		if (r->in.eventId) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.eventId, r->in.sizeEventId));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.actualSizeString);
		}
		_mem_save_actualSizeString_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.actualSizeString, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.actualSizeString));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_actualSizeString_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.neededSizeString);
		}
		_mem_save_neededSizeString_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.neededSizeString, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.neededSizeString));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_neededSizeString_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.string);
		}
		_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.string, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, *r->out.string);
		} else {
			*r->out.string = NULL;
		}
		if (*r->out.string) {
			_mem_save_string_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.string));
			size_string_2 = ndr_get_array_size(ndr, r->out.string);
			if (size_string_2 > MAX_RPC_RENDERED_STRING_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.string, size_string_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.string, size_string_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.string) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.string, *r->out.actualSizeString));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcMessageRenderDefault(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcMessageRenderDefault");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcMessageRenderDefault");
		ndr->depth++;
		ndr_print_uint32(ndr, "sizeEventId", r->in.sizeEventId);
		ndr_print_ptr(ndr, "eventId", r->in.eventId);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "eventId", r->in.eventId, r->in.sizeEventId);
		ndr->depth--;
		ndr_print_uint32(ndr, "messageId", r->in.messageId);
		ndr_print_ptr(ndr, "values", r->in.values);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "values", r->in.values);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "maxSizeString", r->in.maxSizeString);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcMessageRenderDefault");
		ndr->depth++;
		ndr_print_ptr(ndr, "actualSizeString", r->out.actualSizeString);
		ndr->depth++;
		ndr_print_uint32(ndr, "actualSizeString", *r->out.actualSizeString);
		ndr->depth--;
		ndr_print_ptr(ndr, "neededSizeString", r->out.neededSizeString);
		ndr->depth++;
		ndr_print_uint32(ndr, "neededSizeString", *r->out.neededSizeString);
		ndr->depth--;
		ndr_print_ptr(ndr, "string", r->out.string);
		ndr->depth++;
		ndr_print_ptr(ndr, "string", *r->out.string);
		ndr->depth++;
		if (*r->out.string) {
			ndr_print_array_uint8(ndr, "string", *r->out.string, *r->out.actualSizeString);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcQueryNext(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcQueryNext *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.logQuery == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.logQuery));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.numRequestedRecords));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeOutEnd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numActualRecords == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numActualRecords));
		if (r->out.eventDataIndices == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataIndices));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < *r->out.numActualRecords; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
		}
		if (r->out.eventDataSizes == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventDataSizes));
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numActualRecords));
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < *r->out.numActualRecords; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
		}
		if (r->out.resultBufferSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resultBufferSize));
		if (r->out.resultBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.resultBuffer));
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.resultBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, *r->out.resultBufferSize));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcQueryNext(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcQueryNext *r)
{
	uint32_t _ptr_eventDataIndices;
	uint32_t size_eventDataIndices_2 = 0;
	uint32_t cntr_eventDataIndices_2;
	uint32_t _ptr_eventDataSizes;
	uint32_t size_eventDataSizes_2 = 0;
	uint32_t cntr_eventDataSizes_2;
	uint32_t _ptr_resultBuffer;
	uint32_t size_resultBuffer_2 = 0;
	TALLOC_CTX *_mem_save_logQuery_0;
	TALLOC_CTX *_mem_save_numActualRecords_0;
	TALLOC_CTX *_mem_save_eventDataIndices_0;
	TALLOC_CTX *_mem_save_eventDataIndices_1;
	TALLOC_CTX *_mem_save_eventDataIndices_2;
	TALLOC_CTX *_mem_save_eventDataSizes_0;
	TALLOC_CTX *_mem_save_eventDataSizes_1;
	TALLOC_CTX *_mem_save_eventDataSizes_2;
	TALLOC_CTX *_mem_save_resultBufferSize_0;
	TALLOC_CTX *_mem_save_resultBuffer_0;
	TALLOC_CTX *_mem_save_resultBuffer_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logQuery);
		}
		_mem_save_logQuery_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logQuery, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.logQuery));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logQuery_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.numRequestedRecords));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeOutEnd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		ZERO_STRUCTP(r->out.numActualRecords);
		NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		ZERO_STRUCTP(r->out.eventDataIndices);
		NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		ZERO_STRUCTP(r->out.eventDataSizes);
		NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		ZERO_STRUCTP(r->out.resultBufferSize);
		NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		ZERO_STRUCTP(r->out.resultBuffer);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numActualRecords);
		}
		_mem_save_numActualRecords_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numActualRecords, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numActualRecords));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numActualRecords_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataIndices);
		}
		_mem_save_eventDataIndices_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataIndices, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataIndices));
		if (_ptr_eventDataIndices) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataIndices);
		} else {
			*r->out.eventDataIndices = NULL;
		}
		if (*r->out.eventDataIndices) {
			_mem_save_eventDataIndices_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataIndices));
			size_eventDataIndices_2 = ndr_get_array_size(ndr, r->out.eventDataIndices);
			if (size_eventDataIndices_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataIndices, size_eventDataIndices_2);
			_mem_save_eventDataIndices_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataIndices, 0);
			for (cntr_eventDataIndices_2 = 0; cntr_eventDataIndices_2 < size_eventDataIndices_2; cntr_eventDataIndices_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataIndices)[cntr_eventDataIndices_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataIndices_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventDataSizes);
		}
		_mem_save_eventDataSizes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventDataSizes, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventDataSizes));
		if (_ptr_eventDataSizes) {
			NDR_PULL_ALLOC(ndr, *r->out.eventDataSizes);
		} else {
			*r->out.eventDataSizes = NULL;
		}
		if (*r->out.eventDataSizes) {
			_mem_save_eventDataSizes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventDataSizes));
			size_eventDataSizes_2 = ndr_get_array_size(ndr, r->out.eventDataSizes);
			if (size_eventDataSizes_2 > MAX_RPC_RECORD_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventDataSizes, size_eventDataSizes_2);
			_mem_save_eventDataSizes_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventDataSizes, 0);
			for (cntr_eventDataSizes_2 = 0; cntr_eventDataSizes_2 < size_eventDataSizes_2; cntr_eventDataSizes_2++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &(*r->out.eventDataSizes)[cntr_eventDataSizes_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventDataSizes_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBufferSize);
		}
		_mem_save_resultBufferSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBufferSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resultBufferSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBufferSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resultBuffer);
		}
		_mem_save_resultBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resultBuffer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resultBuffer));
		if (_ptr_resultBuffer) {
			NDR_PULL_ALLOC(ndr, *r->out.resultBuffer);
		} else {
			*r->out.resultBuffer = NULL;
		}
		if (*r->out.resultBuffer) {
			_mem_save_resultBuffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.resultBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.resultBuffer));
			size_resultBuffer_2 = ndr_get_array_size(ndr, r->out.resultBuffer);
			if (size_resultBuffer_2 > MAX_RPC_BATCH_SIZE) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.resultBuffer, size_resultBuffer_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.resultBuffer, size_resultBuffer_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resultBuffer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.eventDataIndices) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataIndices, *r->out.numActualRecords));
		}
		if (*r->out.eventDataSizes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventDataSizes, *r->out.numActualRecords));
		}
		if (*r->out.resultBuffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.resultBuffer, *r->out.resultBufferSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcQueryNext(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcQueryNext *r)
{
	uint32_t cntr_eventDataIndices_2;
	uint32_t cntr_eventDataSizes_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcQueryNext");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcQueryNext");
		ndr->depth++;
		ndr_print_ptr(ndr, "logQuery", r->in.logQuery);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "logQuery", r->in.logQuery);
		ndr->depth--;
		ndr_print_uint32(ndr, "numRequestedRecords", r->in.numRequestedRecords);
		ndr_print_uint32(ndr, "timeOutEnd", r->in.timeOutEnd);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcQueryNext");
		ndr->depth++;
		ndr_print_ptr(ndr, "numActualRecords", r->out.numActualRecords);
		ndr->depth++;
		ndr_print_uint32(ndr, "numActualRecords", *r->out.numActualRecords);
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataIndices", r->out.eventDataIndices);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataIndices", *r->out.eventDataIndices);
		ndr->depth++;
		if (*r->out.eventDataIndices) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataIndices", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataIndices_2=0;cntr_eventDataIndices_2<*r->out.numActualRecords;cntr_eventDataIndices_2++) {
				ndr_print_uint32(ndr, "eventDataIndices", (*r->out.eventDataIndices)[cntr_eventDataIndices_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "eventDataSizes", r->out.eventDataSizes);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventDataSizes", *r->out.eventDataSizes);
		ndr->depth++;
		if (*r->out.eventDataSizes) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventDataSizes", (int)*r->out.numActualRecords);
			ndr->depth++;
			for (cntr_eventDataSizes_2=0;cntr_eventDataSizes_2<*r->out.numActualRecords;cntr_eventDataSizes_2++) {
				ndr_print_uint32(ndr, "eventDataSizes", (*r->out.eventDataSizes)[cntr_eventDataSizes_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBufferSize", r->out.resultBufferSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "resultBufferSize", *r->out.resultBufferSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "resultBuffer", r->out.resultBuffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "resultBuffer", *r->out.resultBuffer);
		ndr->depth++;
		if (*r->out.resultBuffer) {
			ndr_print_array_uint8(ndr, "resultBuffer", *r->out.resultBuffer, *r->out.resultBufferSize);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcQuerySeek(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcQuerySeek *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.logQuery == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.logQuery));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.pos));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bookmarkXml));
		if (r->in.bookmarkXml) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.bookmarkXml, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.bookmarkXml, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.bookmarkXml, ndr_charset_length(r->in.bookmarkXml, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeOut));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcQuerySeek(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcQuerySeek *r)
{
	uint32_t _ptr_bookmarkXml;
	uint32_t size_bookmarkXml_1 = 0;
	uint32_t length_bookmarkXml_1 = 0;
	TALLOC_CTX *_mem_save_logQuery_0;
	TALLOC_CTX *_mem_save_bookmarkXml_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logQuery);
		}
		_mem_save_logQuery_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logQuery, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.logQuery));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logQuery_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.pos));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bookmarkXml));
		if (_ptr_bookmarkXml) {
			NDR_PULL_ALLOC(ndr, r->in.bookmarkXml);
		} else {
			r->in.bookmarkXml = NULL;
		}
		if (r->in.bookmarkXml) {
			_mem_save_bookmarkXml_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bookmarkXml, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.bookmarkXml));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.bookmarkXml));
			size_bookmarkXml_1 = ndr_get_array_size(ndr, &r->in.bookmarkXml);
			if (size_bookmarkXml_1 > MAX_RPC_BOOKMARK_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_bookmarkXml_1 = ndr_get_array_length(ndr, &r->in.bookmarkXml);
			if (length_bookmarkXml_1 > MAX_RPC_BOOKMARK_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_bookmarkXml_1 > size_bookmarkXml_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_bookmarkXml_1, length_bookmarkXml_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_bookmarkXml_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.bookmarkXml, length_bookmarkXml_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bookmarkXml_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeOut));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcQuerySeek(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcQuerySeek *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcQuerySeek");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcQuerySeek");
		ndr->depth++;
		ndr_print_ptr(ndr, "logQuery", r->in.logQuery);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "logQuery", r->in.logQuery);
		ndr->depth--;
		ndr_print_hyper(ndr, "pos", r->in.pos);
		ndr_print_ptr(ndr, "bookmarkXml", r->in.bookmarkXml);
		ndr->depth++;
		if (r->in.bookmarkXml) {
			ndr_print_string(ndr, "bookmarkXml", r->in.bookmarkXml);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "timeOut", r->in.timeOut);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcQuerySeek");
		ndr->depth++;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcClose(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcClose *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.handle));
		if (*r->in.handle) {
			NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, *r->in.handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.handle));
		if (*r->out.handle) {
			NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, *r->out.handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcClose(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcClose *r)
{
	uint32_t _ptr_handle;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_handle_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_handle));
		if (_ptr_handle) {
			NDR_PULL_ALLOC(ndr, *r->in.handle);
		} else {
			*r->in.handle = NULL;
		}
		if (*r->in.handle) {
			_mem_save_handle_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->in.handle, 0);
			NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, *r->in.handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_handle));
		if (_ptr_handle) {
			NDR_PULL_ALLOC(ndr, *r->out.handle);
		} else {
			*r->out.handle = NULL;
		}
		if (*r->out.handle) {
			_mem_save_handle_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.handle, 0);
			NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, *r->out.handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcClose(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcClose *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcClose");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcClose");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", *r->in.handle);
		ndr->depth++;
		if (*r->in.handle) {
			ndr_print_policy_handle(ndr, "handle", *r->in.handle);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcClose");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", *r->out.handle);
		ndr->depth++;
		if (*r->out.handle) {
			ndr_print_policy_handle(ndr, "handle", *r->out.handle);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcCancel(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcCancel *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcCancel(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcCancel *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcCancel(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcCancel *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcCancel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcCancel");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcCancel");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcAssertConfig(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcAssertConfig *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.path == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcAssertConfig(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcAssertConfig *r)
{
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
		size_path_1 = ndr_get_array_size(ndr, &r->in.path);
		if (size_path_1 < 1 || size_path_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_path_1 = ndr_get_array_length(ndr, &r->in.path);
		if (length_path_1 < 1 || length_path_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_path_1 > size_path_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, length_path_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcAssertConfig(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcAssertConfig *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcAssertConfig");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcAssertConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		ndr_print_string(ndr, "path", r->in.path);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcAssertConfig");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcRetractConfig(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcRetractConfig *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.path == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcRetractConfig(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcRetractConfig *r)
{
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
		size_path_1 = ndr_get_array_size(ndr, &r->in.path);
		if (size_path_1 < 1 || size_path_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_path_1 = ndr_get_array_length(ndr, &r->in.path);
		if (length_path_1 < 1 || length_path_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_path_1 > size_path_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, length_path_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcRetractConfig(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcRetractConfig *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcRetractConfig");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcRetractConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		ndr_print_string(ndr, "path", r->in.path);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcRetractConfig");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcOpenLogHandle(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcOpenLogHandle *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.channel == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channel, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channel, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channel, ndr_charset_length(r->in.channel, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcOpenLogHandle(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcOpenLogHandle *r)
{
	uint32_t size_channel_1 = 0;
	uint32_t length_channel_1 = 0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channel));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channel));
		size_channel_1 = ndr_get_array_size(ndr, &r->in.channel);
		if (size_channel_1 < 1 || size_channel_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_channel_1 = ndr_get_array_length(ndr, &r->in.channel);
		if (length_channel_1 < 1 || length_channel_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_channel_1 > size_channel_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channel_1, length_channel_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_channel_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channel, length_channel_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcOpenLogHandle(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcOpenLogHandle *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcOpenLogHandle");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcOpenLogHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "channel", r->in.channel);
		ndr->depth++;
		ndr_print_string(ndr, "channel", r->in.channel);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcOpenLogHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetLogFileInfo(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.logHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.logHandle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.propertyId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.propertyValueBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.propertyValueBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.propertyValueBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.propertyValueBuffer, r->in.propertyValueBufferSize));
		if (r->out.propertyValueBufferLength == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.propertyValueBufferLength));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetLogFileInfo(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	uint32_t size_propertyValueBuffer_1 = 0;
	TALLOC_CTX *_mem_save_logHandle_0;
	TALLOC_CTX *_mem_save_propertyValueBufferLength_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logHandle);
		}
		_mem_save_logHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.logHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.propertyId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.propertyValueBufferSize));
		if (r->in.propertyValueBufferSize > MAX_RPC_PROPERTY_BUFFER_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.propertyValueBuffer, r->in.propertyValueBufferSize);
		memset(r->out.propertyValueBuffer, 0, (r->in.propertyValueBufferSize) * sizeof(*r->out.propertyValueBuffer));
		NDR_PULL_ALLOC(ndr, r->out.propertyValueBufferLength);
		ZERO_STRUCTP(r->out.propertyValueBufferLength);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.propertyValueBuffer));
		size_propertyValueBuffer_1 = ndr_get_array_size(ndr, &r->out.propertyValueBuffer);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.propertyValueBuffer, size_propertyValueBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.propertyValueBuffer, size_propertyValueBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.propertyValueBufferLength);
		}
		_mem_save_propertyValueBufferLength_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.propertyValueBufferLength, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.propertyValueBufferLength));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertyValueBufferLength_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.propertyValueBuffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.propertyValueBuffer, r->in.propertyValueBufferSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetLogFileInfo(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetLogFileInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetLogFileInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "logHandle", r->in.logHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "logHandle", r->in.logHandle);
		ndr->depth--;
		ndr_print_uint32(ndr, "propertyId", r->in.propertyId);
		ndr_print_uint32(ndr, "propertyValueBufferSize", r->in.propertyValueBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetLogFileInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "propertyValueBuffer", r->out.propertyValueBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "propertyValueBuffer", r->out.propertyValueBuffer, r->in.propertyValueBufferSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "propertyValueBufferLength", r->out.propertyValueBufferLength);
		ndr->depth++;
		ndr_print_uint32(ndr, "propertyValueBufferLength", *r->out.propertyValueBufferLength);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetChannelList(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetChannelList *r)
{
	uint32_t cntr_channelPaths_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numChannelPaths == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numChannelPaths));
		if (r->out.channelPaths == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.channelPaths));
		if (*r->out.channelPaths) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numChannelPaths));
			for (cntr_channelPaths_2 = 0; cntr_channelPaths_2 < *r->out.numChannelPaths; cntr_channelPaths_2++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, (*r->out.channelPaths)[cntr_channelPaths_2]));
			}
			for (cntr_channelPaths_2 = 0; cntr_channelPaths_2 < *r->out.numChannelPaths; cntr_channelPaths_2++) {
				if ((*r->out.channelPaths)[cntr_channelPaths_2]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.channelPaths)[cntr_channelPaths_2], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.channelPaths)[cntr_channelPaths_2], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, (*r->out.channelPaths)[cntr_channelPaths_2], ndr_charset_length((*r->out.channelPaths)[cntr_channelPaths_2], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetChannelList(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetChannelList *r)
{
	uint32_t _ptr_channelPaths;
	uint32_t size_channelPaths_2 = 0;
	uint32_t cntr_channelPaths_2;
	uint32_t size_channelPaths_4 = 0;
	uint32_t length_channelPaths_4 = 0;
	TALLOC_CTX *_mem_save_numChannelPaths_0;
	TALLOC_CTX *_mem_save_channelPaths_0;
	TALLOC_CTX *_mem_save_channelPaths_1;
	TALLOC_CTX *_mem_save_channelPaths_2;
	TALLOC_CTX *_mem_save_channelPaths_3;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numChannelPaths);
		ZERO_STRUCTP(r->out.numChannelPaths);
		NDR_PULL_ALLOC(ndr, r->out.channelPaths);
		ZERO_STRUCTP(r->out.channelPaths);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numChannelPaths);
		}
		_mem_save_numChannelPaths_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numChannelPaths, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numChannelPaths));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numChannelPaths_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.channelPaths);
		}
		_mem_save_channelPaths_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.channelPaths, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_channelPaths));
		if (_ptr_channelPaths) {
			NDR_PULL_ALLOC(ndr, *r->out.channelPaths);
		} else {
			*r->out.channelPaths = NULL;
		}
		if (*r->out.channelPaths) {
			_mem_save_channelPaths_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.channelPaths, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.channelPaths));
			size_channelPaths_2 = ndr_get_array_size(ndr, r->out.channelPaths);
			if (size_channelPaths_2 > MAX_RPC_CHANNEL_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.channelPaths, size_channelPaths_2);
			_mem_save_channelPaths_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.channelPaths, 0);
			for (cntr_channelPaths_2 = 0; cntr_channelPaths_2 < size_channelPaths_2; cntr_channelPaths_2++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_channelPaths));
				if (_ptr_channelPaths) {
					NDR_PULL_ALLOC(ndr, (*r->out.channelPaths)[cntr_channelPaths_2]);
				} else {
					(*r->out.channelPaths)[cntr_channelPaths_2] = NULL;
				}
			}
			for (cntr_channelPaths_2 = 0; cntr_channelPaths_2 < size_channelPaths_2; cntr_channelPaths_2++) {
				if ((*r->out.channelPaths)[cntr_channelPaths_2]) {
					_mem_save_channelPaths_3 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, (*r->out.channelPaths)[cntr_channelPaths_2], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &(*r->out.channelPaths)[cntr_channelPaths_2]));
					NDR_CHECK(ndr_pull_array_length(ndr, &(*r->out.channelPaths)[cntr_channelPaths_2]));
					size_channelPaths_4 = ndr_get_array_size(ndr, &(*r->out.channelPaths)[cntr_channelPaths_2]);
					if (size_channelPaths_4 > MAX_RPC_CHANNEL_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					length_channelPaths_4 = ndr_get_array_length(ndr, &(*r->out.channelPaths)[cntr_channelPaths_2]);
					if (length_channelPaths_4 > MAX_RPC_CHANNEL_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					if (length_channelPaths_4 > size_channelPaths_4) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPaths_4, length_channelPaths_4);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPaths_4, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &(*r->out.channelPaths)[cntr_channelPaths_2], length_channelPaths_4, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPaths_3, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPaths_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPaths_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelPaths_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.channelPaths) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.channelPaths, *r->out.numChannelPaths));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetChannelList(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetChannelList *r)
{
	uint32_t cntr_channelPaths_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetChannelList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetChannelList");
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetChannelList");
		ndr->depth++;
		ndr_print_ptr(ndr, "numChannelPaths", r->out.numChannelPaths);
		ndr->depth++;
		ndr_print_uint32(ndr, "numChannelPaths", *r->out.numChannelPaths);
		ndr->depth--;
		ndr_print_ptr(ndr, "channelPaths", r->out.channelPaths);
		ndr->depth++;
		ndr_print_ptr(ndr, "channelPaths", *r->out.channelPaths);
		ndr->depth++;
		if (*r->out.channelPaths) {
			ndr->print(ndr, "%s: ARRAY(%d)", "channelPaths", (int)*r->out.numChannelPaths);
			ndr->depth++;
			for (cntr_channelPaths_2=0;cntr_channelPaths_2<*r->out.numChannelPaths;cntr_channelPaths_2++) {
				ndr_print_ptr(ndr, "channelPaths", (*r->out.channelPaths)[cntr_channelPaths_2]);
				ndr->depth++;
				if ((*r->out.channelPaths)[cntr_channelPaths_2]) {
					ndr_print_string(ndr, "channelPaths", (*r->out.channelPaths)[cntr_channelPaths_2]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetChannelConfig(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetChannelConfig *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.channelPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channelPath, ndr_charset_length(r->in.channelPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.props == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.props));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetChannelConfig(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetChannelConfig *r)
{
	uint32_t size_channelPath_1 = 0;
	uint32_t length_channelPath_1 = 0;
	TALLOC_CTX *_mem_save_props_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channelPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channelPath));
		size_channelPath_1 = ndr_get_array_size(ndr, &r->in.channelPath);
		if (size_channelPath_1 < 1 || size_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_channelPath_1 = ndr_get_array_length(ndr, &r->in.channelPath);
		if (length_channelPath_1 < 1 || length_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_channelPath_1 > size_channelPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPath_1, length_channelPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channelPath, length_channelPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.props);
		ZERO_STRUCTP(r->out.props);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.props);
		}
		_mem_save_props_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.props, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.props));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_props_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetChannelConfig(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetChannelConfig *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetChannelConfig");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetChannelConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "channelPath", r->in.channelPath);
		ndr->depth++;
		ndr_print_string(ndr, "channelPath", r->in.channelPath);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetChannelConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "props", r->out.props);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "props", r->out.props);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcPutChannelConfig(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcPutChannelConfig *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.channelPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.channelPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.channelPath, ndr_charset_length(r->in.channelPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		if (r->in.props == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.props));
	}
	if (flags & NDR_OUT) {
		if (r->out.error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcPutChannelConfig(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcPutChannelConfig *r)
{
	uint32_t size_channelPath_1 = 0;
	uint32_t length_channelPath_1 = 0;
	TALLOC_CTX *_mem_save_props_0;
	TALLOC_CTX *_mem_save_error_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.channelPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.channelPath));
		size_channelPath_1 = ndr_get_array_size(ndr, &r->in.channelPath);
		if (size_channelPath_1 < 1 || size_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_channelPath_1 = ndr_get_array_length(ndr, &r->in.channelPath);
		if (length_channelPath_1 < 1 || length_channelPath_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_channelPath_1 > size_channelPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_channelPath_1, length_channelPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_channelPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.channelPath, length_channelPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.props);
		}
		_mem_save_props_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.props, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.props));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_props_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.error);
		ZERO_STRUCTP(r->out.error);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.error);
		}
		_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_RpcInfo(ndr, NDR_SCALARS, r->out.error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcPutChannelConfig(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcPutChannelConfig *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcPutChannelConfig");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcPutChannelConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "channelPath", r->in.channelPath);
		ndr->depth++;
		ndr_print_string(ndr, "channelPath", r->in.channelPath);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "props", r->in.props);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "props", r->in.props);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcPutChannelConfig");
		ndr->depth++;
		ndr_print_ptr(ndr, "error", r->out.error);
		ndr->depth++;
		ndr_print_eventlog6_RpcInfo(ndr, "error", r->out.error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetPublisherList(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetPublisherList *r)
{
	uint32_t cntr_publisherIds_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numPublisherIds == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numPublisherIds));
		if (r->out.publisherIds == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.publisherIds));
		if (*r->out.publisherIds) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numPublisherIds));
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < *r->out.numPublisherIds; cntr_publisherIds_2++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, (*r->out.publisherIds)[cntr_publisherIds_2]));
			}
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < *r->out.numPublisherIds; cntr_publisherIds_2++) {
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, (*r->out.publisherIds)[cntr_publisherIds_2], ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetPublisherList(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetPublisherList *r)
{
	uint32_t _ptr_publisherIds;
	uint32_t size_publisherIds_2 = 0;
	uint32_t cntr_publisherIds_2;
	uint32_t size_publisherIds_4 = 0;
	uint32_t length_publisherIds_4 = 0;
	TALLOC_CTX *_mem_save_numPublisherIds_0;
	TALLOC_CTX *_mem_save_publisherIds_0;
	TALLOC_CTX *_mem_save_publisherIds_1;
	TALLOC_CTX *_mem_save_publisherIds_2;
	TALLOC_CTX *_mem_save_publisherIds_3;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numPublisherIds);
		ZERO_STRUCTP(r->out.numPublisherIds);
		NDR_PULL_ALLOC(ndr, r->out.publisherIds);
		ZERO_STRUCTP(r->out.publisherIds);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numPublisherIds);
		}
		_mem_save_numPublisherIds_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numPublisherIds, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numPublisherIds));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numPublisherIds_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.publisherIds);
		}
		_mem_save_publisherIds_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.publisherIds, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_publisherIds));
		if (_ptr_publisherIds) {
			NDR_PULL_ALLOC(ndr, *r->out.publisherIds);
		} else {
			*r->out.publisherIds = NULL;
		}
		if (*r->out.publisherIds) {
			_mem_save_publisherIds_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.publisherIds, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.publisherIds));
			size_publisherIds_2 = ndr_get_array_size(ndr, r->out.publisherIds);
			if (size_publisherIds_2 > MAX_RPC_PUBLISHER_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.publisherIds, size_publisherIds_2);
			_mem_save_publisherIds_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.publisherIds, 0);
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < size_publisherIds_2; cntr_publisherIds_2++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_publisherIds));
				if (_ptr_publisherIds) {
					NDR_PULL_ALLOC(ndr, (*r->out.publisherIds)[cntr_publisherIds_2]);
				} else {
					(*r->out.publisherIds)[cntr_publisherIds_2] = NULL;
				}
			}
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < size_publisherIds_2; cntr_publisherIds_2++) {
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					_mem_save_publisherIds_3 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, (*r->out.publisherIds)[cntr_publisherIds_2], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]));
					NDR_CHECK(ndr_pull_array_length(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]));
					size_publisherIds_4 = ndr_get_array_size(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]);
					if (size_publisherIds_4 > MAX_RPC_PUBLISHER_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					length_publisherIds_4 = ndr_get_array_length(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]);
					if (length_publisherIds_4 > MAX_RPC_PUBLISHER_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					if (length_publisherIds_4 > size_publisherIds_4) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_publisherIds_4, length_publisherIds_4);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_publisherIds_4, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &(*r->out.publisherIds)[cntr_publisherIds_2], length_publisherIds_4, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_3, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.publisherIds) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.publisherIds, *r->out.numPublisherIds));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetPublisherList(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetPublisherList *r)
{
	uint32_t cntr_publisherIds_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetPublisherList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetPublisherList");
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetPublisherList");
		ndr->depth++;
		ndr_print_ptr(ndr, "numPublisherIds", r->out.numPublisherIds);
		ndr->depth++;
		ndr_print_uint32(ndr, "numPublisherIds", *r->out.numPublisherIds);
		ndr->depth--;
		ndr_print_ptr(ndr, "publisherIds", r->out.publisherIds);
		ndr->depth++;
		ndr_print_ptr(ndr, "publisherIds", *r->out.publisherIds);
		ndr->depth++;
		if (*r->out.publisherIds) {
			ndr->print(ndr, "%s: ARRAY(%d)", "publisherIds", (int)*r->out.numPublisherIds);
			ndr->depth++;
			for (cntr_publisherIds_2=0;cntr_publisherIds_2<*r->out.numPublisherIds;cntr_publisherIds_2++) {
				ndr_print_ptr(ndr, "publisherIds", (*r->out.publisherIds)[cntr_publisherIds_2]);
				ndr->depth++;
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					ndr_print_string(ndr, "publisherIds", (*r->out.publisherIds)[cntr_publisherIds_2]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetPublisherListForChannel(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	uint32_t cntr_publisherIds_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.channelName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.channelName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.numPublisherIds == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numPublisherIds));
		if (r->out.publisherIds == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.publisherIds));
		if (*r->out.publisherIds) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numPublisherIds));
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < *r->out.numPublisherIds; cntr_publisherIds_2++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, (*r->out.publisherIds)[cntr_publisherIds_2]));
			}
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < *r->out.numPublisherIds; cntr_publisherIds_2++) {
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, (*r->out.publisherIds)[cntr_publisherIds_2], ndr_charset_length((*r->out.publisherIds)[cntr_publisherIds_2], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetPublisherListForChannel(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	uint32_t _ptr_publisherIds;
	uint32_t size_publisherIds_2 = 0;
	uint32_t cntr_publisherIds_2;
	uint32_t size_publisherIds_4 = 0;
	uint32_t length_publisherIds_4 = 0;
	TALLOC_CTX *_mem_save_channelName_0;
	TALLOC_CTX *_mem_save_numPublisherIds_0;
	TALLOC_CTX *_mem_save_publisherIds_0;
	TALLOC_CTX *_mem_save_publisherIds_1;
	TALLOC_CTX *_mem_save_publisherIds_2;
	TALLOC_CTX *_mem_save_publisherIds_3;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.channelName);
		}
		_mem_save_channelName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.channelName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.channelName));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channelName_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.numPublisherIds);
		ZERO_STRUCTP(r->out.numPublisherIds);
		NDR_PULL_ALLOC(ndr, r->out.publisherIds);
		ZERO_STRUCTP(r->out.publisherIds);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numPublisherIds);
		}
		_mem_save_numPublisherIds_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numPublisherIds, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numPublisherIds));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numPublisherIds_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.publisherIds);
		}
		_mem_save_publisherIds_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.publisherIds, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_publisherIds));
		if (_ptr_publisherIds) {
			NDR_PULL_ALLOC(ndr, *r->out.publisherIds);
		} else {
			*r->out.publisherIds = NULL;
		}
		if (*r->out.publisherIds) {
			_mem_save_publisherIds_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.publisherIds, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.publisherIds));
			size_publisherIds_2 = ndr_get_array_size(ndr, r->out.publisherIds);
			if (size_publisherIds_2 > MAX_RPC_PUBLISHER_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.publisherIds, size_publisherIds_2);
			_mem_save_publisherIds_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.publisherIds, 0);
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < size_publisherIds_2; cntr_publisherIds_2++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_publisherIds));
				if (_ptr_publisherIds) {
					NDR_PULL_ALLOC(ndr, (*r->out.publisherIds)[cntr_publisherIds_2]);
				} else {
					(*r->out.publisherIds)[cntr_publisherIds_2] = NULL;
				}
			}
			for (cntr_publisherIds_2 = 0; cntr_publisherIds_2 < size_publisherIds_2; cntr_publisherIds_2++) {
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					_mem_save_publisherIds_3 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, (*r->out.publisherIds)[cntr_publisherIds_2], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]));
					NDR_CHECK(ndr_pull_array_length(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]));
					size_publisherIds_4 = ndr_get_array_size(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]);
					if (size_publisherIds_4 > MAX_RPC_PUBLISHER_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					length_publisherIds_4 = ndr_get_array_length(ndr, &(*r->out.publisherIds)[cntr_publisherIds_2]);
					if (length_publisherIds_4 > MAX_RPC_PUBLISHER_COUNT) {
						return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
					}
					if (length_publisherIds_4 > size_publisherIds_4) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_publisherIds_4, length_publisherIds_4);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_publisherIds_4, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &(*r->out.publisherIds)[cntr_publisherIds_2], length_publisherIds_4, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_3, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherIds_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.publisherIds) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.publisherIds, *r->out.numPublisherIds));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetPublisherListForChannel(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	uint32_t cntr_publisherIds_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetPublisherListForChannel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetPublisherListForChannel");
		ndr->depth++;
		ndr_print_ptr(ndr, "channelName", r->in.channelName);
		ndr->depth++;
		ndr_print_uint16(ndr, "channelName", *r->in.channelName);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetPublisherListForChannel");
		ndr->depth++;
		ndr_print_ptr(ndr, "numPublisherIds", r->out.numPublisherIds);
		ndr->depth++;
		ndr_print_uint32(ndr, "numPublisherIds", *r->out.numPublisherIds);
		ndr->depth--;
		ndr_print_ptr(ndr, "publisherIds", r->out.publisherIds);
		ndr->depth++;
		ndr_print_ptr(ndr, "publisherIds", *r->out.publisherIds);
		ndr->depth++;
		if (*r->out.publisherIds) {
			ndr->print(ndr, "%s: ARRAY(%d)", "publisherIds", (int)*r->out.numPublisherIds);
			ndr->depth++;
			for (cntr_publisherIds_2=0;cntr_publisherIds_2<*r->out.numPublisherIds;cntr_publisherIds_2++) {
				ndr_print_ptr(ndr, "publisherIds", (*r->out.publisherIds)[cntr_publisherIds_2]);
				ndr->depth++;
				if ((*r->out.publisherIds)[cntr_publisherIds_2]) {
					ndr_print_string(ndr, "publisherIds", (*r->out.publisherIds)[cntr_publisherIds_2]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetPublisherMetadata(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.publisherId));
		if (r->in.publisherId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.publisherId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.publisherId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.publisherId, ndr_charset_length(r->in.publisherId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logFilePath));
		if (r->in.logFilePath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logFilePath, ndr_charset_length(r->in.logFilePath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.locale));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.pubMetadataProps == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pubMetadataProps));
		if (r->out.pubMetadata == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.pubMetadata));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetPublisherMetadata(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	uint32_t _ptr_publisherId;
	uint32_t size_publisherId_1 = 0;
	uint32_t length_publisherId_1 = 0;
	uint32_t _ptr_logFilePath;
	uint32_t size_logFilePath_1 = 0;
	uint32_t length_logFilePath_1 = 0;
	TALLOC_CTX *_mem_save_publisherId_0;
	TALLOC_CTX *_mem_save_logFilePath_0;
	TALLOC_CTX *_mem_save_pubMetadataProps_0;
	TALLOC_CTX *_mem_save_pubMetadata_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_publisherId));
		if (_ptr_publisherId) {
			NDR_PULL_ALLOC(ndr, r->in.publisherId);
		} else {
			r->in.publisherId = NULL;
		}
		if (r->in.publisherId) {
			_mem_save_publisherId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.publisherId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.publisherId));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.publisherId));
			size_publisherId_1 = ndr_get_array_size(ndr, &r->in.publisherId);
			if (size_publisherId_1 > MAX_RPC_PUBLISHER_ID_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_publisherId_1 = ndr_get_array_length(ndr, &r->in.publisherId);
			if (length_publisherId_1 > MAX_RPC_PUBLISHER_ID_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_publisherId_1 > size_publisherId_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_publisherId_1, length_publisherId_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_publisherId_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.publisherId, length_publisherId_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_publisherId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logFilePath));
		if (_ptr_logFilePath) {
			NDR_PULL_ALLOC(ndr, r->in.logFilePath);
		} else {
			r->in.logFilePath = NULL;
		}
		if (r->in.logFilePath) {
			_mem_save_logFilePath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logFilePath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logFilePath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logFilePath));
			size_logFilePath_1 = ndr_get_array_size(ndr, &r->in.logFilePath);
			if (size_logFilePath_1 > MAX_RPC_FILE_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_logFilePath_1 = ndr_get_array_length(ndr, &r->in.logFilePath);
			if (length_logFilePath_1 > MAX_RPC_FILE_PATH_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_logFilePath_1 > size_logFilePath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logFilePath_1, length_logFilePath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logFilePath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logFilePath, length_logFilePath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logFilePath_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.locale));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.pubMetadataProps);
		ZERO_STRUCTP(r->out.pubMetadataProps);
		NDR_PULL_ALLOC(ndr, r->out.pubMetadata);
		ZERO_STRUCTP(r->out.pubMetadata);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pubMetadataProps);
		}
		_mem_save_pubMetadataProps_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pubMetadataProps, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pubMetadataProps));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pubMetadataProps_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pubMetadata);
		}
		_mem_save_pubMetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pubMetadata, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.pubMetadata));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pubMetadata_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetPublisherMetadata(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetPublisherMetadata");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetPublisherMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "publisherId", r->in.publisherId);
		ndr->depth++;
		if (r->in.publisherId) {
			ndr_print_string(ndr, "publisherId", r->in.publisherId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "logFilePath", r->in.logFilePath);
		ndr->depth++;
		if (r->in.logFilePath) {
			ndr_print_string(ndr, "logFilePath", r->in.logFilePath);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "locale", r->in.locale);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetPublisherMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "pubMetadataProps", r->out.pubMetadataProps);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "pubMetadataProps", r->out.pubMetadataProps);
		ndr->depth--;
		ndr_print_ptr(ndr, "pubMetadata", r->out.pubMetadata);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pubMetadata", r->out.pubMetadata);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetPublisherResourceMetadata(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.propertyId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.pubMetadataProps == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pubMetadataProps));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetPublisherResourceMetadata(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_pubMetadataProps_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.propertyId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.pubMetadataProps);
		ZERO_STRUCTP(r->out.pubMetadataProps);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pubMetadataProps);
		}
		_mem_save_pubMetadataProps_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pubMetadataProps, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pubMetadataProps));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pubMetadataProps_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetPublisherResourceMetadata(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetPublisherResourceMetadata");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetPublisherResourceMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "propertyId", r->in.propertyId);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetPublisherResourceMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "pubMetadataProps", r->out.pubMetadataProps);
		ndr->depth++;
		ndr_print_eventlog6_EvtRpcVariantList(ndr, "pubMetadataProps", r->out.pubMetadataProps);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetEventMetadataEnum(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pubMetadata == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.pubMetadata));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.reservedForFilter));
		if (r->in.reservedForFilter) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.reservedForFilter, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.reservedForFilter, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.reservedForFilter, ndr_charset_length(r->in.reservedForFilter, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.eventMetaDataEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.eventMetaDataEnum));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetEventMetadataEnum(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	uint32_t _ptr_reservedForFilter;
	uint32_t size_reservedForFilter_1 = 0;
	uint32_t length_reservedForFilter_1 = 0;
	TALLOC_CTX *_mem_save_pubMetadata_0;
	TALLOC_CTX *_mem_save_reservedForFilter_0;
	TALLOC_CTX *_mem_save_eventMetaDataEnum_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pubMetadata);
		}
		_mem_save_pubMetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pubMetadata, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.pubMetadata));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pubMetadata_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_reservedForFilter));
		if (_ptr_reservedForFilter) {
			NDR_PULL_ALLOC(ndr, r->in.reservedForFilter);
		} else {
			r->in.reservedForFilter = NULL;
		}
		if (r->in.reservedForFilter) {
			_mem_save_reservedForFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.reservedForFilter, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.reservedForFilter));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.reservedForFilter));
			size_reservedForFilter_1 = ndr_get_array_size(ndr, &r->in.reservedForFilter);
			if (size_reservedForFilter_1 > MAX_RPC_FILTER_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			length_reservedForFilter_1 = ndr_get_array_length(ndr, &r->in.reservedForFilter);
			if (length_reservedForFilter_1 > MAX_RPC_FILTER_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			if (length_reservedForFilter_1 > size_reservedForFilter_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_reservedForFilter_1, length_reservedForFilter_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_reservedForFilter_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.reservedForFilter, length_reservedForFilter_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reservedForFilter_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.eventMetaDataEnum);
		ZERO_STRUCTP(r->out.eventMetaDataEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventMetaDataEnum);
		}
		_mem_save_eventMetaDataEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventMetaDataEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.eventMetaDataEnum));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventMetaDataEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetEventMetadataEnum(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetEventMetadataEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetEventMetadataEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "pubMetadata", r->in.pubMetadata);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pubMetadata", r->in.pubMetadata);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "reservedForFilter", r->in.reservedForFilter);
		ndr->depth++;
		if (r->in.reservedForFilter) {
			ndr_print_string(ndr, "reservedForFilter", r->in.reservedForFilter);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetEventMetadataEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "eventMetaDataEnum", r->out.eventMetaDataEnum);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "eventMetaDataEnum", r->out.eventMetaDataEnum);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetNextEventMetadata(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	uint32_t cntr_eventMetadataInstances_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.eventMetaDataEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.eventMetaDataEnum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.numRequested));
	}
	if (flags & NDR_OUT) {
		if (r->out.numReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.numReturned));
		if (r->out.eventMetadataInstances == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.eventMetadataInstances));
		if (*r->out.eventMetadataInstances) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.numReturned));
			for (cntr_eventMetadataInstances_2 = 0; cntr_eventMetadataInstances_2 < *r->out.numReturned; cntr_eventMetadataInstances_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS, &(*r->out.eventMetadataInstances)[cntr_eventMetadataInstances_2]));
			}
			for (cntr_eventMetadataInstances_2 = 0; cntr_eventMetadataInstances_2 < *r->out.numReturned; cntr_eventMetadataInstances_2++) {
				NDR_CHECK(ndr_push_eventlog6_EvtRpcVariantList(ndr, NDR_BUFFERS, &(*r->out.eventMetadataInstances)[cntr_eventMetadataInstances_2]));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetNextEventMetadata(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	uint32_t _ptr_eventMetadataInstances;
	uint32_t size_eventMetadataInstances_2 = 0;
	uint32_t cntr_eventMetadataInstances_2;
	TALLOC_CTX *_mem_save_eventMetaDataEnum_0;
	TALLOC_CTX *_mem_save_numReturned_0;
	TALLOC_CTX *_mem_save_eventMetadataInstances_0;
	TALLOC_CTX *_mem_save_eventMetadataInstances_1;
	TALLOC_CTX *_mem_save_eventMetadataInstances_2;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.eventMetaDataEnum);
		}
		_mem_save_eventMetaDataEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.eventMetaDataEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.eventMetaDataEnum));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventMetaDataEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.numRequested));
		NDR_PULL_ALLOC(ndr, r->out.numReturned);
		ZERO_STRUCTP(r->out.numReturned);
		NDR_PULL_ALLOC(ndr, r->out.eventMetadataInstances);
		ZERO_STRUCTP(r->out.eventMetadataInstances);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.numReturned);
		}
		_mem_save_numReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.numReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.numReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_numReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.eventMetadataInstances);
		}
		_mem_save_eventMetadataInstances_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.eventMetadataInstances, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventMetadataInstances));
		if (_ptr_eventMetadataInstances) {
			NDR_PULL_ALLOC(ndr, *r->out.eventMetadataInstances);
		} else {
			*r->out.eventMetadataInstances = NULL;
		}
		if (*r->out.eventMetadataInstances) {
			_mem_save_eventMetadataInstances_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventMetadataInstances, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.eventMetadataInstances));
			size_eventMetadataInstances_2 = ndr_get_array_size(ndr, r->out.eventMetadataInstances);
			if (size_eventMetadataInstances_2 > MAX_RPC_EVENT_METADATA_COUNT) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_PULL_ALLOC_N(ndr, *r->out.eventMetadataInstances, size_eventMetadataInstances_2);
			_mem_save_eventMetadataInstances_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.eventMetadataInstances, 0);
			for (cntr_eventMetadataInstances_2 = 0; cntr_eventMetadataInstances_2 < size_eventMetadataInstances_2; cntr_eventMetadataInstances_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_SCALARS, &(*r->out.eventMetadataInstances)[cntr_eventMetadataInstances_2]));
			}
			for (cntr_eventMetadataInstances_2 = 0; cntr_eventMetadataInstances_2 < size_eventMetadataInstances_2; cntr_eventMetadataInstances_2++) {
				NDR_CHECK(ndr_pull_eventlog6_EvtRpcVariantList(ndr, NDR_BUFFERS, &(*r->out.eventMetadataInstances)[cntr_eventMetadataInstances_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventMetadataInstances_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventMetadataInstances_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventMetadataInstances_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.eventMetadataInstances) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.eventMetadataInstances, *r->out.numReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetNextEventMetadata(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	uint32_t cntr_eventMetadataInstances_2;
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetNextEventMetadata");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetNextEventMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "eventMetaDataEnum", r->in.eventMetaDataEnum);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "eventMetaDataEnum", r->in.eventMetaDataEnum);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "numRequested", r->in.numRequested);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetNextEventMetadata");
		ndr->depth++;
		ndr_print_ptr(ndr, "numReturned", r->out.numReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "numReturned", *r->out.numReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "eventMetadataInstances", r->out.eventMetadataInstances);
		ndr->depth++;
		ndr_print_ptr(ndr, "eventMetadataInstances", *r->out.eventMetadataInstances);
		ndr->depth++;
		if (*r->out.eventMetadataInstances) {
			ndr->print(ndr, "%s: ARRAY(%d)", "eventMetadataInstances", (int)*r->out.numReturned);
			ndr->depth++;
			for (cntr_eventMetadataInstances_2=0;cntr_eventMetadataInstances_2<*r->out.numReturned;cntr_eventMetadataInstances_2++) {
				ndr_print_eventlog6_EvtRpcVariantList(ndr, "eventMetadataInstances", &(*r->out.eventMetadataInstances)[cntr_eventMetadataInstances_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog6_EvtRpcGetClassicLogDisplayName(struct ndr_push *ndr, int flags, const struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.logName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logName, ndr_charset_length(r->in.logName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.locale));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.displayName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.displayName));
		if (*r->out.displayName) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, **r->out.displayName));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog6_EvtRpcGetClassicLogDisplayName(struct ndr_pull *ndr, int flags, struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	uint32_t size_logName_1 = 0;
	uint32_t length_logName_1 = 0;
	uint32_t _ptr_displayName;
	TALLOC_CTX *_mem_save_displayName_0;
	TALLOC_CTX *_mem_save_displayName_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logName));
		size_logName_1 = ndr_get_array_size(ndr, &r->in.logName);
		if (size_logName_1 < 1 || size_logName_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		length_logName_1 = ndr_get_array_length(ndr, &r->in.logName);
		if (length_logName_1 < 1 || length_logName_1 > MAX_RPC_CHANNEL_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (length_logName_1 > size_logName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logName_1, length_logName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logName, length_logName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.locale));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.displayName);
		ZERO_STRUCTP(r->out.displayName);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.displayName);
		}
		_mem_save_displayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.displayName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_displayName));
		if (_ptr_displayName) {
			NDR_PULL_ALLOC(ndr, *r->out.displayName);
		} else {
			*r->out.displayName = NULL;
		}
		if (*r->out.displayName) {
			_mem_save_displayName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.displayName, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, *r->out.displayName));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_displayName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_displayName_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog6_EvtRpcGetClassicLogDisplayName(struct ndr_print *ndr, const char *name, int flags, const struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	ndr_print_struct(ndr, name, "eventlog6_EvtRpcGetClassicLogDisplayName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog6_EvtRpcGetClassicLogDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "logName", r->in.logName);
		ndr->depth++;
		ndr_print_string(ndr, "logName", r->in.logName);
		ndr->depth--;
		ndr_print_uint32(ndr, "locale", r->in.locale);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog6_EvtRpcGetClassicLogDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "displayName", r->out.displayName);
		ndr->depth++;
		ndr_print_ptr(ndr, "displayName", *r->out.displayName);
		ndr->depth++;
		if (*r->out.displayName) {
			ndr_print_uint16(ndr, "displayName", **r->out.displayName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call eventlog6_calls[] = {
	{
		"eventlog6_EvtRpcRegisterRemoteSubscription",
		sizeof(struct eventlog6_EvtRpcRegisterRemoteSubscription),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRegisterRemoteSubscription,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRegisterRemoteSubscription,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRegisterRemoteSubscription,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRemoteSubscriptionNextAsync",
		sizeof(struct eventlog6_EvtRpcRemoteSubscriptionNextAsync),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRemoteSubscriptionNextAsync,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRemoteSubscriptionNextAsync,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRemoteSubscriptionNextAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRemoteSubscriptionNext",
		sizeof(struct eventlog6_EvtRpcRemoteSubscriptionNext),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRemoteSubscriptionNext,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRemoteSubscriptionNext,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRemoteSubscriptionNext,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRemoteSubscriptionWaitAsync",
		sizeof(struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRemoteSubscriptionWaitAsync,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRemoteSubscriptionWaitAsync,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRemoteSubscriptionWaitAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRegisterControllableOperation",
		sizeof(struct eventlog6_EvtRpcRegisterControllableOperation),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRegisterControllableOperation,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRegisterControllableOperation,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRegisterControllableOperation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRegisterLogQuery",
		sizeof(struct eventlog6_EvtRpcRegisterLogQuery),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRegisterLogQuery,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRegisterLogQuery,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRegisterLogQuery,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcClearLog",
		sizeof(struct eventlog6_EvtRpcClearLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcClearLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcClearLog,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcClearLog,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcExportLog",
		sizeof(struct eventlog6_EvtRpcExportLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcExportLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcExportLog,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcExportLog,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcLocalizeExportLog",
		sizeof(struct eventlog6_EvtRpcLocalizeExportLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcLocalizeExportLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcLocalizeExportLog,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcLocalizeExportLog,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcMessageRender",
		sizeof(struct eventlog6_EvtRpcMessageRender),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcMessageRender,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcMessageRender,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcMessageRender,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcMessageRenderDefault",
		sizeof(struct eventlog6_EvtRpcMessageRenderDefault),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcMessageRenderDefault,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcMessageRenderDefault,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcMessageRenderDefault,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcQueryNext",
		sizeof(struct eventlog6_EvtRpcQueryNext),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcQueryNext,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcQueryNext,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcQueryNext,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcQuerySeek",
		sizeof(struct eventlog6_EvtRpcQuerySeek),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcQuerySeek,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcQuerySeek,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcQuerySeek,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcClose",
		sizeof(struct eventlog6_EvtRpcClose),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcClose,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcClose,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcClose,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcCancel",
		sizeof(struct eventlog6_EvtRpcCancel),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcCancel,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcCancel,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcCancel,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcAssertConfig",
		sizeof(struct eventlog6_EvtRpcAssertConfig),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcAssertConfig,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcAssertConfig,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcAssertConfig,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcRetractConfig",
		sizeof(struct eventlog6_EvtRpcRetractConfig),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcRetractConfig,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcRetractConfig,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcRetractConfig,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcOpenLogHandle",
		sizeof(struct eventlog6_EvtRpcOpenLogHandle),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcOpenLogHandle,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcOpenLogHandle,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcOpenLogHandle,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetLogFileInfo",
		sizeof(struct eventlog6_EvtRpcGetLogFileInfo),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetLogFileInfo,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetLogFileInfo,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetLogFileInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetChannelList",
		sizeof(struct eventlog6_EvtRpcGetChannelList),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetChannelList,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetChannelList,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetChannelList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetChannelConfig",
		sizeof(struct eventlog6_EvtRpcGetChannelConfig),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetChannelConfig,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetChannelConfig,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetChannelConfig,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcPutChannelConfig",
		sizeof(struct eventlog6_EvtRpcPutChannelConfig),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcPutChannelConfig,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcPutChannelConfig,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcPutChannelConfig,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetPublisherList",
		sizeof(struct eventlog6_EvtRpcGetPublisherList),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetPublisherList,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetPublisherList,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetPublisherList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetPublisherListForChannel",
		sizeof(struct eventlog6_EvtRpcGetPublisherListForChannel),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetPublisherListForChannel,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetPublisherListForChannel,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetPublisherListForChannel,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetPublisherMetadata",
		sizeof(struct eventlog6_EvtRpcGetPublisherMetadata),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetPublisherMetadata,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetPublisherMetadata,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetPublisherMetadata,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetPublisherResourceMetadata",
		sizeof(struct eventlog6_EvtRpcGetPublisherResourceMetadata),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetPublisherResourceMetadata,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetPublisherResourceMetadata,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetPublisherResourceMetadata,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetEventMetadataEnum",
		sizeof(struct eventlog6_EvtRpcGetEventMetadataEnum),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetEventMetadataEnum,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetEventMetadataEnum,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetEventMetadataEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetNextEventMetadata",
		sizeof(struct eventlog6_EvtRpcGetNextEventMetadata),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetNextEventMetadata,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetNextEventMetadata,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetNextEventMetadata,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog6_EvtRpcGetClassicLogDisplayName",
		sizeof(struct eventlog6_EvtRpcGetClassicLogDisplayName),
		(ndr_push_flags_fn_t) ndr_push_eventlog6_EvtRpcGetClassicLogDisplayName,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog6_EvtRpcGetClassicLogDisplayName,
		(ndr_print_function_t) ndr_print_eventlog6_EvtRpcGetClassicLogDisplayName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const eventlog6_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
};

static const struct ndr_interface_string_array eventlog6_endpoints = {
	.count	= 1,
	.names	= eventlog6_endpoint_strings
};

static const char * const eventlog6_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array eventlog6_authservices = {
	.count	= 1,
	.names	= eventlog6_authservice_strings
};


const struct ndr_interface_table ndr_table_eventlog6 = {
	.name		= "eventlog6",
	.syntax_id	= {
		{0xf6beaff7,0x1e19,0x4fbb,{0x9f,0x8f},{0xb8,0x9e,0x20,0x18,0x33,0x7c}},
		NDR_EVENTLOG6_VERSION
	},
	.helpstring	= NDR_EVENTLOG6_HELPSTRING,
	.num_calls	= 29,
	.calls		= eventlog6_calls,
	.endpoints	= &eventlog6_endpoints,
	.authservices	= &eventlog6_authservices
};

