#!/usr/bin/python

import os
import sys, os.path
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

import unittest
from lpltk                import LaunchpadService

class TestBug(unittest.TestCase):

    # setUp
    #
    def setUp(self):
        self.configuration = {}
        self.configuration['launchpad_services_root'] = 'staging'

    # test__init__
    #
    def test__init__(self):
        # Basic instance creation. 
        #
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(3)
        except:
            self.assertTrue(False)
        finally:
            bug = None
            ls  = None

    # test_get_title
    #
    def test_get_title(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            title = bug.title
            self.assertEqual(title, 'Custom information for each translation team')
        finally:
            bug = None
            ls  = None

    # test_set_title
    #
    def test_set_title(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            original_title = bug.title
            bug.title = "Testing Bug.title property"
            self.assertEqual(bug.title, 'Testing Bug.title property')
            bug.title = original_title
            self.assertEqual(bug.title, original_title)
        finally:
            bug = None
            ls  = None

    # test_get_description
    #
    def test_get_description(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            description = bug.description
            if "It would be nice if we could easily add *MUST READ* type of links" not in description:
                self.assertTrue(False)
        finally:
            bug = None
            ls  = None

    # test_set_description
    #
    def test_set_description(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            original_description = bug.description
            bug.description = "Testing Bug.title property"
            self.assertEqual(bug.description, 'Testing Bug.title property')
            bug.description = original_description
            self.assertEqual(bug.description, original_description)
        finally:
            bug = None
            ls  = None

    # test_owner_full_name
    #
    def test_owner_full_name(self):
        ls    = LaunchpadService(self.configuration)
        bug   = ls.get_bug(3)
        self.assertEqual("Jordi Mallach", bug.owner.full_name)

    # test_owner_first_name
    #
    def test_owner_first_name(self):
        ls    = LaunchpadService(self.configuration)
        bug   = ls.get_bug(3)
        self.assertEqual("Jordi", bug.owner.first_name)

if __name__ == '__main__':
    unittest.main()

# vi:set ts=4 sw=4 expandtab:
