import mox

from django import test
from django.conf import settings
from django.contrib.auth import models as auth_models
from django_nova import adminclient
from django_nova import manager
from django_nova import shortcuts


TEST_PROJECT = 'test'
TEST_USER = 'test'
TEST_REGION = 'test'


class BaseProjectViewTests(test.TestCase):
    def setUp(self):
        project = adminclient.ProjectInfo()
        project.projectname = TEST_PROJECT
        project.projectManagerId = TEST_USER

        self.mox = mox.Mox()
        self.user = auth_models.User.objects.create_user(TEST_USER,
                                                         'test@test.com',
                                                         password='test')
        login = self.client.login(username=TEST_USER, password='test')
        self.failUnless(login, 'Unable to login')

        self.region = adminclient.RegionInfo(name=TEST_REGION,
                                             endpoint='http://test:8773/')
        self.project = manager.ProjectManager(self.user.username,
                                              project,
                                              self.region)
        self.mox.StubOutWithMock(shortcuts, 'get_project_or_404')
        shortcuts.get_project_or_404(mox.IgnoreArg(),
                                     'test').AndReturn(self.project)

    def tearDown(self):
        self.mox.UnsetStubs()

    def assertRedirectsNoFollow(self, response, expected_url):
        self.assertEqual(response._headers['location'],
                         ('Location', settings.TESTSERVER + expected_url))
        self.assertEqual(response.status_code, 302)

    def create_key_pair_choices(self, key_names):
        return [(k, k) for k in key_names]

    def create_instance_type_choices(self):
        return [('m1.medium', 'm1.medium'),
                ('m1.large', 'm1.large')]
