#include "feedback.h"

#include <QGraphicsLinearLayout>
#include <QUrl>

#include <Plasma/Meter>
#include <Plasma/WebView>

Feedback::Feedback( QObject *parent, const QVariantList &args )
    : Plasma::PopupApplet( parent, args ),
    m_layout( 0 ),
    m_graphicsWidget( 0 )
{
    setBackgroundHints( DefaultBackground );
    setAspectRatioMode( Plasma::IgnoreAspectRatio );
    resize( 550, 550 );
    setPopupIcon( "kubuntu" );
}

Feedback::~Feedback()
{
    if ( hasFailedToLaunch() )
    {
	kDebug() << "failed to launch";
    }
}

void Feedback::init()
{
    m_url = QUrl( "http://static.nixternal.com/feedback.php" );
    m_command = "/usr/bin/lsb_release -d";

    graphicsWidget();

    executeCommand();
}

QGraphicsWidget* Feedback::graphicsWidget()
{
    if ( m_graphicsWidget )
	return m_graphicsWidget;

    m_layout = new QGraphicsLinearLayout( Qt::Vertical, m_graphicsWidget );

    m_graphicsWidget = new QGraphicsWidget( this );
    m_graphicsWidget->setMinimumSize( 550, 550 );

    m_webView = new Plasma::WebView( this );

    m_meter = new Plasma::Meter;
    m_meter->setMinimum( 0 );
    m_meter->setMaximum( 100 );
    m_meter->setMeterType( Plasma::Meter::BarMeterHorizontal );
    m_meter->setMaximumHeight( 20 );

    m_layout->addItem( m_webView );
    m_layout->addItem( m_meter );

    m_graphicsWidget->setLayout( m_layout );

    connect( m_webView, SIGNAL( loadProgress( int ) ), this, SLOT( updateMeter( int ) ) );

    return m_graphicsWidget;
}

void Feedback::updateMeter( int progress )
{
    m_meter->setValue( progress );
}

void Feedback::executeCommand()
{
    m_proc.setOutputChannelMode( KProcess::MergedChannels );
    connect( &m_proc, SIGNAL( readyReadStandardOutput() ), SLOT( gotStdOut() ) );
    connect( &m_proc, SIGNAL( finished( int ) ), SLOT( loadUrl() ) );

    if ( m_command.isEmpty() || m_proc.state() != QProcess::NotRunning )
	return;

    m_proc.setShellCommand( m_command );

    m_proc.start();
}

void Feedback::gotStdOut()
{
    m_output = QString::fromUtf8( m_proc.readAllStandardOutput() );
    m_output = m_output.split( " " )[ 1 ];
}

void Feedback::loadUrl()
{
    m_url.addQueryItem( "ver", m_output );
    m_webView->setUrl( m_url );
}

#include "feedback.moc"
