/*
 *  Copyright (C) 2005 Geffrey Velasquez Torres <geffrey@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: header,v 1.15 2004/01/08 16:46:52 sniper Exp $ */

#ifndef PHP_CLAMAV_H
#define PHP_CLAMAV_H

extern zend_module_entry clamav_module_entry;
#define phpext_clamav_ptr &clamav_module_entry

#ifdef PHP_WIN32
#define PHP_CLAMAV_API __declspec(dllexport)
#else
#define PHP_CLAMAV_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

#if PHP_MAJOR_VERSION < 5
#define OnUpdateLong OnUpdateInt
#endif

#define PHP_CLAMAV_VERSION "0.12"

PHP_MINIT_FUNCTION(clamav);
PHP_MSHUTDOWN_FUNCTION(clamav);
PHP_RINIT_FUNCTION(clamav);
PHP_RSHUTDOWN_FUNCTION(clamav);
PHP_MINFO_FUNCTION(clamav);

/* functions */
PHP_FUNCTION(cl_info);
PHP_FUNCTION(cl_scanfile);
PHP_FUNCTION(cl_setlimits);
PHP_FUNCTION(cl_scanfile_ex);
PHP_FUNCTION(cl_pretcode);

/* compatibility functions */
PHP_FUNCTION(clam_scan_file);
PHP_FUNCTION(clam_get_version);


ZEND_BEGIN_MODULE_GLOBALS(clamav)
	char *dbpath;		 /* virus database path */ 
	long maxreclevel;    /* maximal recursion level */
	long maxfiles;       /* maximal number of file to be
					      * scanned within an archive
					      */
	long archivememlim;  /* limit memory usage for bzip2 (0/1) */ 
	long maxfilesize;    /* files in an archive larger than
						  * this limit will not be scanned
						  */
	long maxratio;	 	 /* maximal compression ratio */

ZEND_END_MODULE_GLOBALS(clamav)


/* In every utility function you add that needs to use variables 
   in php_clamav_globals, call TSRMLS_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as CLAMAV_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define CLAMAV_G(v) TSRMG(clamav_globals_id, zend_clamav_globals *, v)
#else
#define CLAMAV_G(v) (clamav_globals.v)
#endif

#endif	/* PHP_CLAMAV_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
