<?php

/*
 * Copyright (c) 2008-2010 Guillaume Lelarge <guillaume@lelarge.info>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

$buffer = $navigate_stats.'
<div id="pgContentWrap">

<h1>Cache Hit Ratio</h1>
';

$query = "SELECT datname,
  blks_read,
  blks_hit,
  round((blks_hit::float/(blks_read+blks_hit+1)*100)::numeric, 2) as cachehitratio
FROM pg_stat_database
ORDER BY datname, cachehitratio";

$rows = pg_query($connection, $query);
if (!$rows) {
  echo "An error occured.\n";
  exit;
}

$buffer .= '<div class="tblBasic">

<table border="0" cellpadding="0" cellspacing="0" class="tblBasicGrey">
<tr>
  <th class="colFirst" width="40%">Database Name</th>
  <th class="colMid" width="20%">Blocks Read</th>
  <th class="colMid" width="20%">Blocks Hit</th>
  <th class="colLast" width="20%">Cache Hit Ratio (%)</th>
</tr>
';

while ($row = pg_fetch_array($rows)) {
$buffer .= tr()."
  <td title=\"".$comments['databases'][$row['datname']]."\">";
if ($row['blks_read'] >= $row['blks_hit'] && $row['blks_read']+$row['blks_hit'] > 0) {
  $buffer .= '<span class="txtImportant">';
}
$buffer .= $row['datname'];
if ($row['blks_read'] >= $row['blks_hit']) {
  $buffer .= '</span>';
}
$buffer .= "</td>
  <td>".$row['blks_read']."</td>
  <td>".$row['blks_hit']."</td>
  <td>".$row['cachehitratio']."</td>
</tr>";
}

$buffer .= '</table>
</div>
';

$buffer .= '<button id="showthesource">Show SQL commands!</button>
<div id="source">
<p>'.$query.'</p>
</div>';

$filename = $outputdir.'/cachehitratio.html';
include 'lib/fileoperations.php';

?>
