/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ContourOpAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ContourOpAttributes::ContourMethod
//

static const char *ContourMethod_strings[] = {
"Level", "Value", "Percent"
};

std::string
ContourOpAttributes::ContourMethod_ToString(ContourOpAttributes::ContourMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ContourMethod_strings[index];
}

std::string
ContourOpAttributes::ContourMethod_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ContourMethod_strings[index];
}

bool
ContourOpAttributes::ContourMethod_FromString(const std::string &s, ContourOpAttributes::ContourMethod &val)
{
    val = ContourOpAttributes::Level;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ContourMethod_strings[i])
        {
            val = (ContourMethod)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ContourOpAttributes::ContourScaling
//

static const char *ContourScaling_strings[] = {
"Linear", "Log"};

std::string
ContourOpAttributes::ContourScaling_ToString(ContourOpAttributes::ContourScaling t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ContourScaling_strings[index];
}

std::string
ContourOpAttributes::ContourScaling_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ContourScaling_strings[index];
}

bool
ContourOpAttributes::ContourScaling_FromString(const std::string &s, ContourOpAttributes::ContourScaling &val)
{
    val = ContourOpAttributes::Linear;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ContourScaling_strings[i])
        {
            val = (ContourScaling)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *ContourOpAttributes::TypeMapFormatString = "id*d*ibbddis";

// ****************************************************************************
// Method: ContourOpAttributes::ContourOpAttributes
//
// Purpose: 
//   Constructor for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContourOpAttributes::ContourOpAttributes() : 
    AttributeSubject(ContourOpAttributes::TypeMapFormatString)
{
    contourNLevels = 10;
    minFlag = false;
    maxFlag = false;
    min = 0;
    max = 1;
    variable = "default";
}

// ****************************************************************************
// Method: ContourOpAttributes::ContourOpAttributes
//
// Purpose: 
//   Copy constructor for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContourOpAttributes::ContourOpAttributes(const ContourOpAttributes &obj) : 
    AttributeSubject(ContourOpAttributes::TypeMapFormatString)
{
    contourNLevels = obj.contourNLevels;
    contourValue = obj.contourValue;
    contourPercent = obj.contourPercent;
    contourMethod = obj.contourMethod;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    min = obj.min;
    max = obj.max;
    scaling = obj.scaling;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: ContourOpAttributes::~ContourOpAttributes
//
// Purpose: 
//   Destructor for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContourOpAttributes::~ContourOpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ContourOpAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContourOpAttributes& 
ContourOpAttributes::operator = (const ContourOpAttributes &obj)
{
    if (this == &obj) return *this;
    contourNLevels = obj.contourNLevels;
    contourValue = obj.contourValue;
    contourPercent = obj.contourPercent;
    contourMethod = obj.contourMethod;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    min = obj.min;
    max = obj.max;
    scaling = obj.scaling;
    variable = obj.variable;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ContourOpAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContourOpAttributes::operator == (const ContourOpAttributes &obj) const
{
    // Create the return value
    return ((contourNLevels == obj.contourNLevels) &&
            (contourValue == obj.contourValue) &&
            (contourPercent == obj.contourPercent) &&
            (contourMethod == obj.contourMethod) &&
            (minFlag == obj.minFlag) &&
            (maxFlag == obj.maxFlag) &&
            (min == obj.min) &&
            (max == obj.max) &&
            (scaling == obj.scaling) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: ContourOpAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContourOpAttributes::operator != (const ContourOpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ContourOpAttributes::TypeName
//
// Purpose: 
//   Type name method for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ContourOpAttributes::TypeName() const
{
    return "ContourOpAttributes";
}

// ****************************************************************************
// Method: ContourOpAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContourOpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ContourOpAttributes *tmp = (const ContourOpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ContourOpAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContourOpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ContourOpAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ContourOpAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ContourOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContourOpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ContourOpAttributes(*this);
    else
        retval = new ContourOpAttributes;

    return retval;
}

// ****************************************************************************
// Method: ContourOpAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ContourOpAttributes::SelectAll()
{
    Select(ID_contourNLevels, (void *)&contourNLevels);
    Select(ID_contourValue,   (void *)&contourValue);
    Select(ID_contourPercent, (void *)&contourPercent);
    Select(ID_contourMethod,  (void *)&contourMethod);
    Select(ID_minFlag,        (void *)&minFlag);
    Select(ID_maxFlag,        (void *)&maxFlag);
    Select(ID_min,            (void *)&min);
    Select(ID_max,            (void *)&max);
    Select(ID_scaling,        (void *)&scaling);
    Select(ID_variable,       (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContourOpAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContourOpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ContourOpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ContourOpAttributes.
    DataNode *node = new DataNode("ContourOpAttributes");

    if(completeSave || !FieldsEqual(ID_contourNLevels, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourNLevels", contourNLevels));
    }

    if(completeSave || !FieldsEqual(ID_contourValue, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourValue", contourValue));
    }

    if(completeSave || !FieldsEqual(ID_contourPercent, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourPercent", contourPercent));
    }

    if(completeSave || !FieldsEqual(ID_contourMethod, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourMethod", ContourMethod_ToString(contourMethod)));
    }

    if(completeSave || !FieldsEqual(ID_minFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(ID_maxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(ID_min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(ID_max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(ID_scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", ContourScaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ContourOpAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ContourOpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ContourOpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("contourNLevels")) != 0)
        SetContourNLevels(node->AsInt());
    if((node = searchNode->GetNode("contourValue")) != 0)
        SetContourValue(node->AsDoubleVector());
    if((node = searchNode->GetNode("contourPercent")) != 0)
        SetContourPercent(node->AsDoubleVector());
    if((node = searchNode->GetNode("contourMethod")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetContourMethod(ContourMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ContourMethod value;
            if(ContourMethod_FromString(node->AsString(), value))
                SetContourMethod(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetScaling(ContourScaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ContourScaling value;
            if(ContourScaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ContourOpAttributes::SetContourNLevels(int contourNLevels_)
{
    contourNLevels = contourNLevels_;
    Select(ID_contourNLevels, (void *)&contourNLevels);
}

void
ContourOpAttributes::SetContourValue(const doubleVector &contourValue_)
{
    contourValue = contourValue_;
    Select(ID_contourValue, (void *)&contourValue);
}

void
ContourOpAttributes::SetContourPercent(const doubleVector &contourPercent_)
{
    contourPercent = contourPercent_;
    Select(ID_contourPercent, (void *)&contourPercent);
}

void
ContourOpAttributes::SetContourMethod(ContourOpAttributes::ContourMethod contourMethod_)
{
    contourMethod = contourMethod_;
    Select(ID_contourMethod, (void *)&contourMethod);
}

void
ContourOpAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(ID_minFlag, (void *)&minFlag);
}

void
ContourOpAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(ID_maxFlag, (void *)&maxFlag);
}

void
ContourOpAttributes::SetMin(double min_)
{
    min = min_;
    Select(ID_min, (void *)&min);
}

void
ContourOpAttributes::SetMax(double max_)
{
    max = max_;
    Select(ID_max, (void *)&max);
}

void
ContourOpAttributes::SetScaling(ContourOpAttributes::ContourScaling scaling_)
{
    scaling = scaling_;
    Select(ID_scaling, (void *)&scaling);
}

void
ContourOpAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
ContourOpAttributes::GetContourNLevels() const
{
    return contourNLevels;
}

const doubleVector &
ContourOpAttributes::GetContourValue() const
{
    return contourValue;
}

doubleVector &
ContourOpAttributes::GetContourValue()
{
    return contourValue;
}

const doubleVector &
ContourOpAttributes::GetContourPercent() const
{
    return contourPercent;
}

doubleVector &
ContourOpAttributes::GetContourPercent()
{
    return contourPercent;
}

ContourOpAttributes::ContourMethod
ContourOpAttributes::GetContourMethod() const
{
    return ContourMethod(contourMethod);
}

bool
ContourOpAttributes::GetMinFlag() const
{
    return minFlag;
}

bool
ContourOpAttributes::GetMaxFlag() const
{
    return maxFlag;
}

double
ContourOpAttributes::GetMin() const
{
    return min;
}

double
ContourOpAttributes::GetMax() const
{
    return max;
}

ContourOpAttributes::ContourScaling
ContourOpAttributes::GetScaling() const
{
    return ContourScaling(scaling);
}

const std::string &
ContourOpAttributes::GetVariable() const
{
    return variable;
}

std::string &
ContourOpAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ContourOpAttributes::SelectContourValue()
{
    Select(ID_contourValue, (void *)&contourValue);
}

void
ContourOpAttributes::SelectContourPercent()
{
    Select(ID_contourPercent, (void *)&contourPercent);
}

void
ContourOpAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContourOpAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ContourOpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_contourNLevels: return "contourNLevels";
    case ID_contourValue:   return "contourValue";
    case ID_contourPercent: return "contourPercent";
    case ID_contourMethod:  return "contourMethod";
    case ID_minFlag:        return "minFlag";
    case ID_maxFlag:        return "maxFlag";
    case ID_min:            return "min";
    case ID_max:            return "max";
    case ID_scaling:        return "scaling";
    case ID_variable:       return "variable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContourOpAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ContourOpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_contourNLevels: return FieldType_int;
    case ID_contourValue:   return FieldType_doubleVector;
    case ID_contourPercent: return FieldType_doubleVector;
    case ID_contourMethod:  return FieldType_enum;
    case ID_minFlag:        return FieldType_bool;
    case ID_maxFlag:        return FieldType_bool;
    case ID_min:            return FieldType_double;
    case ID_max:            return FieldType_double;
    case ID_scaling:        return FieldType_enum;
    case ID_variable:       return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ContourOpAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ContourOpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_contourNLevels: return "int";
    case ID_contourValue:   return "doubleVector";
    case ID_contourPercent: return "doubleVector";
    case ID_contourMethod:  return "enum";
    case ID_minFlag:        return "bool";
    case ID_maxFlag:        return "bool";
    case ID_min:            return "double";
    case ID_max:            return "double";
    case ID_scaling:        return "enum";
    case ID_variable:       return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContourOpAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContourOpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ContourOpAttributes &obj = *((const ContourOpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_contourNLevels:
        {  // new scope
        retval = (contourNLevels == obj.contourNLevels);
        }
        break;
    case ID_contourValue:
        {  // new scope
        retval = (contourValue == obj.contourValue);
        }
        break;
    case ID_contourPercent:
        {  // new scope
        retval = (contourPercent == obj.contourPercent);
        }
        break;
    case ID_contourMethod:
        {  // new scope
        retval = (contourMethod == obj.contourMethod);
        }
        break;
    case ID_minFlag:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case ID_maxFlag:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case ID_min:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case ID_max:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case ID_scaling:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

