/*=========================================================================

  Program:   ParaView
  Module:    $RCSfile$

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkMarkSelectedRows
// .SECTION Description
// vtkMarkSelectedRows is used by vtkSpreadSheetView to marks rows from the
// vtkTable generated by vtkSortedTableStreamer or vtkBlockDeliveryPreprocessor
// as selected (done by adding a new vtkCharArray named "__vtkIsSelected__").
// It has two input ports:
// \li 0 : vtkTable
// \li 1 : vtkTable (the extracted selection).

#ifndef __vtkMarkSelectedRows_h
#define __vtkMarkSelectedRows_h

#include "vtkTableAlgorithm.h"

class VTK_EXPORT vtkMarkSelectedRows : public vtkTableAlgorithm
{
public:
  static vtkMarkSelectedRows* New();
  vtkTypeMacro(vtkMarkSelectedRows, vtkTableAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Select the field to process. Only selection associated with the chosen
  // field are considered.
  // Accepted values are
  // \li vtkDataObject::FIELD_ASSOCIATION_POINTS,
  // \li vtkDataObject::FIELD_ASSOCIATION_CELLS,
  // \li vtkDataObject::FIELD_ASSOCIATION_NONE,
  // \li vtkDataObject::FIELD_ASSOCIATION_VERTICES,
  // \li vtkDataObject::FIELD_ASSOCIATION_EDGES,
  // \li vtkDataObject::FIELD_ASSOCIATION_ROWS
  // If value is vtkDataObject::FIELD_ASSOCIATION_NONE, then FieldData
  // associated with the input dataobject is extracted.
  vtkSetMacro(FieldAssociation, int);
  vtkGetMacro(FieldAssociation, int);

//BTX
protected:
  vtkMarkSelectedRows();
  ~vtkMarkSelectedRows();

  virtual int FillInputPortInformation(int port, vtkInformation* info);
  virtual int RequestData(vtkInformation*,
                          vtkInformationVector**,
                          vtkInformationVector*);

  int FieldAssociation;
private:
  vtkMarkSelectedRows(const vtkMarkSelectedRows&); // Not implemented
  void operator=(const vtkMarkSelectedRows&); // Not implemented
//ETX
};

#endif
