# Hadoop Pseudo Conf


class hadoop_pseudo(
  $namenode = $ipaddress_eth0, 
  $jobtracker = $ipaddress_eth0, 
  $hdfsdatadir = '/var/lib/hadoop-0.20/dfs/data') 
{

  apt::ppa{"ppa:canonical-sig/thirdparty":}

  debconf::set_selection{ "namenode":
    selection => "hadoop/namenode", 
    value_type => "string", 
    value => $namenode,
    require => Apt::Ppa["ppa:canonical-sig/thirdparty"]
  }

  debconf::set_selection{ "jobtracker":
    selection => "hadoop/jobtracker", 
    value_type => "string", 
    value => $jobtracker,
    require => Debconf::Set_selection["namenode"],
  }

  debconf::set_selection{ "hdfsdatadir": 
    selection => "hadoop/hdfsdatadir", 
    value_type => "string", 
    value => $hdfsdatadir,
    require => Debconf::Set_selection["jobtracker"],
  }

  package{"hadoop-0.20-conf-pseudo": ensure => installed, require => Debconf::Set_selection["hdfsdatadir"],}

}
