# Hadoop Master Node


class hadoop_master(
  $clustername = $uniqueid, 
  $namenode = $ipaddress_eth0, 
  $jobtracker = $ipaddress_eth0, 
  $hdfsdatadir = '/var/lib/hadoop-0.20/dfs/data') 
{

  apt::ppa{"ppa:canonical-sig/thirdparty":}

  debconf::set_selection{ "namenode":
    selection => "hadoop/namenode", 
    value_type => "string", 
    value => $namenode,
    require => Apt::Ppa["ppa:canonical-sig/thirdparty"],
  }
 
  debconf::set_selection{ "jobtracker":
    selection => "hadoop/jobtracker", 
    value_type => "string", 
    value => $jobtracker,
    require => Debconf::Set_Selection["namenode"],
  }

  debconf::set_selection{ "hdfsdatadir": 
    selection => "hadoop/hdfsdatadir", 
    value_type => "string", 
    value => $hdfsdatadir,
    require => Debconf::Set_Selection["jobtracker"],
  }

  exec{"create_cluster_data_dir":
    command => "mkdir -p /etc/hadoop/cluster_data/${clustername}",
    unless => "test -d /etc/hadoop/cluster_data/${clustername}",
  }

  @@file{ "/etc/hadoop/cluster_data/${clustername}/namenode.cluster_data":
    content => "${namenode}", 
    tag => "hadoop_${clustername}",
    ensure => present,
    require => Exec["create_cluster_data_dir"],
  }

  @@file{ "/etc/hadoop/cluster_data/${clustername}/jobtracker.cluster_data":
    content => "${jobtracker}", 
    tag => "hadoop_${clustername}",
    ensure => present,
    require => Exec["create_cluster_data_dir"],
  }

  @@file{ "/etc/hadoop/cluster_data/${clustername}/hdfsdatadir.cluster_data":
    content => "${hdfsdatadir}", 
    tag => "hadoop_${clustername}",
    ensure => present,
    require => Exec["create_cluster_data_dir"],
  }

  package{"hadoop-0.20-namenode": ensure => installed, require => Debconf::Set_Selection["hdfsdatadir"]}

  package{"hadoop-0.20-jobtracker": ensure => installed, require => Package["hadoop-0.20-namenode"]}

}