#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90015);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-0080");
 name["english"] = "Mini-Redirector Heap Overflow Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probably affected by the vulnerability described in
CVE-2008-0080


Impact
    Heap-based buffer overflow in the WebDAV Mini-Redirector
    in Microsoft Windows XP SP2, Server 2003 SP1 and SP2,
    and Vista allows remote attackers to execute arbitrary
    code via a crafted WebDAV response.

References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0080
    http://www.microsoft.com/technet/security/bulletin/ms08-007.mspx


Workarounds
    Disable the WebClient Service.


Solution:
    All Users should upgrade to the latest version.


Risk factor : High";

 script_description(english:desc["english"]);
 summary["english"] = "Mini-Redirector Heap Overflow Vulnerability";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#

local_var os;

include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

  win_dir = get_windir();
  if( !isnull(win_dir) ) {
    os = get_kb_item("SMB/OS");
    filespec = win_dir+"system32\drivers\mrxdav.sys";
    test_version = NULL;
    if( "WINDOWS VISTA" >< os ) {
      test_version = "6.0.6000.16626";
    } else {
      if( "WINDOWS 5.1" >< os ) {
        test_version = "5.1.2600.3276";
      } else {
        if( "WINDOWS SERVER 2003" >< os ) {
          if( "SERVICE PACK 2" >< os ) {
            test_version = "5.2.3790.4206";
          } else {
	    test_version = "5.2.3790.3060";
          }
        }
      }
    }
    if( !isnull(test_version) ) {
      r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
      if( !isnull(r) ) {
        tmp_filename = get_tmp_dir()+"tmpfile"+rand();
        orig_filename = filespec;
        if( smbgetfile(share: "C$", filename: orig_filename, tmp_filename: tmp_filename) ) {
          v = GetPEFileVersion(tmp_filename:tmp_filename, orig_filename:orig_filename);
          unlink(tmp_filename);
          if( version_is_less(version: v, test_version: test_version) ) {
            security_hole(port:0, proto:"Win");
            report = report + "Fileversion : C$ "+orig_filename + " "+v+string("\n");
            security_hole(port:0, proto:"Win", data:report);
          }
        } else {
          report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
          security_note(port:0, proto:"SMB", data:report);
        }
      } else {
        report = string(filespec+" not found/no access -> "+get_kb_item("SMB/ERROR")) + string("\n");
        security_note(port:0, proto:"SMB", data:report);
      }
    }
  }

exit(0);
