# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-730-1 (libpng)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63513);
 script_cve_id("CVE-2007-5268", "CVE-2007-5269", "CVE-2008-1382", "CVE-2008-3964", "CVE-2008-5907", "CVE-2009-0040");
 script_version ("$");
 name["english"] = "Ubuntu USN-730-1 (libpng)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libpng
announced via advisory USN-730-1.

Details follow:

It was discovered that libpng did not properly perform bounds checking in
certain operations. An attacker could send a specially crafted PNG image and
cause a denial of service in applications linked against libpng. This issue
only affected Ubuntu 8.04 LTS. (CVE-2007-5268, CVE-2007-5269)

Tavis Ormandy discovered that libpng did not properly initialize memory. If a
user or automated system were tricked into opening a crafted PNG image, an
attacker could cause a denial of service via application crash, or possibly
execute arbitrary code with the privileges of the user invoking the program.
This issue did not affect Ubuntu 8.10. (CVE-2008-1382)

Harald van Dijk discovered an off-by-one error in libpng. An attacker could
could cause an application crash in programs using pngtest. (CVE-2008-3964)

It was discovered that libpng did not properly NULL terminate a keyword
string. An attacker could exploit this to set arbitrary memory locations to
zero. (CVE-2008-5907)

Glenn Randers-Pehrson discovered that libpng did not properly initialize
pointers. If a user or automated system were tricked into opening a crafted PNG
file, an attacker could cause a denial of service or possibly execute arbitrary
code with the privileges of the user invoking the program. (CVE-2009-0040)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libpng12-0                      1.2.8rel-5ubuntu0.4

Ubuntu 7.10:
  libpng12-0                      1.2.15~beta5-2ubuntu0.2

Ubuntu 8.04 LTS:
  libpng12-0                      1.2.15~beta5-3ubuntu0.1

Ubuntu 8.10:
  libpng12-0                      1.2.27-1ubuntu0.1

After a standard system upgrade you need to reboot your computer to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-730-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-730-1 (libpng)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.8rel-5ubuntu0.4", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-0", ver:"1.2.8rel-5ubuntu0.4", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-dev", ver:"1.2.8rel-5ubuntu0.4", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.15~beta5-2ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-0", ver:"1.2.15~beta5-2ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-dev", ver:"1.2.15~beta5-2ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.15~beta5-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-0", ver:"1.2.15~beta5-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-dev", ver:"1.2.15~beta5-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.27-1ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-0", ver:"1.2.27-1ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng12-dev", ver:"1.2.27-1ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
