###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wingate_http_proxy_serv_acl_bypass_vuln.nasl 760 2009-03-18 17:10:29Z mar $
#
# Qbik WinGate HTTP Proxy Server Access Controls Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900325);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0802");
  script_bugtraq_id(33858);
  script_name(english:"Qbik WinGate HTTP Proxy Server Access Controls Bypass Vulnerability");
  desc["english"] = "

  Overview: This host is running WinGate HTTP Proxy Server and is prone to
  access controls bypass vulnerability.

  Vulnerability Insight:
  This issue occurs when the proxy makes a forwarding decision based on the
  'Host' HTTP header instead of the destination IP address while the proxy
  server works in transparent interception mode.

  Impact:
  Successful exploitation will let the attacker obtain sensitive information
  i.e. Intranet webpage details.

  Impact Level: Application/Network

  Affected Software/OS:
  WinGate version 6.0 to 6.5.2 Build 1217.

  Fix: No solution or patch is available as on 26th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.wingate.com

  References:
  http://secunia.com/advisories/34020
  http://www.kb.cert.org/vuls/id/435052

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:C/I:N/A:N)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of WinGate");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("secpod_wingate_detect.nasl", "find_service.nes");
  script_require_keys("WinGate/Ver");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

GatePort = get_http_port(default:80);
if(!GatePort){
  exit(0);
}

banner = get_http_banner(port:GatePort);
if("WinGate" >< banner && "WinGate Engine" >!< banner)
{
  winGateVer = get_kb_item("WinGate/Ver");
  if(winGateVer != NULL)
  {
    # Check for version 6.5.2 build 1217 and prior
    if(version_in_range(version:winGateVer, test_version:"6.0",
                        test_version2:"6.5.2.1217")){
      security_hole(GatePort);
    }
  }
}
