###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ultravnc_mult_int_overflow_vuln_win.nasl 987 2009-02-27 17:40:29Z feb $
#
# UltraVNC ClientConnection Multiple Integer Overflow Vulnerabilities (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900471);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33568);
  script_cve_id("CVE-2009-0388");
  script_name(english:"UltraVNC ClientConnection Multiple Integer Overflow Vulnerabilities (Win)");
  desc["english"] = "

  Overview: This host is running UltraVNC and is prone to Multiple Integer
  Overflow Vulnerability.

  Vulnerability Insight:
  Multiple Integer Overflow due to signedness errors within the functions
  ClientConnection::CheckBufferSize and ClientConnection::CheckFileZipBufferSize
  in ClientConnection.cpp file fails to validate user input.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and may cause remote code execution to compromise
  the affected remote system.

  Impact level: Application/System

  Affected Software/OS:
  UltraVNC version prior to 1.0.5.4 on Windows.

  Fix:
  Upgrade to the latest version 1.0.5.4
  http://www.uvnc.com/download/1054

  References:
  http://milw0rm.com/exploits/7990
  http://secunia.com/advisories/33794

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of UltraVNC");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_ultravnc_detect_win.nasl", "find_service1.nasl");
  script_require_ports("Services/vnc", 5800, 5900);
  script_require_keys("UltraVNC/Win/Ver");
  exit(0);
}


include("version_func.inc");

vncPort = get_kb_item("Services/vnc");
if(!vncPort){
  vncPort = 5900;
}

if(get_port_state(vncPort))
{
  uvncVer = get_kb_item("UltraVNC/Win/Ver");
  if(!uvncVer){
    exit(0);
  }

  # Grep for UltraVNC version prior to 1.0.5.4
  if(version_is_less(version:uvncVer, test_version:"1.0.5.4")){
    security_hole(vncPort);
  }
}
