###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ultravnc_detect_win.nasl 987 2009-02-27 19:50:24Z feb $
#
# UltraVNC Version Detection (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900470);
  script_version("$Revision: 1.0 $");
  script_name(english:"UltraVNC Version Detection (Win)");
  desc["english"] = "
  Overview : This script finds the installed version of UltraVNC and
  saves the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of UltraVNC in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  uvncName = registry_get_sz(key:key + item, item:"DisplayName");
  if("UltraVNC" >< uvncName)
  {
    vncString = eregmatch(pattern:"UltraVNC v?([0-9.]+)", string:uvncName);
    if(vncString[1] != NULL){
      set_kb_item(name:"UltraVNC/Win/Ver", value:vncString[1]);
    }
    exit(0);
  }
}
