###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_raidenftpd_server_dos_vuln.nasl 1046 2009-02-25 11:50:29Z feb $
#
# RaidenFTPD Server CWD and MLST Command Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900511);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6186");
  script_bugtraq_id(31741);
  script_name(english:"RaidenFTPD Server CWD and MLST Command Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is running RaidenFTPD Server and is prone to Denial of
  Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to a boundary error when handling overly long requested
  directory names. As a result buffer overflow can be caused using specially
  crafted CWD and MLST commands.

  Impact:
  Successful exploitation will let the user crash the application to cause
  denial of service.

  Affected Software/OS:
  RaidenFTPD Server version 2.4.3620 and prior.

  Fix:Upgrade to the latest version.
  http://www.raidenftpd.com/en/

  References:
  http://secunia.com/advisories/32216
  http://www.milw0rm.com/exploits/6742

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 7.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of RaidenFTPD Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_raidenftpd_server_detect.nasl");
  script_require_ports("Services/ftp", 21);
  script_require_keys("RaidenFTPD/Ver");
  exit(0);
}


include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  exit(0);
}

if(!get_port_state(ftpPort)){
  exit(0);
}

rftpdVer = get_kb_item("RaidenFTPD/Ver");
if(!rftpdVer){
  exit(0);
}

if(version_is_less_equal(version:rftpdVer, test_version:"2.4.3620")){
  security_hole(ftpPort);
}
