###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openssl_mult_dos_vuln_win.nasl 2393 2009-05-22 12:10:29Z may $
#
# OpenSSL DTLS Packets Multiple DOS Vulnerabilities (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900654);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1377", "CVE-2009-1378","CVE-2009-1379");
  script_bugtraq_id(35001);
  script_name(english:"OpenSSL DTLS Packets Multiple DOS Vulnerabilities (win)");
  desc["english"] = "

  Overview: This host is running OpenSSL and is prone to Multiple Denial of
  Service Vulnerabilities

  Vulnerability Insight:
  Multiple flaws are due to,
  - The library does not limit the number of buffered DTLS records with a
    future epoch.
  - An error when processing DTLS messages can be exploited to exhaust all
    available memory by sending a large number of out of sequence handshake
    messages.
  - A use-after-free error in the 'dtls1_retrieve_buffered_fragment()' function
    can be exploited to cause a crash in a client context.

  Impact:
  Successful exploitation will let the attacker to cause denial-of-service
  conditions,crash the client,and exhaust all memory.

  Impact Level: System/Application

  Affected Software/OS:
  OpenSSL version 0.9.8 to version 0.9.8k on Windows.
  OpenSSL version 1.0.0 Beta2 and prior on Windows.

  Fix: Apply patches or upgrade to the latest version.
  For updates refer,http://www.slproweb.com/products/Win32OpenSSL.html

  References:
  http://secunia.com/advisories/35128
  http://cvs.openssl.org/chngview?cn=18188

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("gb_openssl_detect_win.nasl");
  script_require_keys("OpenSSL/Win/Ver");
  exit(0);
}


include("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Win/Ver");
if(!opensslVer){
  exit(0);
}

if(version_in_range(version:opensslVer, test_version:"0.9.8", test_version2:"0.9.8k")){
   security_warning(0);
}
