##############################################################################
#
#  Windows Messenger Could Allow Information Disclosure Vulnerability (955702)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/14
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0120
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900034);
 script_bugtraq_id(30551);
 script_cve_id("CVE-2008-0082");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Windows : Microsoft Bulletins");
 script_name(english:"Windows Messenger Could Allow Information Disclosure Vulnerability (955702)");
 script_summary(english:"Check for the Hotfix and version of Winndows Messenger");
 desc["english"] = "
 MS08-050

 Overview : This host has critical security update missing according to
 Microsoft Bulletin MS08-050.

 Vulnerability Insight :

        Issue is in the Messenger.UIAutomation.1 ActiveX control being marked
        safe-for-scripting, which allows changing state, obtain contact information
        and a user's login ID.

        Impact : Remote attackers can log on to a user's Messenger client as a user,
        and can initiate audio and video chat sessions without user interaction.

 Impact Level : Network

 Affected Software/OS :
        Windows Messenger 4.7 on MS Windows 2K/XP
        Windows Messenger 5.1 on MS Windows 2K/XP/2003

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link,
 http://www.microsoft.com/technet/security/bulletin/ms08-050.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-050.mspx

 CVSS Score :
        CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
        CVSS Temporal Score : 4.7
 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_reg.inc");
 include("secpod_smb_func.inc");

 if(hotfix_check_sp(xp:3, win2k:5, win2003:3) <= 0){
	 exit(0);
 }

 function get_version()
 {
	dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\Active Setup\Installed Components" +
                                      "\{5945c046-1e7d-11d1-bc44-00c04fd912be}",
                                  item:"KeyFileName");

        dllPath = dllPath - "msmsgs.exe" + "msgsc.dll";

        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
        file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

        name    =  kb_smb_name();
        login   =  kb_smb_login();
        pass    =  kb_smb_password();
        domain  =  kb_smb_domain();
        port    =  kb_smb_transport();

        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        r = smb_session_request(soc:soc, remote:name);
        if(!r)
        {
                close(soc);
                exit(0);
        } 

        prot = smb_neg_prot(soc:soc);
        if(!prot)
        {
                close(soc);
                exit(0);
        }

        r = smb_session_setup(soc:soc, login:login, password:pass,
                              domain:domain, prot:prot);
        if(!r)
        {
                close(soc);
                exit(0);
        }

        uid = session_extract_uid(reply:r);

        r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
        tid = tconx_extract_tid(reply:r);
        if(!tid)
        {
                close(soc);
                exit(0);
        }

        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
        if(!fid)
        {
                close(soc);
                exit(0);
        }

        v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:60000);
        return v;
 }

 if(!registry_key_exists(key:"SOFTWARE\Clients\IM\Windows Messenger")){
	exit(0);
 }

 msngrVer = registry_get_sz(key:"SOFTWARE\Microsoft\Active Setup\Installed Components" +
		                "\{5945c046-1e7d-11d1-bc44-00c04fd912be}",
		  	    item:"Version");
 if(!msngrVer){
	exit(0);
 }

 if("5.1" >< msngrVer)
 {
	if(hotfix_missing(name:"899283") == 0){
                exit(0);
        }

	vers = get_version();
        if(vers == NULL){
                exit(0);
        }

	# Grep < 5.1.0715
        if(ereg(pattern:"^5\.1\.0?([0-6]?[0-9]?[0-9]|70[0-9]|71[0-4])0?$", string:vers)){
                security_warning(0);
	}
        exit(0);
 }

 else if("4,7" >< msngrVer)
 {
 	if(hotfix_check_sp(xp:4) > 0)
 	{
		if(hotfix_missing(name:"946648") == 0){
                	exit(0);
        	}
	}

	else if(hotfix_check_sp(win2003:3) > 0)
	{
		if(hotfix_missing(name:"954723") == 0){
                        exit(0);
                }
	}

        vers = get_version();
        if(vers == NULL){
               	exit(0);
        }

	# Grep < 4.7.3002
	if(ereg(pattern:"^4\.7\.([0-2]?[0-9]?[0-9]?[0-9]|300[01])0?$", string:vers)){
               	security_warning(0);
	}
 }
