###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_filezilla_server_bof_vuln.nasl 927 2009-03-20 12:50:29Z mar $
#
# FileZilla Server Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900519);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0884");
  script_bugtraq_id(34006);
  script_name(english:"FileZilla Server Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running FileZilla Server and is prone to buffer
  overflow vulnerability.

  Vulnerability Insight:
  The flaw is generated due to an error in unspecified vectors while
  handling SSL/TLS packets.

  Impact:
  Successful exploitation will let the attacker crash the application to
  cause denial of service.

  Affected Software/OS:
  FileZilla Server versions prior to 0.9.31

  Fix:Upgrade to FileZilla Server version 0.9.31
  http://filezilla-project.org/index.php

  References:
  http://secunia.com/advisories/34089
  http://sourceforge.net/project/shownotes.php?release_id=665428

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of FileZilla Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_filezilla_server_detect.nasl");
  script_require_keys("FileZilla/Serv/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("version_func.inc");

fzillaPort = get_kb_item("Services/ftp");
if(!fzillaPort){
  exit(0);
}

filezillaVer = get_kb_item("FileZilla/Serv/Ver");
if(!filezillaVer){
  exit(0);
}

if(version_is_less(version:filezillaVer, test_version:"0.9.31")){
  security_warning(fzillaPort);
}
