##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_event_diary_mult_vuln.nasl 883 2009-01-27 15:10:29Z jan $
#
# ASP-Dev XM Event Diary Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900452);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5923", "CVE-2008-5924", "CVE-2008-5925");
  script_bugtraq_id(32809);
  script_name(english:"ASP-Dev XM Event Diary Multiple Vulnerabilities");
  desc["english"] = "

  Overview: The host is running ASP-Dev XM Events Diary and prone to multiple
  vulnerabilities.

  Vulnerabilities Insight:
  - Input passed to the 'cat' parameter in 'default.asp' and 'diary_viewC.asp'
    are not properly sanitised before being used in SQL queries.
  - Insufficient access control to the database file 'diary.mdb' which is being
    used for Events Diary web application.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  in the context of the web application or can execute sql injection attack
  to gain sensitive information about the database engine and table structures.

  Impact Level: Application

  Affected Software/OS:
  ASP-Dev XM Event Diary Multiple Vulnerabilities

  Fix: No solution or patch is available as on 30th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://asp-dev.com/main.asp?page=42

  References:
  http://secunia.com/advisories/33152

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for ASP-Dev XM Event Diary vulnerabilities");
  script_category(ACT_ATTACK);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  port = 80;
}

request = string("GET /diary/default.asp \r\n");
response = http_keepalive_send_recv(port:port, data:request);

if("Powered by ASP-DEv XM Diary" >< response)
{
  request = string("GET /diary/default.asp?cat=testing' \r\n");
  response = http_keepalive_send_recv(port:port, data:request);
  if("Microsoft JET Database Engine" >< response &&
     "Syntax error in string" >< response){
    security_hole(port);
  }
}
